/*     */ package org.jboss.util.xml.catalog;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.MissingResourceException;
/*     */ import java.util.PropertyResourceBundle;
/*     */ import java.util.ResourceBundle;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.Vector;
/*     */ import org.jboss.util.xml.catalog.helpers.BootstrapResolver;
/*     */ import org.jboss.util.xml.catalog.helpers.Debug;
/*     */ 
/*     */ public class CatalogManager
/*     */ {
/* 162 */   private static String pFiles = "xml.catalog.files";
/* 163 */   private static String pVerbosity = "xml.catalog.verbosity";
/* 164 */   private static String pPrefer = "xml.catalog.prefer";
/* 165 */   private static String pStatic = "xml.catalog.staticCatalog";
/* 166 */   private static String pAllowPI = "xml.catalog.allowPI";
/* 167 */   private static String pClassname = "xml.catalog.className";
/* 168 */   private static String pIgnoreMissing = "xml.catalog.ignoreMissing";
/*     */ 
/* 171 */   private static CatalogManager staticManager = new CatalogManager();
/*     */ 
/* 174 */   private BootstrapResolver bResolver = new BootstrapResolver();
/*     */ 
/* 177 */   private boolean ignoreMissingProperties = (System.getProperty(pIgnoreMissing) != null) || (System.getProperty(pFiles) != null);
/*     */   private ResourceBundle resources;
/* 185 */   private String propertyFile = "CatalogManager.properties";
/*     */ 
/* 188 */   private URL propertyFileURI = null;
/*     */ 
/* 191 */   private String defaultCatalogFiles = "./xcatalog";
/*     */ 
/* 194 */   private String catalogFiles = null;
/*     */ 
/* 197 */   private boolean fromPropertiesFile = false;
/*     */ 
/* 200 */   private int defaultVerbosity = 1;
/*     */ 
/* 203 */   private Integer verbosity = null;
/*     */ 
/* 206 */   private boolean defaultPreferPublic = true;
/*     */ 
/* 209 */   private Boolean preferPublic = null;
/*     */ 
/* 212 */   private boolean defaultUseStaticCatalog = true;
/*     */ 
/* 215 */   private Boolean useStaticCatalog = null;
/*     */ 
/* 218 */   private static Catalog staticCatalog = null;
/*     */ 
/* 221 */   private boolean defaultOasisXMLCatalogPI = true;
/*     */ 
/* 224 */   private Boolean oasisXMLCatalogPI = null;
/*     */ 
/* 227 */   private boolean defaultRelativeCatalogs = true;
/*     */ 
/* 230 */   private Boolean relativeCatalogs = null;
/*     */ 
/* 233 */   private String catalogClassName = null;
/*     */ 
/* 240 */   public Debug debug = null;
/*     */ 
/*     */   public CatalogManager()
/*     */   {
/* 244 */     this.debug = new Debug();
/*     */   }
/*     */ 
/*     */   public CatalogManager(String propertyFile)
/*     */   {
/* 254 */     this.propertyFile = propertyFile;
/*     */ 
/* 256 */     this.debug = new Debug();
/*     */   }
/*     */ 
/*     */   public void setBootstrapResolver(BootstrapResolver resolver)
/*     */   {
/* 266 */     this.bResolver = resolver;
/*     */   }
/*     */ 
/*     */   public BootstrapResolver getBootstrapResolver()
/*     */   {
/* 271 */     return this.bResolver;
/*     */   }
/*     */ 
/*     */   private synchronized void readProperties()
/*     */   {
/*     */     try
/*     */     {
/* 280 */       this.propertyFileURI = CatalogManager.class.getResource("/" + this.propertyFile);
/* 281 */       InputStream in = CatalogManager.class.getResourceAsStream("/" + this.propertyFile);
/*     */ 
/* 283 */       if (in == null) {
/* 284 */         if (!this.ignoreMissingProperties) {
/* 285 */           System.err.println("Cannot find " + this.propertyFile);
/*     */ 
/* 287 */           this.ignoreMissingProperties = true;
/*     */         }
/* 289 */         return;
/*     */       }
/* 291 */       this.resources = new PropertyResourceBundle(in);
/*     */     } catch (MissingResourceException mre) {
/* 293 */       if (!this.ignoreMissingProperties)
/* 294 */         System.err.println("Cannot read " + this.propertyFile);
/*     */     }
/*     */     catch (IOException e) {
/* 297 */       if (!this.ignoreMissingProperties) {
/* 298 */         System.err.println("Failure trying to read " + this.propertyFile);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 305 */     if (this.verbosity == null)
/*     */       try {
/* 307 */         String verbStr = this.resources.getString("verbosity");
/* 308 */         int verb = Integer.parseInt(verbStr.trim());
/* 309 */         this.debug.setDebug(verb);
/* 310 */         this.verbosity = new Integer(verb);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */   }
/*     */ 
/*     */   public static CatalogManager getStaticManager()
/*     */   {
/* 321 */     return staticManager;
/*     */   }
/*     */ 
/*     */   public boolean getIgnoreMissingProperties()
/*     */   {
/* 332 */     return this.ignoreMissingProperties;
/*     */   }
/*     */ 
/*     */   public void setIgnoreMissingProperties(boolean ignore)
/*     */   {
/* 343 */     this.ignoreMissingProperties = ignore;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void ignoreMissingProperties(boolean ignore)
/*     */   {
/* 356 */     setIgnoreMissingProperties(ignore);
/*     */   }
/*     */ 
/*     */   private int queryVerbosity()
/*     */   {
/* 366 */     String verbStr = System.getProperty(pVerbosity);
/*     */ 
/* 368 */     if (verbStr == null) {
/* 369 */       if (this.resources == null) readProperties();
/* 370 */       if (this.resources == null) return this.defaultVerbosity; try
/*     */       {
/* 372 */         verbStr = this.resources.getString("verbosity");
/*     */       } catch (MissingResourceException e) {
/* 374 */         return this.defaultVerbosity;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 379 */       int verb = Integer.parseInt(verbStr.trim());
/* 380 */       return verb;
/*     */     } catch (Exception e) {
/* 382 */       System.err.println("Cannot parse verbosity: \"" + verbStr + "\"");
/* 383 */     }return this.defaultVerbosity;
/*     */   }
/*     */ 
/*     */   public int getVerbosity()
/*     */   {
/* 391 */     if (this.verbosity == null) {
/* 392 */       this.verbosity = new Integer(queryVerbosity());
/*     */     }
/*     */ 
/* 395 */     return this.verbosity.intValue();
/*     */   }
/*     */ 
/*     */   public void setVerbosity(int verbosity)
/*     */   {
/* 402 */     this.verbosity = new Integer(verbosity);
/* 403 */     this.debug.setDebug(verbosity);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public int verbosity()
/*     */   {
/* 412 */     return getVerbosity();
/*     */   }
/*     */ 
/*     */   private boolean queryRelativeCatalogs()
/*     */   {
/* 422 */     if (this.resources == null) readProperties();
/*     */ 
/* 424 */     if (this.resources == null) return this.defaultRelativeCatalogs;
/*     */     try
/*     */     {
/* 427 */       String allow = this.resources.getString("relative-catalogs");
/* 428 */       return (allow.equalsIgnoreCase("true")) || (allow.equalsIgnoreCase("yes")) || (allow.equalsIgnoreCase("1"));
/*     */     }
/*     */     catch (MissingResourceException e) {
/*     */     }
/* 432 */     return this.defaultRelativeCatalogs;
/*     */   }
/*     */ 
/*     */   public boolean getRelativeCatalogs()
/*     */   {
/* 457 */     if (this.relativeCatalogs == null) {
/* 458 */       this.relativeCatalogs = new Boolean(queryRelativeCatalogs());
/*     */     }
/*     */ 
/* 461 */     return this.relativeCatalogs.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setRelativeCatalogs(boolean relative)
/*     */   {
/* 473 */     this.relativeCatalogs = new Boolean(relative);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public boolean relativeCatalogs()
/*     */   {
/* 482 */     return getRelativeCatalogs();
/*     */   }
/*     */ 
/*     */   private String queryCatalogFiles()
/*     */   {
/* 491 */     String catalogList = System.getProperty(pFiles);
/* 492 */     this.fromPropertiesFile = false;
/*     */ 
/* 494 */     if (catalogList == null) {
/* 495 */       if (this.resources == null) readProperties();
/* 496 */       if (this.resources != null) {
/*     */         try {
/* 498 */           catalogList = this.resources.getString("catalogs");
/* 499 */           this.fromPropertiesFile = true;
/*     */         } catch (MissingResourceException e) {
/* 501 */           System.err.println(this.propertyFile + ": catalogs not found.");
/* 502 */           catalogList = null;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 507 */     if (catalogList == null) {
/* 508 */       catalogList = this.defaultCatalogFiles;
/*     */     }
/*     */ 
/* 511 */     return catalogList;
/*     */   }
/*     */ 
/*     */   public Vector getCatalogFiles()
/*     */   {
/* 521 */     if (this.catalogFiles == null) {
/* 522 */       this.catalogFiles = queryCatalogFiles();
/*     */     }
/*     */ 
/* 525 */     StringTokenizer files = new StringTokenizer(this.catalogFiles, ";");
/* 526 */     Vector catalogs = new Vector();
/* 527 */     while (files.hasMoreTokens()) {
/* 528 */       String catalogFile = files.nextToken();
/* 529 */       URL absURI = null;
/*     */ 
/* 531 */       if ((this.fromPropertiesFile) && (!relativeCatalogs())) {
/*     */         try {
/* 533 */           absURI = new URL(this.propertyFileURI, catalogFile);
/* 534 */           catalogFile = absURI.toString();
/*     */         } catch (MalformedURLException mue) {
/* 536 */           absURI = null;
/*     */         }
/*     */       }
/*     */ 
/* 540 */       catalogs.add(catalogFile);
/*     */     }
/*     */ 
/* 543 */     return catalogs;
/*     */   }
/*     */ 
/*     */   public void setCatalogFiles(String fileList)
/*     */   {
/* 550 */     this.catalogFiles = fileList;
/* 551 */     this.fromPropertiesFile = false;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public Vector catalogFiles()
/*     */   {
/* 563 */     return getCatalogFiles();
/*     */   }
/*     */ 
/*     */   private boolean queryPreferPublic()
/*     */   {
/* 576 */     String prefer = System.getProperty(pPrefer);
/*     */ 
/* 578 */     if (prefer == null) {
/* 579 */       if (this.resources == null) readProperties();
/* 580 */       if (this.resources == null) return this.defaultPreferPublic; try
/*     */       {
/* 582 */         prefer = this.resources.getString("prefer");
/*     */       } catch (MissingResourceException e) {
/* 584 */         return this.defaultPreferPublic;
/*     */       }
/*     */     }
/*     */ 
/* 588 */     if (prefer == null) {
/* 589 */       return this.defaultPreferPublic;
/*     */     }
/*     */ 
/* 592 */     return prefer.equalsIgnoreCase("public");
/*     */   }
/*     */ 
/*     */   public boolean getPreferPublic()
/*     */   {
/* 601 */     if (this.preferPublic == null) {
/* 602 */       this.preferPublic = new Boolean(queryPreferPublic());
/*     */     }
/* 604 */     return this.preferPublic.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setPreferPublic(boolean preferPublic)
/*     */   {
/* 613 */     this.preferPublic = new Boolean(preferPublic);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public boolean preferPublic()
/*     */   {
/* 624 */     return getPreferPublic();
/*     */   }
/*     */ 
/*     */   private boolean queryUseStaticCatalog()
/*     */   {
/* 637 */     String staticCatalog = System.getProperty(pStatic);
/*     */ 
/* 639 */     if (this.useStaticCatalog == null) {
/* 640 */       if (this.resources == null) readProperties();
/* 641 */       if (this.resources == null) return this.defaultUseStaticCatalog; try
/*     */       {
/* 643 */         staticCatalog = this.resources.getString("static-catalog");
/*     */       } catch (MissingResourceException e) {
/* 645 */         return this.defaultUseStaticCatalog;
/*     */       }
/*     */     }
/*     */ 
/* 649 */     if (staticCatalog == null) {
/* 650 */       return this.defaultUseStaticCatalog;
/*     */     }
/*     */ 
/* 653 */     return (staticCatalog.equalsIgnoreCase("true")) || (staticCatalog.equalsIgnoreCase("yes")) || (staticCatalog.equalsIgnoreCase("1"));
/*     */   }
/*     */ 
/*     */   public boolean getUseStaticCatalog()
/*     */   {
/* 662 */     if (this.useStaticCatalog == null) {
/* 663 */       this.useStaticCatalog = new Boolean(queryUseStaticCatalog());
/*     */     }
/*     */ 
/* 666 */     return this.useStaticCatalog.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setUseStaticCatalog(boolean useStatic)
/*     */   {
/* 673 */     this.useStaticCatalog = new Boolean(useStatic);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public boolean staticCatalog()
/*     */   {
/* 682 */     return getUseStaticCatalog();
/*     */   }
/*     */ 
/*     */   public Catalog getPrivateCatalog()
/*     */   {
/* 691 */     Catalog catalog = staticCatalog;
/*     */ 
/* 693 */     if (this.useStaticCatalog == null) {
/* 694 */       this.useStaticCatalog = new Boolean(getUseStaticCatalog());
/*     */     }
/*     */ 
/* 697 */     if ((catalog == null) || (!this.useStaticCatalog.booleanValue()))
/*     */     {
/*     */       try {
/* 700 */         String catalogClassName = getCatalogClassName();
/*     */ 
/* 702 */         if (catalogClassName == null)
/* 703 */           catalog = new Catalog();
/*     */         else {
/*     */           try {
/* 706 */             catalog = (Catalog)Class.forName(catalogClassName).newInstance();
/*     */           } catch (ClassNotFoundException cnfe) {
/* 708 */             this.debug.message(1, "Catalog class named '" + catalogClassName + "' could not be found. Using default.");
/*     */ 
/* 711 */             catalog = new Catalog();
/*     */           } catch (ClassCastException cnfe) {
/* 713 */             this.debug.message(1, "Class named '" + catalogClassName + "' is not a Catalog. Using default.");
/*     */ 
/* 716 */             catalog = new Catalog();
/*     */           }
/*     */         }
/*     */ 
/* 720 */         catalog.setCatalogManager(this);
/* 721 */         catalog.setupReaders();
/* 722 */         catalog.loadSystemCatalogs();
/*     */       } catch (Exception ex) {
/* 724 */         ex.printStackTrace();
/*     */       }
/*     */ 
/* 727 */       if (this.useStaticCatalog.booleanValue()) {
/* 728 */         staticCatalog = catalog;
/*     */       }
/*     */     }
/*     */ 
/* 732 */     return catalog;
/*     */   }
/*     */ 
/*     */   public Catalog getCatalog()
/*     */   {
/* 742 */     Catalog catalog = staticCatalog;
/*     */ 
/* 744 */     if (this.useStaticCatalog == null) {
/* 745 */       this.useStaticCatalog = new Boolean(getUseStaticCatalog());
/*     */     }
/*     */ 
/* 748 */     if ((catalog == null) || (!this.useStaticCatalog.booleanValue())) {
/* 749 */       catalog = getPrivateCatalog();
/* 750 */       if (this.useStaticCatalog.booleanValue()) {
/* 751 */         staticCatalog = catalog;
/*     */       }
/*     */     }
/*     */ 
/* 755 */     return catalog;
/*     */   }
/*     */ 
/*     */   public boolean queryAllowOasisXMLCatalogPI()
/*     */   {
/* 768 */     String allow = System.getProperty(pAllowPI);
/*     */ 
/* 770 */     if (allow == null) {
/* 771 */       if (this.resources == null) readProperties();
/* 772 */       if (this.resources == null) return this.defaultOasisXMLCatalogPI; try
/*     */       {
/* 774 */         allow = this.resources.getString("allow-oasis-xml-catalog-pi");
/*     */       } catch (MissingResourceException e) {
/* 776 */         return this.defaultOasisXMLCatalogPI;
/*     */       }
/*     */     }
/*     */ 
/* 780 */     if (allow == null) {
/* 781 */       return this.defaultOasisXMLCatalogPI;
/*     */     }
/*     */ 
/* 784 */     return (allow.equalsIgnoreCase("true")) || (allow.equalsIgnoreCase("yes")) || (allow.equalsIgnoreCase("1"));
/*     */   }
/*     */ 
/*     */   public boolean getAllowOasisXMLCatalogPI()
/*     */   {
/* 793 */     if (this.oasisXMLCatalogPI == null) {
/* 794 */       this.oasisXMLCatalogPI = new Boolean(queryAllowOasisXMLCatalogPI());
/*     */     }
/*     */ 
/* 797 */     return this.oasisXMLCatalogPI.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setAllowOasisXMLCatalogPI(boolean allowPI)
/*     */   {
/* 804 */     this.oasisXMLCatalogPI = new Boolean(allowPI);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public boolean allowOasisXMLCatalogPI()
/*     */   {
/* 813 */     return getAllowOasisXMLCatalogPI();
/*     */   }
/*     */ 
/*     */   public String queryCatalogClassName()
/*     */   {
/* 821 */     String className = System.getProperty(pClassname);
/*     */ 
/* 823 */     if (className == null) {
/* 824 */       if (this.resources == null) readProperties();
/* 825 */       if (this.resources == null) return null; try
/*     */       {
/* 827 */         return this.resources.getString("catalog-class-name");
/*     */       } catch (MissingResourceException e) {
/* 829 */         return null;
/*     */       }
/*     */     }
/*     */ 
/* 833 */     return className;
/*     */   }
/*     */ 
/*     */   public String getCatalogClassName()
/*     */   {
/* 840 */     if (this.catalogClassName == null) {
/* 841 */       this.catalogClassName = queryCatalogClassName();
/*     */     }
/*     */ 
/* 844 */     return this.catalogClassName;
/*     */   }
/*     */ 
/*     */   public void setCatalogClassName(String className)
/*     */   {
/* 851 */     this.catalogClassName = className;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public String catalogClassName()
/*     */   {
/* 860 */     return getCatalogClassName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.CatalogManager
 * JD-Core Version:    0.6.0
 */