/*     */ package org.jboss.util.xml.catalog;
/*     */ 
/*     */ public class CatalogException extends Exception
/*     */ {
/*     */   public static final int WRAPPER = 1;
/*     */   public static final int INVALID_ENTRY = 2;
/*     */   public static final int INVALID_ENTRY_TYPE = 3;
/*     */   public static final int NO_XML_PARSER = 4;
/*     */   public static final int UNKNOWN_FORMAT = 5;
/*     */   public static final int UNPARSEABLE = 6;
/*     */   public static final int PARSE_FAILED = 7;
/*  91 */   private Exception exception = null;
/*  92 */   private int exceptionType = 0;
/*     */ 
/*     */   public CatalogException(int type, String message)
/*     */   {
/* 101 */     super(message);
/* 102 */     this.exceptionType = type;
/* 103 */     this.exception = null;
/*     */   }
/*     */ 
/*     */   public CatalogException(int type)
/*     */   {
/* 112 */     super("Catalog Exception " + type);
/* 113 */     this.exceptionType = type;
/* 114 */     this.exception = null;
/*     */   }
/*     */ 
/*     */   public CatalogException(Exception e)
/*     */   {
/* 128 */     this.exceptionType = 1;
/* 129 */     this.exception = e;
/*     */   }
/*     */ 
/*     */   public CatalogException(String message, Exception e)
/*     */   {
/* 142 */     super(message);
/* 143 */     this.exceptionType = 1;
/* 144 */     this.exception = e;
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 158 */     String message = super.getMessage();
/*     */ 
/* 160 */     if ((message == null) && (this.exception != null)) {
/* 161 */       return this.exception.getMessage();
/*     */     }
/* 163 */     return message;
/*     */   }
/*     */ 
/*     */   public Exception getException()
/*     */   {
/* 174 */     return this.exception;
/*     */   }
/*     */ 
/*     */   public int getExceptionType()
/*     */   {
/* 184 */     return this.exceptionType;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 194 */     if (this.exception != null) {
/* 195 */       return this.exception.toString();
/*     */     }
/* 197 */     return super.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.CatalogException
 * JD-Core Version:    0.6.0
 */