/*     */ package org.jboss.util.xml.catalog;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class CatalogEntry
/*     */ {
/*  90 */   protected static int nextEntry = 0;
/*     */ 
/*  97 */   protected static Hashtable entryTypes = new Hashtable();
/*     */ 
/* 101 */   protected static Vector entryArgs = new Vector();
/*     */ 
/* 176 */   protected int entryType = 0;
/*     */ 
/* 179 */   protected Vector args = null;
/*     */ 
/*     */   public static int addEntryType(String name, int numArgs)
/*     */   {
/* 115 */     entryTypes.put(name, new Integer(nextEntry));
/* 116 */     entryArgs.add(nextEntry, new Integer(numArgs));
/* 117 */     nextEntry += 1;
/*     */ 
/* 119 */     return nextEntry - 1;
/*     */   }
/*     */ 
/*     */   public static int getEntryType(String name)
/*     */     throws CatalogException
/*     */   {
/* 132 */     if (!entryTypes.containsKey(name)) {
/* 133 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/* 136 */     Integer iType = (Integer)entryTypes.get(name);
/*     */ 
/* 138 */     if (iType == null) {
/* 139 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/* 142 */     return iType.intValue();
/*     */   }
/*     */ 
/*     */   public static int getEntryArgCount(String name)
/*     */     throws CatalogException
/*     */   {
/* 155 */     return getEntryArgCount(getEntryType(name));
/*     */   }
/*     */ 
/*     */   public static int getEntryArgCount(int type)
/*     */     throws CatalogException
/*     */   {
/*     */     try
/*     */     {
/* 168 */       Integer iArgs = (Integer)entryArgs.get(type);
/* 169 */       return iArgs.intValue(); } catch (ArrayIndexOutOfBoundsException e) {
/*     */     }
/* 171 */     throw new CatalogException(3);
/*     */   }
/*     */ 
/*     */   public CatalogEntry()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CatalogEntry(String name, Vector args)
/*     */     throws CatalogException
/*     */   {
/* 198 */     Integer iType = (Integer)entryTypes.get(name);
/*     */ 
/* 200 */     if (iType == null) {
/* 201 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/* 204 */     int type = iType.intValue();
/*     */     try
/*     */     {
/* 207 */       Integer iArgs = (Integer)entryArgs.get(type);
/* 208 */       if (iArgs.intValue() != args.size())
/* 209 */         throw new CatalogException(2);
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e) {
/* 212 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/* 215 */     this.entryType = type;
/* 216 */     this.args = args;
/*     */   }
/*     */ 
/*     */   public CatalogEntry(int type, Vector args)
/*     */     throws CatalogException
/*     */   {
/*     */     try
/*     */     {
/* 232 */       Integer iArgs = (Integer)entryArgs.get(type);
/* 233 */       if (iArgs.intValue() != args.size())
/* 234 */         throw new CatalogException(2);
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e) {
/* 237 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/* 240 */     this.entryType = type;
/* 241 */     this.args = args;
/*     */   }
/*     */ 
/*     */   public int getEntryType()
/*     */   {
/* 250 */     return this.entryType;
/*     */   }
/*     */ 
/*     */   public String getEntryArg(int argNum)
/*     */   {
/*     */     try
/*     */     {
/* 262 */       String arg = (String)this.args.get(argNum);
/* 263 */       return arg; } catch (ArrayIndexOutOfBoundsException e) {
/*     */     }
/* 265 */     return null;
/*     */   }
/*     */ 
/*     */   public void setEntryArg(int argNum, String newspec)
/*     */     throws ArrayIndexOutOfBoundsException
/*     */   {
/* 284 */     this.args.set(argNum, newspec);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.CatalogEntry
 * JD-Core Version:    0.6.0
 */