/*     */ package org.jboss.util.xml;
/*     */ 
/*     */ import java.io.Writer;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class XmlHelper
/*     */ {
/*     */   public static void write(Writer out, Document dom)
/*     */     throws Exception
/*     */   {
/*  44 */     new DOMWriter(out).setPrettyprint(true).print(dom);
/*     */   }
/*     */ 
/*     */   public static Iterator getChildrenByTagName(Element element, String tagName)
/*     */   {
/*  58 */     if (element == null) return null;
/*     */ 
/*  62 */     NodeList children = element.getChildNodes();
/*  63 */     ArrayList goodChildren = new ArrayList();
/*  64 */     for (int i = 0; i < children.getLength(); i++) {
/*  65 */       Node currentChild = children.item(i);
/*  66 */       if ((currentChild.getNodeType() != 1) || (!((Element)currentChild).getTagName().equals(tagName)))
/*     */         continue;
/*  68 */       goodChildren.add((Element)currentChild);
/*     */     }
/*     */ 
/*  71 */     return goodChildren.iterator();
/*     */   }
/*     */ 
/*     */   public static Element getUniqueChild(Element element, String tagName)
/*     */     throws Exception
/*     */   {
/*  88 */     Iterator goodChildren = getChildrenByTagName(element, tagName);
/*     */ 
/*  90 */     if ((goodChildren != null) && (goodChildren.hasNext())) {
/*  91 */       Element child = (Element)goodChildren.next();
/*  92 */       if (goodChildren.hasNext()) {
/*  93 */         throw new Exception("expected only one " + tagName + " tag");
/*     */       }
/*     */ 
/*  96 */       return child;
/*     */     }
/*  98 */     throw new Exception("expected one " + tagName + " tag");
/*     */   }
/*     */ 
/*     */   public static Element getOptionalChild(Element element, String tagName)
/*     */     throws Exception
/*     */   {
/* 115 */     return getOptionalChild(element, tagName, null);
/*     */   }
/*     */ 
/*     */   public static Element getOptionalChild(Element element, String tagName, Element defaultElement)
/*     */     throws Exception
/*     */   {
/* 134 */     Iterator goodChildren = getChildrenByTagName(element, tagName);
/*     */ 
/* 136 */     if ((goodChildren != null) && (goodChildren.hasNext())) {
/* 137 */       Element child = (Element)goodChildren.next();
/* 138 */       if (goodChildren.hasNext()) {
/* 139 */         throw new Exception("expected only one " + tagName + " tag");
/*     */       }
/*     */ 
/* 142 */       return child;
/*     */     }
/* 144 */     return defaultElement;
/*     */   }
/*     */ 
/*     */   public static String getElementContent(Element element)
/*     */     throws Exception
/*     */   {
/* 157 */     return getElementContent(element, null);
/*     */   }
/*     */ 
/*     */   public static String getElementContent(Element element, String defaultStr)
/*     */     throws Exception
/*     */   {
/* 170 */     if (element == null) {
/* 171 */       return defaultStr;
/*     */     }
/* 173 */     NodeList children = element.getChildNodes();
/* 174 */     String result = "";
/* 175 */     for (int i = 0; i < children.getLength(); i++)
/*     */     {
/* 177 */       if ((children.item(i).getNodeType() == 3) || (children.item(i).getNodeType() == 4))
/*     */       {
/* 180 */         result = result + children.item(i).getNodeValue();
/*     */       }
/* 182 */       else if (children.item(i).getNodeType() != 8)
/*     */         {
/*     */           continue;
/*     */         }
/*     */     }
/* 187 */     return result.trim();
/*     */   }
/*     */ 
/*     */   public static String getUniqueChildContent(Element element, String tagName)
/*     */     throws Exception
/*     */   {
/* 201 */     return getElementContent(getUniqueChild(element, tagName));
/*     */   }
/*     */ 
/*     */   public static String getOptionalChildContent(Element element, String tagName)
/*     */     throws Exception
/*     */   {
/* 215 */     return getElementContent(getOptionalChild(element, tagName));
/*     */   }
/*     */ 
/*     */   public static boolean getOptionalChildBooleanContent(Element element, String name) throws Exception
/*     */   {
/* 220 */     Element child = getOptionalChild(element, name);
/* 221 */     if (child != null)
/*     */     {
/* 223 */       String value = getElementContent(child).toLowerCase();
/* 224 */       return (value.equals("true")) || (value.equals("yes"));
/*     */     }
/*     */ 
/* 227 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.XmlHelper
 * JD-Core Version:    0.6.0
 */