/*     */ package org.jboss.util.xml;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.Text;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public final class DOMUtils
/*     */ {
/*  59 */   private static Logger log = Logger.getLogger(DOMUtils.class);
/*     */ 
/*  62 */   private static ThreadLocal documentThreadLocal = new ThreadLocal();
/*  63 */   private static ThreadLocal builderThreadLocal = new ThreadLocal()
/*     */   {
/*     */     protected Object initialValue() {
/*     */       try {
/*  67 */         DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/*  68 */         factory.setValidating(false);
/*  69 */         factory.setNamespaceAware(true);
/*  70 */         DocumentBuilder builder = factory.newDocumentBuilder();
/*  71 */         builder.setEntityResolver(new JBossEntityResolver());
/*  72 */         return builder;
/*     */       }
/*     */       catch (ParserConfigurationException e) {
/*     */       }
/*  76 */       throw new RuntimeException("Failed to create DocumentBuilder", e);
/*     */     }
/*  63 */   };
/*     */ 
/*     */   public static DocumentBuilder getDocumentBuilder()
/*     */   {
/*  90 */     DocumentBuilder builder = (DocumentBuilder)builderThreadLocal.get();
/*  91 */     return builder;
/*     */   }
/*     */ 
/*     */   public static Element parse(String xmlString)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 100 */       return parse(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 104 */       log.error("Cannot parse: " + xmlString);
/* 105 */     }throw e;
/*     */   }
/*     */ 
/*     */   public static Element parse(InputStream xmlStream)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 115 */       Document doc = getDocumentBuilder().parse(xmlStream);
/* 116 */       Element root = doc.getDocumentElement();
/* 117 */       return root;
/*     */     }
/*     */     catch (SAXException e) {
/*     */     }
/* 121 */     throw new IOException(e.toString());
/*     */   }
/*     */ 
/*     */   public static Element parse(InputSource source)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 131 */       Document doc = getDocumentBuilder().parse(source);
/* 132 */       Element root = doc.getDocumentElement();
/* 133 */       return root;
/*     */     }
/*     */     catch (SAXException e) {
/*     */     }
/* 137 */     throw new IOException(e.toString());
/*     */   }
/*     */ 
/*     */   public static Element createElement(String localPart)
/*     */   {
/* 145 */     Document doc = getOwnerDocument();
/* 146 */     log.trace("createElement {}" + localPart);
/* 147 */     return doc.createElement(localPart);
/*     */   }
/*     */ 
/*     */   public static Element createElement(String localPart, String prefix)
/*     */   {
/* 154 */     Document doc = getOwnerDocument();
/* 155 */     log.trace("createElement {}" + prefix + ":" + localPart);
/* 156 */     return doc.createElement(prefix + ":" + localPart);
/*     */   }
/*     */ 
/*     */   public static Element createElement(String localPart, String prefix, String uri)
/*     */   {
/* 163 */     Document doc = getOwnerDocument();
/* 164 */     if ((prefix == null) || (prefix.length() == 0))
/*     */     {
/* 166 */       log.trace("createElement {" + uri + "}" + localPart);
/* 167 */       return doc.createElementNS(uri, localPart);
/*     */     }
/*     */ 
/* 171 */     log.trace("createElement {" + uri + "}" + prefix + ":" + localPart);
/* 172 */     return doc.createElementNS(uri, prefix + ":" + localPart);
/*     */   }
/*     */ 
/*     */   public static Element createElement(QName qname)
/*     */   {
/* 180 */     return createElement(qname.getLocalPart(), qname.getPrefix(), qname.getNamespaceURI());
/*     */   }
/*     */ 
/*     */   public static Text createTextNode(String value)
/*     */   {
/* 187 */     Document doc = getOwnerDocument();
/* 188 */     return doc.createTextNode(value);
/*     */   }
/*     */ 
/*     */   public static QName getElementQName(Element el)
/*     */   {
/* 195 */     String qualifiedName = el.getNodeName();
/* 196 */     return resolveQName(el, qualifiedName);
/*     */   }
/*     */ 
/*     */   public static QName resolveQName(Element el, String qualifiedName)
/*     */   {
/* 204 */     String prefix = "";
/* 205 */     String namespaceURI = "";
/* 206 */     String localPart = qualifiedName;
/*     */ 
/* 208 */     int colIndex = qualifiedName.indexOf(":");
/* 209 */     if (colIndex > 0)
/*     */     {
/* 211 */       prefix = qualifiedName.substring(0, colIndex);
/* 212 */       localPart = qualifiedName.substring(colIndex + 1);
/*     */ 
/* 214 */       if ("xmlns".equals(prefix))
/*     */       {
/* 216 */         namespaceURI = "URI:XML_PREDEFINED_NAMESPACE";
/*     */       }
/*     */       else
/*     */       {
/* 220 */         Element nsElement = el;
/* 221 */         while ((namespaceURI.equals("")) && (nsElement != null))
/*     */         {
/* 223 */           namespaceURI = nsElement.getAttribute("xmlns:" + prefix);
/* 224 */           if (namespaceURI.equals("")) {
/* 225 */             nsElement = getParentElement(nsElement);
/*     */           }
/*     */         }
/*     */       }
/* 229 */       if (namespaceURI.equals("")) {
/* 230 */         throw new IllegalArgumentException("Cannot find namespace uri for: " + qualifiedName);
/*     */       }
/*     */     }
/* 233 */     QName qname = new QName(namespaceURI, localPart, prefix);
/* 234 */     return qname;
/*     */   }
/*     */ 
/*     */   public static String getAttributeValue(Element el, String attrName)
/*     */   {
/* 243 */     return getAttributeValue(el, new QName(attrName));
/*     */   }
/*     */ 
/*     */   public static String getAttributeValue(Element el, QName attrName)
/*     */   {
/* 252 */     String attr = null;
/* 253 */     if ("".equals(attrName.getNamespaceURI()))
/* 254 */       attr = el.getAttribute(attrName.getLocalPart());
/* 255 */     else attr = el.getAttributeNS(attrName.getNamespaceURI(), attrName.getLocalPart());
/*     */ 
/* 257 */     if ("".equals(attr)) {
/* 258 */       attr = null;
/*     */     }
/* 260 */     return attr;
/*     */   }
/*     */ 
/*     */   public static QName getAttributeValueAsQName(Element el, String attrName)
/*     */   {
/* 267 */     return getAttributeValueAsQName(el, new QName(attrName));
/*     */   }
/*     */ 
/*     */   public static QName getAttributeValueAsQName(Element el, QName attrName)
/*     */   {
/* 275 */     QName qname = null;
/*     */ 
/* 277 */     String qualifiedName = getAttributeValue(el, attrName);
/* 278 */     if (qualifiedName != null)
/*     */     {
/* 280 */       qname = resolveQName(el, qualifiedName);
/*     */     }
/*     */ 
/* 283 */     return qname;
/*     */   }
/*     */ 
/*     */   public static boolean getAttributeValueAsBoolean(Element el, String attrName)
/*     */   {
/* 290 */     return getAttributeValueAsBoolean(el, new QName(attrName));
/*     */   }
/*     */ 
/*     */   public static boolean getAttributeValueAsBoolean(Element el, QName attrName)
/*     */   {
/* 297 */     String attrVal = getAttributeValue(el, attrName);
/* 298 */     boolean ret = ("true".equalsIgnoreCase(attrVal)) || ("1".equalsIgnoreCase(attrVal));
/* 299 */     return ret;
/*     */   }
/*     */ 
/*     */   public static Integer getAttributeValueAsInteger(Element el, String attrName)
/*     */   {
/* 306 */     return getAttributeValueAsInteger(el, new QName(attrName));
/*     */   }
/*     */ 
/*     */   public static Integer getAttributeValueAsInteger(Element el, QName attrName)
/*     */   {
/* 313 */     String attrVal = getAttributeValue(el, attrName);
/* 314 */     return attrVal != null ? new Integer(attrVal) : null;
/*     */   }
/*     */ 
/*     */   public static Map getAttributes(Element el)
/*     */   {
/* 321 */     Map attmap = new HashMap();
/* 322 */     NamedNodeMap attribs = el.getAttributes();
/* 323 */     for (int i = 0; i < attribs.getLength(); i++)
/*     */     {
/* 325 */       Attr attr = (Attr)attribs.item(i);
/* 326 */       String name = attr.getName();
/* 327 */       QName qname = resolveQName(el, name);
/* 328 */       String value = attr.getNodeValue();
/* 329 */       attmap.put(qname, value);
/*     */     }
/* 331 */     return attmap;
/*     */   }
/*     */ 
/*     */   public static void copyAttributes(Element destElement, Element srcElement)
/*     */   {
/* 338 */     NamedNodeMap attribs = srcElement.getAttributes();
/* 339 */     for (int i = 0; i < attribs.getLength(); i++)
/*     */     {
/* 341 */       Attr attr = (Attr)attribs.item(i);
/* 342 */       String uri = attr.getNamespaceURI();
/* 343 */       String qname = attr.getName();
/* 344 */       String value = attr.getNodeValue();
/*     */ 
/* 348 */       if ((uri == null) && (qname.startsWith("xmlns")))
/*     */       {
/* 350 */         log.trace("Ignore attribute: [uri=" + uri + ",qname=" + qname + ",value=" + value + "]");
/*     */       }
/*     */       else
/*     */       {
/* 354 */         destElement.setAttributeNS(uri, qname, value);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static boolean hasChildElements(Node node)
/*     */   {
/* 363 */     NodeList nlist = node.getChildNodes();
/* 364 */     for (int i = 0; i < nlist.getLength(); i++)
/*     */     {
/* 366 */       Node child = nlist.item(i);
/* 367 */       if (child.getNodeType() == 1)
/* 368 */         return true;
/*     */     }
/* 370 */     return false;
/*     */   }
/*     */ 
/*     */   public static Iterator getChildElements(Node node)
/*     */   {
/* 377 */     ArrayList list = new ArrayList();
/* 378 */     NodeList nlist = node.getChildNodes();
/* 379 */     for (int i = 0; i < nlist.getLength(); i++)
/*     */     {
/* 381 */       Node child = nlist.item(i);
/* 382 */       if (child.getNodeType() == 1)
/* 383 */         list.add(child);
/*     */     }
/* 385 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public static String getTextContent(Node node)
/*     */   {
/* 393 */     return getTextContent(node, false);
/*     */   }
/*     */ 
/*     */   public static String getTextContent(Node node, boolean replaceProps)
/*     */   {
/* 401 */     boolean hasTextContent = false;
/* 402 */     StringBuffer buffer = new StringBuffer();
/* 403 */     NodeList nlist = node.getChildNodes();
/* 404 */     for (int i = 0; i < nlist.getLength(); i++)
/*     */     {
/* 406 */       Node child = nlist.item(i);
/* 407 */       if (child.getNodeType() != 3)
/*     */         continue;
/* 409 */       buffer.append(child.getNodeValue());
/* 410 */       hasTextContent = true;
/*     */     }
/*     */ 
/* 413 */     String text = hasTextContent ? buffer.toString() : null;
/* 414 */     if ((text != null) && (replaceProps)) {
/* 415 */       text = StringPropertyReplacer.replaceProperties(text);
/*     */     }
/* 417 */     return text;
/*     */   }
/*     */ 
/*     */   public static Element getFirstChildElement(Node node)
/*     */   {
/* 424 */     return getFirstChildElementIntern(node, null);
/*     */   }
/*     */ 
/*     */   public static Element getFirstChildElement(Node node, String nodeName)
/*     */   {
/* 431 */     return getFirstChildElementIntern(node, new QName(nodeName));
/*     */   }
/*     */ 
/*     */   public static Element getFirstChildElement(Node node, QName nodeName)
/*     */   {
/* 438 */     return getFirstChildElementIntern(node, nodeName);
/*     */   }
/*     */ 
/*     */   private static Element getFirstChildElementIntern(Node node, QName nodeName)
/*     */   {
/* 443 */     Element childElement = null;
/* 444 */     Iterator it = getChildElementsIntern(node, nodeName);
/* 445 */     if (it.hasNext())
/*     */     {
/* 447 */       childElement = (Element)it.next();
/*     */     }
/* 449 */     return childElement;
/*     */   }
/*     */ 
/*     */   public static Iterator getChildElements(Node node, String nodeName)
/*     */   {
/* 456 */     return getChildElementsIntern(node, new QName(nodeName));
/*     */   }
/*     */ 
/*     */   public static Iterator getChildElements(Node node, QName nodeName)
/*     */   {
/* 463 */     return getChildElementsIntern(node, nodeName);
/*     */   }
/*     */ 
/*     */   private static Iterator getChildElementsIntern(Node node, QName nodeName)
/*     */   {
/* 468 */     ArrayList list = new ArrayList();
/* 469 */     NodeList nlist = node.getChildNodes();
/* 470 */     for (int i = 0; i < nlist.getLength(); i++)
/*     */     {
/* 472 */       Node child = nlist.item(i);
/* 473 */       if (child.getNodeType() != 1)
/*     */         continue;
/* 475 */       if (nodeName == null)
/*     */       {
/* 477 */         list.add(child);
/*     */       }
/*     */       else
/*     */       {
/*     */         QName qname;
/*     */         QName qname;
/* 482 */         if (nodeName.getNamespaceURI().length() > 0)
/*     */         {
/* 484 */           qname = new QName(child.getNamespaceURI(), child.getLocalName());
/*     */         }
/*     */         else
/*     */         {
/* 488 */           qname = new QName(child.getLocalName());
/*     */         }
/* 490 */         if (!qname.equals(nodeName))
/*     */           continue;
/* 492 */         list.add(child);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 497 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public static Element getParentElement(Node node)
/*     */   {
/* 504 */     Node parent = node.getParentNode();
/* 505 */     return (parent instanceof Element) ? (Element)parent : null;
/*     */   }
/*     */ 
/*     */   public static Document getOwnerDocument()
/*     */   {
/* 511 */     Document doc = (Document)documentThreadLocal.get();
/* 512 */     if (doc == null)
/*     */     {
/* 514 */       doc = getDocumentBuilder().newDocument();
/* 515 */       documentThreadLocal.set(doc);
/*     */     }
/* 517 */     return doc;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.DOMUtils
 * JD-Core Version:    0.6.0
 */