/*     */ package org.jboss.util.timeout;
/*     */ 
/*     */ import java.util.concurrent.atomic.AtomicBoolean;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class HashedTimeoutPriorityQueueImpl
/*     */   implements TimeoutPriorityQueue
/*     */ {
/* 181 */   private Object topLock = new Object();
/*     */   private TimeoutExtImpl top;
/*     */   private InternalPriorityQueue[] queues;
/* 189 */   private AtomicBoolean cancelled = new AtomicBoolean(false);
/*     */ 
/*     */   public HashedTimeoutPriorityQueueImpl()
/*     */   {
/* 196 */     this.queues = new InternalPriorityQueue[40];
/* 197 */     for (int i = 0; i < this.queues.length; i++)
/* 198 */       this.queues[i] = new InternalPriorityQueue();
/*     */   }
/*     */ 
/*     */   public TimeoutExt offer(long time, TimeoutTarget target)
/*     */   {
/* 203 */     if (this.cancelled.get())
/* 204 */       throw new IllegalStateException("TimeoutPriorityQueue has been cancelled");
/* 205 */     if (time < 0L)
/* 206 */       throw new IllegalArgumentException("Negative time");
/* 207 */     if (target == null) {
/* 208 */       throw new IllegalArgumentException("Null timeout target");
/*     */     }
/* 210 */     TimeoutExtImpl timeout = new TimeoutExtImpl(null);
/* 211 */     timeout.time = time;
/* 212 */     timeout.target = target;
/* 213 */     int index = timeout.hashCode() % this.queues.length;
/* 214 */     return this.queues[index].offer(timeout);
/*     */   }
/*     */ 
/*     */   public TimeoutExt take()
/*     */   {
/* 219 */     return poll(-1L);
/*     */   }
/*     */ 
/*     */   public TimeoutExt poll()
/*     */   {
/* 224 */     return poll(1L);
/*     */   }
/*     */ 
/*     */   public TimeoutExt poll(long wait)
/*     */   {
/* 229 */     long endWait = -1L;
/* 230 */     if (wait > 0L) {
/* 231 */       endWait = System.currentTimeMillis() + wait;
/*     */     }
/* 233 */     synchronized (this.topLock)
/*     */     {
/* 235 */       while ((!this.cancelled.get()) && ((wait >= 0L) || (endWait == -1L)))
/*     */       {
/* 237 */         if (this.top == null)
/*     */         {
/*     */           try
/*     */           {
/* 241 */             if (endWait == -1L)
/* 242 */               this.topLock.wait();
/*     */             else
/* 244 */               this.topLock.wait(wait);
/*     */           }
/*     */           catch (InterruptedException ex)
/*     */           {
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 252 */           long now = System.currentTimeMillis();
/* 253 */           if (this.top.time > now)
/*     */           {
/* 255 */             long waitForFirst = this.top.time - now;
/* 256 */             if ((endWait != -1L) && (waitForFirst > wait))
/* 257 */               waitForFirst = wait;
/*     */             try
/*     */             {
/* 260 */               this.topLock.wait(waitForFirst);
/*     */             }
/*     */             catch (InterruptedException ex)
/*     */             {
/*     */             }
/*     */           }
/* 266 */           if ((!this.cancelled.get()) && (this.top != null) && (this.top.time <= System.currentTimeMillis()))
/*     */           {
/* 268 */             TimeoutExtImpl result = this.top;
/* 269 */             result.queue = null;
/* 270 */             result.index = -2;
/* 271 */             this.top = null;
/* 272 */             recalculateTop(false);
/* 273 */             return result;
/*     */           }
/*     */         }
/* 276 */         if (endWait != -1L)
/* 277 */           wait = endWait - System.currentTimeMillis();
/*     */       }
/*     */     }
/* 280 */     return null;
/*     */   }
/*     */ 
/*     */   public TimeoutExt peek()
/*     */   {
/* 285 */     synchronized (this.topLock)
/*     */     {
/* 287 */       return this.top;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean remove(TimeoutExt timeout)
/*     */   {
/* 293 */     TimeoutExtImpl timeoutImpl = (TimeoutExtImpl)timeout;
/*     */ 
/* 296 */     InternalPriorityQueue queue = timeoutImpl.queue;
/* 297 */     if ((queue != null) && (queue.remove(timeoutImpl))) {
/* 298 */       return true;
/*     */     }
/* 300 */     synchronized (this.topLock)
/*     */     {
/* 303 */       if (this.top == timeout)
/*     */       {
/* 305 */         this.top.done();
/* 306 */         this.top = null;
/* 307 */         recalculateTop(true);
/* 308 */         return true;
/*     */       }
/*     */ 
/* 313 */       queue = timeoutImpl.queue;
/* 314 */       if (queue != null)
/* 315 */         return queue.remove(timeoutImpl);
/*     */     }
/* 317 */     return false;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 322 */     synchronized (this.topLock)
/*     */     {
/* 324 */       if (this.cancelled.get()) {
/* 325 */         return;
/*     */       }
/*     */ 
/* 328 */       for (int i = 1; i < this.queues.length; i++) {
/* 329 */         this.queues[i].clear();
/*     */       }
/*     */ 
/* 332 */       this.top = cleanupTimeoutExtImpl(this.top);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void cancel()
/*     */   {
/* 338 */     synchronized (this.topLock)
/*     */     {
/* 340 */       if (this.cancelled.get()) {
/* 341 */         return;
/*     */       }
/* 343 */       clear();
/* 344 */       this.topLock.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 350 */     int size = 0;
/* 351 */     if (this.top != null)
/* 352 */       size = 1;
/* 353 */     for (int i = 0; i < this.queues.length; i++)
/* 354 */       size += this.queues[i].size();
/* 355 */     return size;
/*     */   }
/*     */ 
/*     */   public boolean isCancelled()
/*     */   {
/* 365 */     return this.cancelled.get();
/*     */   }
/*     */ 
/*     */   private void recalculateTop(boolean notify)
/*     */   {
/* 370 */     for (int i = 0; i < this.queues.length; i++)
/* 371 */       this.queues[i].compareAndSwapWithTop(notify);
/*     */   }
/*     */ 
/*     */   private TimeoutExtImpl cleanupTimeoutExtImpl(TimeoutExtImpl timeout)
/*     */   {
/* 381 */     if (timeout != null)
/* 382 */       timeout.target = null;
/* 383 */     return null;
/*     */   }
/*     */ 
/*     */   private void assertExpr(boolean expr)
/*     */   {
/* 391 */     if (!expr)
/* 392 */       throw new IllegalStateException("***** assert failed *****");
/*     */   }
/*     */ 
/*     */   public String dump()
/*     */   {
/* 741 */     JBossStringBuilder buffer = new JBossStringBuilder();
/* 742 */     buffer.append("TOP=");
/* 743 */     if (this.top == null)
/* 744 */       buffer.append("null");
/*     */     else
/* 746 */       buffer.append(this.top.time);
/* 747 */     buffer.append(" size=").append(size()).append('\n');
/* 748 */     for (int i = 0; i < this.queues.length; i++)
/*     */     {
/* 750 */       buffer.append(i).append("=");
/* 751 */       for (int j = 1; j <= this.queues[i].size; j++)
/* 752 */         buffer.append(this.queues[i].queue[j].time).append(',');
/* 753 */       buffer.append('\n');
/*     */     }
/* 755 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private class TimeoutExtImpl
/*     */     implements TimeoutExt
/*     */   {
/*     */     static final int TOP = 0;
/*     */     static final int DONE = -1;
/*     */     static final int TIMEOUT = -2;
/*     */     HashedTimeoutPriorityQueueImpl.InternalPriorityQueue queue;
/*     */     int index;
/*     */     long time;
/*     */     TimeoutTarget target;
/*     */ 
/*     */     private TimeoutExtImpl()
/*     */     {
/*     */     }
/*     */ 
/*     */     public long getTime()
/*     */     {
/* 719 */       return this.time;
/*     */     }
/*     */ 
/*     */     public TimeoutTarget getTimeoutTarget()
/*     */     {
/* 724 */       return this.target;
/*     */     }
/*     */ 
/*     */     public void done()
/*     */     {
/* 729 */       this.queue = null;
/* 730 */       this.index = -1;
/*     */     }
/*     */ 
/*     */     public boolean cancel()
/*     */     {
/* 735 */       return HashedTimeoutPriorityQueueImpl.this.remove(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   private class InternalPriorityQueue
/*     */   {
/* 401 */     private Object lock = new Object();
/*     */     private int size;
/*     */     private HashedTimeoutPriorityQueueImpl.TimeoutExtImpl[] queue;
/*     */ 
/*     */     InternalPriorityQueue()
/*     */     {
/* 414 */       this.queue = new HashedTimeoutPriorityQueueImpl.TimeoutExtImpl[16];
/* 415 */       this.size = 0;
/*     */     }
/*     */ 
/*     */     TimeoutExt offer(HashedTimeoutPriorityQueueImpl.TimeoutExtImpl timeout)
/*     */     {
/* 420 */       boolean checkTop = false;
/* 421 */       synchronized (this.lock)
/*     */       {
/* 425 */         if (++this.size == this.queue.length)
/*     */         {
/* 427 */           HashedTimeoutPriorityQueueImpl.TimeoutExtImpl[] newQ = new HashedTimeoutPriorityQueueImpl.TimeoutExtImpl[2 * this.queue.length];
/* 428 */           System.arraycopy(this.queue, 0, newQ, 0, this.queue.length);
/* 429 */           this.queue = newQ;
/*     */         }
/*     */ 
/* 433 */         this.queue[this.size] = timeout;
/* 434 */         timeout.queue = this;
/* 435 */         timeout.index = this.size;
/* 436 */         normalizeUp(this.size);
/* 437 */         if (timeout.index == 1) {
/* 438 */           checkTop = true;
/*     */         }
/*     */       }
/* 441 */       if (checkTop)
/*     */       {
/* 443 */         synchronized (HashedTimeoutPriorityQueueImpl.this.topLock)
/*     */         {
/* 445 */           compareAndSwapWithTop(true);
/*     */         }
/*     */       }
/* 448 */       return timeout;
/*     */     }
/*     */ 
/*     */     boolean compareAndSwapWithTop(boolean notify)
/*     */     {
/* 453 */       synchronized (this.lock)
/*     */       {
/* 455 */         if (this.size == 0) {
/* 456 */           return false;
/*     */         }
/* 458 */         if (HashedTimeoutPriorityQueueImpl.this.top == null)
/*     */         {
/* 460 */           HashedTimeoutPriorityQueueImpl.access$202(HashedTimeoutPriorityQueueImpl.this, removeNode(1));
/* 461 */           HashedTimeoutPriorityQueueImpl.this.top.queue = null;
/* 462 */           HashedTimeoutPriorityQueueImpl.this.top.index = 0;
/* 463 */           if (notify)
/* 464 */             HashedTimeoutPriorityQueueImpl.this.topLock.notify();
/* 465 */           return HashedTimeoutPriorityQueueImpl.this.top != null;
/*     */         }
/*     */ 
/* 468 */         if (HashedTimeoutPriorityQueueImpl.this.top.time > this.queue[1].time)
/*     */         {
/* 470 */           HashedTimeoutPriorityQueueImpl.TimeoutExtImpl temp = HashedTimeoutPriorityQueueImpl.this.top;
/* 471 */           HashedTimeoutPriorityQueueImpl.access$202(HashedTimeoutPriorityQueueImpl.this, this.queue[1]);
/* 472 */           HashedTimeoutPriorityQueueImpl.this.top.queue = null;
/* 473 */           HashedTimeoutPriorityQueueImpl.this.top.index = 0;
/* 474 */           this.queue[1] = temp;
/* 475 */           temp.queue = this;
/* 476 */           temp.index = 1;
/* 477 */           if (this.size > 1)
/* 478 */             normalizeDown(1);
/* 479 */           if (notify)
/* 480 */             HashedTimeoutPriorityQueueImpl.this.topLock.notify();
/*     */         }
/*     */       }
/* 483 */       return false;
/*     */     }
/*     */ 
/*     */     boolean remove(TimeoutExt timeout)
/*     */     {
/* 488 */       synchronized (this.lock)
/*     */       {
/* 490 */         HashedTimeoutPriorityQueueImpl.TimeoutExtImpl timeoutImpl = (HashedTimeoutPriorityQueueImpl.TimeoutExtImpl)timeout;
/* 491 */         if ((timeoutImpl.queue == this) && (timeoutImpl.index > 0))
/*     */         {
/* 496 */           removeNode(timeoutImpl.index);
/*     */ 
/* 498 */           timeoutImpl.queue = null;
/* 499 */           timeoutImpl.index = -1;
/*     */ 
/* 502 */           return true;
/*     */         }
/*     */ 
/* 508 */         return false;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void clear()
/*     */     {
/* 515 */       synchronized (this.lock)
/*     */       {
/* 517 */         if (HashedTimeoutPriorityQueueImpl.this.cancelled.get()) {
/* 518 */           return;
/*     */         }
/*     */ 
/* 521 */         for (int i = 1; i <= this.size; i++)
/* 522 */           this.queue[i] = HashedTimeoutPriorityQueueImpl.access$400(HashedTimeoutPriorityQueueImpl.this, this.queue[i]);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void cancel()
/*     */     {
/* 528 */       synchronized (this.lock)
/*     */       {
/* 530 */         if (HashedTimeoutPriorityQueueImpl.this.cancelled.get())
/* 531 */           return;
/* 532 */         clear();
/*     */       }
/*     */     }
/*     */ 
/*     */     public int size()
/*     */     {
/* 538 */       return this.size;
/*     */     }
/*     */ 
/*     */     private boolean normalizeUp(int index)
/*     */     {
/* 552 */       if (index == 1)
/* 553 */         return false;
/* 554 */       boolean ret = false;
/* 555 */       long t = this.queue[index].time;
/* 556 */       int p = index >> 1;
/* 557 */       while (this.queue[p].time > t)
/*     */       {
/* 560 */         swap(p, index);
/* 561 */         ret = true;
/* 562 */         if (p == 1)
/*     */           break;
/* 564 */         index = p;
/* 565 */         p >>= 1;
/*     */       }
/* 567 */       return ret;
/*     */     }
/*     */ 
/*     */     void normalizeDown(int index)
/*     */     {
/* 572 */       long t = this.queue[index].time;
/* 573 */       int c = index << 1;
/* 574 */       while (c <= this.size)
/*     */       {
/* 577 */         HashedTimeoutPriorityQueueImpl.TimeoutExtImpl l = this.queue[c];
/*     */ 
/* 580 */         if (c + 1 <= this.size)
/*     */         {
/* 583 */           HashedTimeoutPriorityQueueImpl.TimeoutExtImpl r = this.queue[(c + 1)];
/*     */ 
/* 586 */           if (l.time <= r.time)
/*     */           {
/* 588 */             if (t <= l.time)
/*     */               break;
/* 590 */             swap(index, c);
/* 591 */             index = c;
/*     */           }
/*     */           else
/*     */           {
/* 595 */             if (t <= r.time)
/*     */               break;
/* 597 */             swap(index, c + 1);
/* 598 */             index = c + 1;
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 603 */           if (t <= l.time)
/*     */             break;
/* 605 */           swap(index, c);
/* 606 */           index = c;
/*     */         }
/* 608 */         c = index << 1;
/*     */       }
/*     */     }
/*     */ 
/*     */     private void swap(int a, int b)
/*     */     {
/* 628 */       HashedTimeoutPriorityQueueImpl.TimeoutExtImpl temp = this.queue[a];
/* 629 */       this.queue[a] = this.queue[b];
/* 630 */       this.queue[a].index = a;
/* 631 */       this.queue[b] = temp;
/* 632 */       this.queue[b].index = b;
/*     */     }
/*     */ 
/*     */     private HashedTimeoutPriorityQueueImpl.TimeoutExtImpl removeNode(int index)
/*     */     {
/* 645 */       HashedTimeoutPriorityQueueImpl.TimeoutExtImpl res = this.queue[index];
/*     */ 
/* 648 */       if (index == this.size)
/*     */       {
/* 650 */         this.size -= 1;
/* 651 */         this.queue[index] = null;
/* 652 */         return res;
/*     */       }
/* 654 */       swap(index, this.size);
/* 655 */       this.size -= 1;
/*     */ 
/* 657 */       this.queue[res.index] = null;
/* 658 */       if (normalizeUp(index))
/* 659 */         return res;
/* 660 */       normalizeDown(index);
/* 661 */       return res;
/*     */     }
/*     */ 
/*     */     void checkTree()
/*     */     {
/* 669 */       HashedTimeoutPriorityQueueImpl.this.assertExpr(this.size >= 0);
/* 670 */       HashedTimeoutPriorityQueueImpl.this.assertExpr(this.size < this.queue.length);
/* 671 */       HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[0] == null);
/* 672 */       if (this.size > 0)
/*     */       {
/* 674 */         HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[1] != null);
/* 675 */         HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[1].index == 1);
/* 676 */         HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[1].queue == this);
/* 677 */         for (int i = 2; i <= this.size; i++)
/*     */         {
/* 679 */           HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[i] != null);
/* 680 */           HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[i].index == i);
/* 681 */           HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[i].queue == this);
/* 682 */           HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[(i >> 1)].time <= this.queue[i].time);
/*     */         }
/* 684 */         for (int i = this.size + 1; i < this.queue.length; i++)
/* 685 */           HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[i] == null);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.timeout.HashedTimeoutPriorityQueueImpl
 * JD-Core Version:    0.6.0
 */