/*     */ package org.jboss.util.threadpool;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class BlockingMode
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -9102277941374138830L;
/*     */   public static final int RUN_TYPE = 0;
/*     */   public static final int WAIT_TYPE = 1;
/*     */   public static final int DISCARD_TYPE = 2;
/*     */   public static final int DISCARD_OLDEST_TYPE = 3;
/*     */   public static final int ABORT_TYPE = 4;
/*  46 */   public static final BlockingMode RUN = new BlockingMode("run", 0);
/*     */ 
/*  51 */   public static final BlockingMode WAIT = new BlockingMode("wait", 1);
/*     */ 
/*  55 */   public static final BlockingMode DISCARD = new BlockingMode("discard", 2);
/*     */ 
/*  59 */   public static final BlockingMode DISCARD_OLDEST = new BlockingMode("discardOldest", 3);
/*     */ 
/*  64 */   public static final BlockingMode ABORT = new BlockingMode("abort", 4);
/*     */   private final transient String name;
/*     */   private final int type;
/*     */ 
/*     */   public static final BlockingMode toBlockingMode(String name)
/*     */   {
/*  77 */     BlockingMode mode = null;
/*  78 */     if (name == null)
/*     */     {
/*  80 */       mode = null;
/*     */     }
/*  82 */     else if (name.equalsIgnoreCase("run"))
/*     */     {
/*  84 */       mode = RUN;
/*     */     }
/*  86 */     else if (name.equalsIgnoreCase("wait"))
/*     */     {
/*  88 */       mode = WAIT;
/*     */     }
/*  90 */     else if (name.equalsIgnoreCase("discard"))
/*     */     {
/*  92 */       mode = DISCARD;
/*     */     }
/*  94 */     else if (name.equalsIgnoreCase("discardOldest"))
/*     */     {
/*  96 */       mode = DISCARD_OLDEST;
/*     */     }
/*  98 */     else if (name.equalsIgnoreCase("abort"))
/*     */     {
/* 100 */       mode = ABORT;
/*     */     }
/* 102 */     return mode;
/*     */   }
/*     */ 
/*     */   private BlockingMode(String name, int type)
/*     */   {
/* 107 */     this.name = name;
/* 108 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 113 */     return this.name;
/*     */   }
/*     */ 
/*     */   Object readResolve()
/*     */     throws ObjectStreamException
/*     */   {
/* 127 */     BlockingMode mode = ABORT;
/* 128 */     switch (this.type)
/*     */     {
/*     */     case 0:
/* 131 */       mode = RUN;
/* 132 */       break;
/*     */     case 1:
/* 134 */       mode = RUN;
/* 135 */       break;
/*     */     case 2:
/* 137 */       mode = RUN;
/* 138 */       break;
/*     */     case 3:
/* 140 */       mode = RUN;
/* 141 */       break;
/*     */     case 4:
/* 143 */       mode = RUN;
/*     */     }
/*     */ 
/* 146 */     return mode;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.threadpool.BlockingMode
 * JD-Core Version:    0.6.0
 */