/*    */ package org.jboss.util.stream;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.ObjectStreamClass;
/*    */ import java.lang.reflect.Proxy;
/*    */ 
/*    */ public class MarshalledValueInputStream extends ObjectInputStream
/*    */ {
/*    */   public MarshalledValueInputStream(InputStream is)
/*    */     throws IOException
/*    */   {
/* 45 */     super(is);
/*    */   }
/*    */ 
/*    */   protected Class resolveClass(ObjectStreamClass v)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 56 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 57 */     String className = v.getName();
/*    */ 
/* 60 */     return Class.forName(className, false, loader);
/*    */   }
/*    */ 
/*    */   protected Class resolveProxyClass(String[] interfaces)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 67 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 68 */     Class[] ifaceClasses = new Class[interfaces.length];
/* 69 */     for (int i = 0; i < interfaces.length; i++)
/*    */     {
/* 71 */       ifaceClasses[i] = loader.loadClass(interfaces[i]);
/*    */     }
/*    */ 
/* 74 */     return Proxy.getProxyClass(loader, ifaceClasses);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.stream.MarshalledValueInputStream
 * JD-Core Version:    0.6.0
 */