/*     */ package org.jboss.util.stream;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.lang.reflect.Proxy;
/*     */ 
/*     */ public class CustomObjectInputStreamWithClassloader extends ObjectInputStream
/*     */ {
/*     */   ClassLoader cl;
/*     */ 
/*     */   public CustomObjectInputStreamWithClassloader(InputStream in, ClassLoader cl)
/*     */     throws IOException
/*     */   {
/*  65 */     super(in);
/*  66 */     this.cl = cl;
/*     */   }
/*     */ 
/*     */   protected ObjectStreamClass readClassDescriptor()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  77 */     return ObjectStreamClass.lookup(this.cl.loadClass(readUTF()));
/*     */   }
/*     */ 
/*     */   protected Class resolveClass(ObjectStreamClass classdesc)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  94 */     return this.cl.loadClass(classdesc.getName());
/*     */   }
/*     */ 
/*     */   protected Class resolveProxyClass(String[] interfaces)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 110 */     Class[] interfacesClass = new Class[interfaces.length];
/* 111 */     for (int i = 0; i < interfaces.length; i++) {
/* 112 */       interfacesClass[i] = Class.forName(interfaces[i], false, this.cl);
/*     */     }
/* 114 */     return Proxy.getProxyClass(this.cl, interfacesClass);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.stream.CustomObjectInputStreamWithClassloader
 * JD-Core Version:    0.6.0
 */