/*    */ package org.jboss.util.stream;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InterruptedIOException;
/*    */ import java.io.OutputStream;
/*    */ import java.io.PrintWriter;
/*    */ import java.io.Writer;
/*    */ 
/*    */ public class CRLFPrintWriter extends PrintWriter
/*    */ {
/* 43 */   protected boolean autoFlush = false;
/*    */ 
/*    */   public CRLFPrintWriter(Writer out) {
/* 46 */     super(out);
/*    */   }
/*    */ 
/*    */   public CRLFPrintWriter(Writer out, boolean autoFlush) {
/* 50 */     super(out, autoFlush);
/* 51 */     this.autoFlush = autoFlush;
/*    */   }
/*    */ 
/*    */   public CRLFPrintWriter(OutputStream out) {
/* 55 */     super(out);
/*    */   }
/*    */ 
/*    */   public CRLFPrintWriter(OutputStream out, boolean autoFlush) {
/* 59 */     super(out, autoFlush);
/* 60 */     this.autoFlush = autoFlush;
/*    */   }
/*    */ 
/*    */   protected void ensureOpen() throws IOException {
/* 64 */     if (this.out == null)
/* 65 */       throw new IOException("Stream closed");
/*    */   }
/*    */ 
/*    */   public void println() {
/*    */     try {
/* 70 */       synchronized (this.lock) {
/* 71 */         ensureOpen();
/*    */ 
/* 73 */         this.out.write("\r\n");
/*    */ 
/* 75 */         if (this.autoFlush)
/* 76 */           this.out.flush();
/*    */       }
/*    */     }
/*    */     catch (InterruptedIOException e)
/*    */     {
/* 81 */       Thread.currentThread().interrupt();
/*    */     }
/*    */     catch (IOException e) {
/* 84 */       setError();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.stream.CRLFPrintWriter
 * JD-Core Version:    0.6.0
 */