/*     */ package org.jboss.util.propertyeditor;
/*     */ 
/*     */ import java.beans.BeanInfo;
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.Introspector;
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.Classes;
/*     */ 
/*     */ public class PropertyEditors
/*     */ {
/*  53 */   private static Logger log = Logger.getLogger(PropertyEditors.class);
/*     */   private static final String NULL = "null";
/*  59 */   private static boolean disableIsNull = false;
/*     */ 
/*  62 */   private static boolean initialized = false;
/*     */ 
/*     */   public static synchronized void init()
/*     */   {
/*  76 */     if (!initialized)
/*     */     {
/*  78 */       AccessController.doPrivileged(Initialize.instance);
/*  79 */       initialized = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final boolean isNull(String value)
/*     */   {
/*  92 */     return isNull(value, true, true);
/*     */   }
/*     */ 
/*     */   public static final boolean isNull(String value, boolean trim, boolean empty)
/*     */   {
/* 106 */     if (disableIsNull) {
/* 107 */       return false;
/*     */     }
/* 109 */     if (value == null) {
/* 110 */       return true;
/*     */     }
/* 112 */     String trimmed = trim ? value.trim() : value;
/*     */ 
/* 114 */     if ((empty) && (trimmed.length() == 0)) {
/* 115 */       return true;
/*     */     }
/* 117 */     return "null".equalsIgnoreCase(trimmed);
/*     */   }
/*     */ 
/*     */   public static boolean isNullHandlingEnabled()
/*     */   {
/* 128 */     return !disableIsNull;
/*     */   }
/*     */ 
/*     */   public static PropertyEditor findEditor(Class type)
/*     */   {
/* 139 */     return PropertyEditorManager.findEditor(type);
/*     */   }
/*     */ 
/*     */   public static PropertyEditor findEditor(String typeName)
/*     */     throws ClassNotFoundException
/*     */   {
/* 152 */     Class type = Classes.getPrimitiveTypeForName(typeName);
/* 153 */     if (type == null)
/*     */     {
/* 156 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 157 */       type = loader.loadClass(typeName);
/*     */     }
/*     */ 
/* 160 */     return PropertyEditorManager.findEditor(type);
/*     */   }
/*     */ 
/*     */   public static PropertyEditor getEditor(Class type)
/*     */   {
/* 173 */     PropertyEditor editor = findEditor(type);
/* 174 */     if (editor == null)
/*     */     {
/* 176 */       throw new RuntimeException("No property editor for type: " + type);
/*     */     }
/*     */ 
/* 179 */     return editor;
/*     */   }
/*     */ 
/*     */   public static PropertyEditor getEditor(String typeName)
/*     */     throws ClassNotFoundException
/*     */   {
/* 193 */     PropertyEditor editor = findEditor(typeName);
/* 194 */     if (editor == null)
/*     */     {
/* 196 */       throw new RuntimeException("No property editor for type: " + typeName);
/*     */     }
/*     */ 
/* 199 */     return editor;
/*     */   }
/*     */ 
/*     */   public static void registerEditor(Class type, Class editorType)
/*     */   {
/* 210 */     PropertyEditorManager.registerEditor(type, editorType);
/*     */   }
/*     */ 
/*     */   public static void registerEditor(String typeName, String editorTypeName)
/*     */     throws ClassNotFoundException
/*     */   {
/* 223 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 224 */     Class type = loader.loadClass(typeName);
/* 225 */     Class editorType = loader.loadClass(editorTypeName);
/*     */ 
/* 227 */     PropertyEditorManager.registerEditor(type, editorType);
/*     */   }
/*     */ 
/*     */   public static Object convertValue(String text, String typeName)
/*     */     throws ClassNotFoundException, IntrospectionException
/*     */   {
/* 246 */     Class typeClass = Classes.getPrimitiveTypeForName(typeName);
/* 247 */     if (typeClass == null)
/*     */     {
/* 249 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 250 */       typeClass = loader.loadClass(typeName);
/*     */     }
/*     */ 
/* 253 */     PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
/* 254 */     if (editor == null)
/*     */     {
/* 256 */       throw new IntrospectionException("No property editor for type=" + typeClass);
/*     */     }
/*     */ 
/* 260 */     editor.setAsText(text);
/* 261 */     return editor.getValue();
/*     */   }
/*     */ 
/*     */   public static void mapJavaBeanProperties(Object bean, Properties beanProps)
/*     */     throws IntrospectionException
/*     */   {
/* 281 */     mapJavaBeanProperties(bean, beanProps, true);
/*     */   }
/*     */ 
/*     */   public static void mapJavaBeanProperties(Object bean, Properties beanProps, boolean isStrict)
/*     */     throws IntrospectionException
/*     */   {
/* 304 */     HashMap propertyMap = new HashMap();
/* 305 */     BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
/* 306 */     PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
/* 307 */     for (int p = 0; p < props.length; p++)
/*     */     {
/* 309 */       String fieldName = props[p].getName();
/* 310 */       propertyMap.put(fieldName, props[p]);
/*     */     }
/*     */ 
/* 313 */     boolean trace = log.isTraceEnabled();
/* 314 */     Iterator keys = beanProps.keySet().iterator();
/* 315 */     if (trace)
/* 316 */       log.trace("Mapping properties for bean: " + bean);
/* 317 */     while (keys.hasNext())
/*     */     {
/* 319 */       String name = (String)keys.next();
/* 320 */       String text = beanProps.getProperty(name);
/* 321 */       PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(name);
/* 322 */       if (pd == null)
/*     */       {
/* 331 */         if (name.length() > 1)
/*     */         {
/* 333 */           char first = name.charAt(0);
/* 334 */           String exName = Character.toUpperCase(first) + name.substring(1);
/* 335 */           pd = (PropertyDescriptor)propertyMap.get(exName);
/*     */ 
/* 338 */           if (pd == null)
/*     */           {
/* 340 */             exName = Character.toLowerCase(first) + name.substring(1);
/* 341 */             pd = (PropertyDescriptor)propertyMap.get(exName);
/*     */           }
/*     */         }
/*     */ 
/* 345 */         if (pd == null)
/*     */         {
/* 347 */           if (!isStrict)
/*     */             continue;
/* 349 */           String msg = "No property found for: " + name + " on JavaBean: " + bean;
/* 350 */           throw new IntrospectionException(msg);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 359 */       Method setter = pd.getWriteMethod();
/* 360 */       if (trace)
/* 361 */         log.trace("Property editor found for: " + name + ", editor: " + pd + ", setter: " + setter);
/* 362 */       if (setter != null)
/*     */       {
/* 364 */         Class ptype = pd.getPropertyType();
/* 365 */         PropertyEditor editor = PropertyEditorManager.findEditor(ptype);
/* 366 */         if (editor == null)
/*     */         {
/* 368 */           if (trace)
/* 369 */             log.trace("Failed to find property editor for: " + name);
/*     */         }
/*     */         try
/*     */         {
/* 373 */           editor.setAsText(text);
/* 374 */           Object[] args = { editor.getValue() };
/* 375 */           setter.invoke(bean, args);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 379 */           if (trace)
/* 380 */             log.trace("Failed to write property", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String[] getEditorSearchPath()
/*     */   {
/* 393 */     return PropertyEditorManager.getEditorSearchPath();
/*     */   }
/*     */ 
/*     */   public void setEditorSearchPath(String[] path)
/*     */   {
/* 403 */     PropertyEditorManager.setEditorSearchPath(path);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  66 */     init();
/*     */   }
/*     */ 
/*     */   private static class Initialize
/*     */     implements PrivilegedAction
/*     */   {
/* 408 */     static Initialize instance = new Initialize();
/*     */ 
/*     */     public Object run()
/*     */     {
/* 412 */       String[] currentPath = PropertyEditorManager.getEditorSearchPath();
/* 413 */       int length = currentPath != null ? currentPath.length : 0;
/* 414 */       String[] newPath = new String[length + 2];
/* 415 */       System.arraycopy(currentPath, 0, newPath, 2, length);
/*     */ 
/* 418 */       newPath[0] = "org.jboss.util.propertyeditor";
/* 419 */       newPath[1] = "org.jboss.mx.util.propertyeditor";
/* 420 */       PropertyEditorManager.setEditorSearchPath(newPath);
/*     */ 
/* 426 */       Class strArrayType = [Ljava.lang.String.class;
/* 427 */       PropertyEditorManager.registerEditor(strArrayType, StringArrayEditor.class);
/* 428 */       Class clsArrayType = [Ljava.lang.Class.class;
/* 429 */       PropertyEditorManager.registerEditor(clsArrayType, ClassArrayEditor.class);
/* 430 */       Class intArrayType = [I.class;
/* 431 */       PropertyEditorManager.registerEditor(intArrayType, IntArrayEditor.class);
/* 432 */       Class byteArrayType = [B.class;
/* 433 */       PropertyEditorManager.registerEditor(byteArrayType, ByteArrayEditor.class);
/*     */ 
/* 436 */       PropertyEditorManager.registerEditor(Character.TYPE, CharacterEditor.class);
/*     */       try
/*     */       {
/* 440 */         if (System.getProperty("org.jboss.util.property.disablenull") != null)
/* 441 */           PropertyEditors.access$002(true);
/*     */       }
/*     */       catch (Throwable ignored)
/*     */       {
/* 445 */         PropertyEditors.log.trace("Error retrieving system property org.jboss.util.property.diablenull", ignored);
/*     */       }
/* 447 */       return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.propertyeditor.PropertyEditors
 * JD-Core Version:    0.6.0
 */