/*     */ package org.jboss.util.property;
/*     */ 
/*     */ import java.util.Properties;
/*     */ 
/*     */ public class PropertyContainer extends PropertyMap
/*     */ {
/*  36 */   protected String groupname = "<unknown>";
/*     */ 
/*     */   public PropertyContainer(Properties props)
/*     */   {
/*  44 */     super(props);
/*     */   }
/*     */ 
/*     */   public PropertyContainer(String groupname)
/*     */   {
/*  53 */     this(Property.getGroup(groupname));
/*  54 */     this.groupname = groupname;
/*     */   }
/*     */ 
/*     */   public PropertyContainer(Class type)
/*     */   {
/*  63 */     this(type.getName());
/*     */   }
/*     */ 
/*     */   protected void bindField(String name, String propertyName)
/*     */   {
/*  77 */     if ((name == null) || (name.equals("")))
/*  78 */       throw new IllegalArgumentException("name");
/*  79 */     if ((propertyName == null) || (propertyName.equals(""))) {
/*  80 */       throw new IllegalArgumentException("propertyName");
/*     */     }
/*  82 */     addPropertyListener(new FieldBoundPropertyListener(this, name, propertyName));
/*     */   }
/*     */ 
/*     */   protected void bindField(String name)
/*     */   {
/*  96 */     bindField(name, name);
/*     */   }
/*     */ 
/*     */   protected void bindMethod(String name, String propertyName)
/*     */   {
/* 110 */     if ((name == null) || (name.equals("")))
/* 111 */       throw new IllegalArgumentException("name");
/* 112 */     if ((propertyName == null) || (propertyName.equals(""))) {
/* 113 */       throw new IllegalArgumentException("propertyName");
/*     */     }
/* 115 */     addPropertyListener(new MethodBoundPropertyListener(this, propertyName, name));
/*     */   }
/*     */ 
/*     */   protected void bindMethod(String name)
/*     */   {
/* 129 */     bindMethod(name, name);
/*     */   }
/*     */ 
/*     */   private String makeName(String name) {
/* 133 */     return this.groupname + "." + name;
/*     */   }
/*     */ 
/*     */   protected void throwException(String name)
/*     */     throws PropertyException
/*     */   {
/* 139 */     throw new PropertyException(makeName(name));
/*     */   }
/*     */ 
/*     */   protected void throwException(String name, String msg)
/*     */     throws PropertyException
/*     */   {
/* 145 */     throw new PropertyException(makeName(name) + ": " + msg);
/*     */   }
/*     */ 
/*     */   protected void throwException(String name, String msg, Throwable nested)
/*     */     throws PropertyException
/*     */   {
/* 151 */     throw new PropertyException(makeName(name) + ": " + msg, nested);
/*     */   }
/*     */ 
/*     */   protected void throwException(String name, Throwable nested)
/*     */     throws PropertyException
/*     */   {
/* 157 */     throw new PropertyException(makeName(name), nested);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.PropertyContainer
 * JD-Core Version:    0.6.0
 */