/*     */ package org.jboss.util.property;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ 
/*     */ public final class Property
/*     */ {
/*     */   public static String LINE_SEPARATOR;
/*     */   public static String FILE_SEPARATOR;
/*     */   public static String PATH_SEPARATOR;
/*     */ 
/*     */   public static void addListener(PropertyListener listener)
/*     */   {
/*  67 */     PropertyManager.addPropertyListener(listener);
/*     */   }
/*     */ 
/*     */   public static void addListeners(PropertyListener[] listeners)
/*     */   {
/*  77 */     PropertyManager.addPropertyListeners(listeners);
/*     */   }
/*     */ 
/*     */   public static boolean removeListener(PropertyListener listener)
/*     */   {
/*  88 */     return PropertyManager.removePropertyListener(listener);
/*     */   }
/*     */ 
/*     */   public static String set(String name, String value)
/*     */   {
/* 100 */     return PropertyManager.setProperty(name, value);
/*     */   }
/*     */ 
/*     */   public static String remove(String name)
/*     */   {
/* 111 */     return PropertyManager.getProperty(name);
/*     */   }
/*     */ 
/*     */   public static String get(String name, String defaultValue)
/*     */   {
/* 123 */     return PropertyManager.getProperty(name, defaultValue);
/*     */   }
/*     */ 
/*     */   public static String get(String name)
/*     */   {
/* 134 */     return PropertyManager.getProperty(name);
/*     */   }
/*     */ 
/*     */   public static String[] getArray(String base, String[] defaultValues)
/*     */   {
/* 146 */     return PropertyManager.getArrayProperty(base, defaultValues);
/*     */   }
/*     */ 
/*     */   public static String[] getArray(String name)
/*     */   {
/* 157 */     return PropertyManager.getArrayProperty(name);
/*     */   }
/*     */ 
/*     */   public static boolean exists(String name)
/*     */   {
/* 168 */     return PropertyManager.containsProperty(name);
/*     */   }
/*     */ 
/*     */   public static PropertyGroup getGroup(String basename)
/*     */   {
/* 179 */     return PropertyManager.getPropertyGroup(basename);
/*     */   }
/*     */ 
/*     */   public static PropertyGroup getGroup(String basename, int index)
/*     */   {
/* 191 */     return PropertyManager.getPropertyGroup(basename, index);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  47 */     PrivilegedAction action = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/*  51 */         Property.LINE_SEPARATOR = Property.get("line.separator");
/*  52 */         Property.FILE_SEPARATOR = Property.get("file.separator");
/*  53 */         Property.PATH_SEPARATOR = Property.get("path.separator");
/*  54 */         return null;
/*     */       }
/*     */     };
/*  57 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.Property
 * JD-Core Version:    0.6.0
 */