/*     */ package org.jboss.util.property;
/*     */ 
/*     */ import java.beans.BeanInfo;
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.Introspector;
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.beans.PropertyEditor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.util.ThrowableHandler;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class MethodBoundPropertyListener extends BoundPropertyAdapter
/*     */ {
/*     */   protected final String propertyName;
/*     */   protected final Object instance;
/*     */   protected final Method setter;
/*     */   protected final PropertyDescriptor descriptor;
/*     */ 
/*     */   public MethodBoundPropertyListener(Object instance, String propertyName, String beanPropertyName)
/*     */   {
/*  69 */     this.instance = instance;
/*  70 */     this.propertyName = propertyName;
/*     */     try
/*     */     {
/*  73 */       this.descriptor = getPropertyDescriptor(beanPropertyName);
/*  74 */       if (this.descriptor == null) {
/*  75 */         throw new PropertyException("missing method for: " + beanPropertyName);
/*     */       }
/*     */ 
/*  79 */       this.setter = this.descriptor.getWriteMethod();
/*  80 */       if (this.setter == null) {
/*  81 */         throw new PropertyException("missing setter method for: " + beanPropertyName);
/*     */       }
/*     */       try
/*     */       {
/*  85 */         this.setter.setAccessible(true);
/*     */       }
/*     */       catch (SecurityException e) {
/*  88 */         ThrowableHandler.add(e);
/*     */       }
/*     */     }
/*     */     catch (IntrospectionException e) {
/*  92 */       throw new PropertyException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private PropertyDescriptor getPropertyDescriptor(String beanPropertyName)
/*     */     throws IntrospectionException
/*     */   {
/* 105 */     Class instanceType = this.instance.getClass();
/* 106 */     BeanInfo beanInfo = Introspector.getBeanInfo(instanceType);
/* 107 */     PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
/* 108 */     PropertyDescriptor descriptor = null;
/*     */ 
/* 110 */     for (int i = 0; i < descriptors.length; i++) {
/* 111 */       if (descriptors[i].getName().equals(beanPropertyName)) {
/* 112 */         descriptor = descriptors[i];
/* 113 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 117 */     return descriptor;
/*     */   }
/*     */ 
/*     */   public MethodBoundPropertyListener(Object instance, String propertyName)
/*     */   {
/* 129 */     this(instance, propertyName, propertyName);
/*     */   }
/*     */ 
/*     */   public final String getPropertyName()
/*     */   {
/* 138 */     return this.propertyName;
/*     */   }
/*     */ 
/*     */   protected void invokeSetter(String value)
/*     */   {
/*     */     try
/*     */     {
/* 151 */       Class type = this.descriptor.getPropertyType();
/* 152 */       PropertyEditor editor = PropertyEditors.findEditor(type);
/* 153 */       editor.setAsText(value);
/* 154 */       Object coerced = editor.getValue();
/*     */ 
/* 159 */       this.setter.invoke(this.instance, new Object[] { coerced });
/*     */     }
/*     */     catch (InvocationTargetException e) {
/* 162 */       Throwable target = e.getTargetException();
/* 163 */       if ((target instanceof PropertyException)) {
/* 164 */         throw ((PropertyException)target);
/*     */       }
/*     */ 
/* 167 */       throw new PropertyException(target);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 171 */       throw new PropertyException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void propertyAdded(PropertyEvent event)
/*     */   {
/* 181 */     invokeSetter(event.getPropertyValue());
/*     */   }
/*     */ 
/*     */   public void propertyChanged(PropertyEvent event)
/*     */   {
/* 190 */     invokeSetter(event.getPropertyValue());
/*     */   }
/*     */ 
/*     */   public void propertyBound(PropertyMap map)
/*     */   {
/* 200 */     if (map.containsProperty(this.propertyName))
/* 201 */       invokeSetter(map.getProperty(this.propertyName));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.MethodBoundPropertyListener
 * JD-Core Version:    0.6.0
 */