/*     */ package org.jboss.util.loading;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ 
/*     */ public class ContextClassLoaderSwitcher extends ContextClassLoader
/*     */ {
/*  49 */   public static final RuntimePermission SETCONTEXTCLASSLOADER = new RuntimePermission("setContextClassLoader");
/*     */ 
/*  54 */   public static final NewInstance INSTANTIATOR = new NewInstance(null);
/*     */ 
/*     */   private ContextClassLoaderSwitcher()
/*     */   {
/*  63 */     SecurityManager manager = System.getSecurityManager();
/*  64 */     if (manager != null)
/*  65 */       manager.checkPermission(SETCONTEXTCLASSLOADER);
/*     */   }
/*     */ 
/*     */   public void setContextClassLoader(ClassLoader cl)
/*     */   {
/*  75 */     setContextClassLoader(Thread.currentThread(), cl);
/*     */   }
/*     */ 
/*     */   public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */   {
/*  86 */     AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */     {
/*     */       public Object run()
/*     */       {
/*  90 */         this.val$thread.setContextClassLoader(this.val$cl);
/*  91 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public SwitchContext getSwitchContext()
/*     */   {
/* 103 */     return new SwitchContext(null);
/*     */   }
/*     */ 
/*     */   public SwitchContext getSwitchContext(ClassLoader cl)
/*     */   {
/* 114 */     return new SwitchContext(cl, null);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public SwitchContext getSwitchContext(Class clazz)
/*     */   {
/* 128 */     return new SwitchContext(clazz.getClassLoader(), null);
/*     */   }
/*     */ 
/*     */   private static class NewInstance
/*     */     implements PrivilegedAction
/*     */   {
/*     */     public Object run()
/*     */     {
/* 233 */       return new ContextClassLoaderSwitcher(null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public class SwitchContext
/*     */   {
/*     */     private ClassLoader origCL;
/*     */     private ClassLoader currentCL;
/*     */     private Thread currentThread;
/*     */ 
/*     */     private SwitchContext()
/*     */     {
/* 154 */       this.currentThread = Thread.currentThread();
/* 155 */       this.origCL = ???.getContextClassLoader(this.currentThread);
/* 156 */       this.currentCL = this.origCL;
/*     */     }
/*     */ 
/*     */     private SwitchContext(ClassLoader cl)
/*     */     {
/* 161 */       this();
/* 162 */       setClassLoader(cl);
/*     */     }
/*     */ 
/*     */     public Thread getThread()
/*     */     {
/* 170 */       return this.currentThread;
/*     */     }
/*     */ 
/*     */     public ClassLoader getOriginalClassLoader()
/*     */     {
/* 178 */       return this.origCL;
/*     */     }
/*     */ 
/*     */     public ClassLoader getCurrentClassLoader()
/*     */     {
/* 187 */       return this.currentCL;
/*     */     }
/*     */ 
/*     */     public void setClassLoader(ClassLoader cl)
/*     */     {
/* 200 */       if ((cl != null) && (cl != this.currentCL))
/*     */       {
/* 202 */         this.this$0.setContextClassLoader(this.currentThread, cl);
/* 203 */         this.currentCL = cl;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void reset()
/*     */     {
/* 213 */       if ((this.currentCL != null) && (this.currentCL != this.origCL))
/* 214 */         this.this$0.setContextClassLoader(this.currentThread, this.origCL);
/*     */     }
/*     */ 
/*     */     public void forceReset()
/*     */     {
/* 224 */       this.this$0.setContextClassLoader(this.currentThread, this.origCL);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.loading.ContextClassLoaderSwitcher
 * JD-Core Version:    0.6.0
 */