/*     */ package org.jboss.util.id;
/*     */ 
/*     */ public class GUID
/*     */   implements ID, Comparable
/*     */ {
/*     */   static final long serialVersionUID = 3289509836244263718L;
/*     */   protected final VMID vmid;
/*     */   protected final UID uid;
/*     */   protected final int hashCode;
/*     */ 
/*     */   public GUID()
/*     */   {
/*  64 */     this.vmid = VMID.getInstance();
/*  65 */     this.uid = new UID();
/*     */ 
/*  68 */     int code = this.vmid.hashCode();
/*  69 */     code ^= this.uid.hashCode();
/*  70 */     this.hashCode = code;
/*     */   }
/*     */ 
/*     */   protected GUID(GUID guid)
/*     */   {
/*  79 */     this.vmid = guid.vmid;
/*  80 */     this.uid = guid.uid;
/*  81 */     this.hashCode = guid.hashCode;
/*     */   }
/*     */ 
/*     */   public final VMID getVMID()
/*     */   {
/*  90 */     return this.vmid;
/*     */   }
/*     */ 
/*     */   public final UID getUID()
/*     */   {
/*  99 */     return this.uid;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 108 */     return this.vmid.toString() + "-" + this.uid.toString();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 117 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 130 */     if (obj == this) return true;
/*     */ 
/* 132 */     if ((obj != null) && (obj.getClass() == getClass())) {
/* 133 */       GUID guid = (GUID)obj;
/*     */ 
/* 135 */       return (guid.vmid.equals(this.vmid)) && (guid.uid.equals(this.uid));
/*     */     }
/*     */ 
/* 140 */     return false;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 150 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 153 */     throw new InternalError();
/*     */   }
/*     */ 
/*     */   public static String asString()
/*     */   {
/* 163 */     return new GUID().toString();
/*     */   }
/*     */ 
/*     */   public int compareTo(Object o)
/*     */   {
/* 168 */     GUID guid = (GUID)o;
/* 169 */     return toString().compareTo(guid.toString());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.id.GUID
 * JD-Core Version:    0.6.0
 */