/*    */ package org.jboss.util.file;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.FilenameFilter;
/*    */ 
/*    */ public class FilenameSuffixFilter
/*    */   implements FilenameFilter
/*    */ {
/*    */   protected final String suffix;
/*    */   protected final boolean ignoreCase;
/*    */ 
/*    */   public FilenameSuffixFilter(String suffix, boolean ignoreCase)
/*    */   {
/* 51 */     this.ignoreCase = ignoreCase;
/* 52 */     this.suffix = (ignoreCase ? suffix.toLowerCase() : suffix);
/*    */   }
/*    */ 
/*    */   public FilenameSuffixFilter(String suffix)
/*    */   {
/* 61 */     this(suffix, false);
/*    */   }
/*    */ 
/*    */   public boolean accept(File dir, String name)
/*    */   {
/* 72 */     if (this.ignoreCase) {
/* 73 */       return name.toLowerCase().endsWith(this.suffix);
/*    */     }
/*    */ 
/* 76 */     return name.endsWith(this.suffix);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.FilenameSuffixFilter
 * JD-Core Version:    0.6.0
 */