/*    */ package org.jboss.util.deadlock;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.HashSet;
/*    */ 
/*    */ public class DeadlockDetector
/*    */ {
/* 37 */   public static DeadlockDetector singleton = new DeadlockDetector();
/*    */ 
/* 39 */   protected HashMap waiting = new HashMap();
/*    */ 
/*    */   public void deadlockDetection(Object holder, Resource resource)
/*    */     throws ApplicationDeadlockException
/*    */   {
/* 44 */     HashSet set = new HashSet();
/* 45 */     set.add(holder);
/*    */ 
/* 47 */     Object checkHolder = resource.getResourceHolder();
/*    */ 
/* 49 */     synchronized (this.waiting)
/*    */     {
/* 51 */       addWaiting(holder, resource);
/*    */ 
/* 53 */       while (checkHolder != null)
/*    */       {
/* 55 */         Resource waitingFor = (Resource)this.waiting.get(checkHolder);
/* 56 */         Object holding = null;
/* 57 */         if (waitingFor != null)
/*    */         {
/* 59 */           holding = waitingFor.getResourceHolder();
/*    */         }
/* 61 */         if (holding != null)
/*    */         {
/* 63 */           if (set.contains(holding))
/*    */           {
/* 66 */             String msg = "Application deadlock detected, resource=" + resource + ", holder=" + holder + ", waitingResource=" + waitingFor + ", waitingResourceHolder=" + holding;
/*    */ 
/* 69 */             throw new ApplicationDeadlockException(msg, true);
/*    */           }
/* 71 */           set.add(holding);
/*    */         }
/* 73 */         checkHolder = holding;
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public void addWaiting(Object holder, Resource resource)
/*    */   {
/* 83 */     synchronized (this.waiting)
/*    */     {
/* 85 */       this.waiting.put(holder, resource);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void removeWaiting(Object holder)
/*    */   {
/* 94 */     synchronized (this.waiting)
/*    */     {
/* 96 */       this.waiting.remove(holder);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.deadlock.DeadlockDetector
 * JD-Core Version:    0.6.0
 */