/*    */ package org.jboss.util.collection;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import java.util.Enumeration;
/*    */ import java.util.NoSuchElementException;
/*    */ 
/*    */ public class SerializableEnumeration extends ArrayList
/*    */   implements Enumeration
/*    */ {
/*    */   private int index;
/*    */ 
/*    */   public SerializableEnumeration()
/*    */   {
/* 42 */     this.index = 0;
/*    */   }
/*    */ 
/*    */   public SerializableEnumeration(Collection c) {
/* 46 */     super(c);
/* 47 */     this.index = 0;
/*    */   }
/*    */ 
/*    */   public SerializableEnumeration(int initialCapacity) {
/* 51 */     super(initialCapacity);
/* 52 */     this.index = 0;
/*    */   }
/*    */ 
/*    */   public boolean hasMoreElements() {
/* 56 */     return this.index < size();
/*    */   }
/*    */ 
/*    */   public Object nextElement() throws NoSuchElementException
/*    */   {
/*    */     try {
/* 62 */       Object nextObj = get(this.index);
/* 63 */       this.index += 1;
/* 64 */       return nextObj;
/*    */     } catch (IndexOutOfBoundsException e) {
/*    */     }
/* 67 */     throw new NoSuchElementException();
/*    */   }
/*    */ 
/*    */   private void writeObject(ObjectOutputStream out)
/*    */     throws IOException
/*    */   {
/* 75 */     out.defaultWriteObject();
/*    */   }
/*    */ 
/*    */   private void readObject(ObjectInputStream in)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 81 */     in.defaultReadObject();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.SerializableEnumeration
 * JD-Core Version:    0.6.0
 */