/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class LazySet<T>
/*     */   implements Set<T>, Serializable
/*     */ {
/*  42 */   private Set<T> delegate = Collections.emptySet();
/*     */ 
/*     */   private Set<T> createImplementation()
/*     */   {
/*  51 */     if (!(this.delegate instanceof HashSet))
/*  52 */       return new HashSet(this.delegate);
/*  53 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public boolean add(T o)
/*     */   {
/*  58 */     if (this.delegate.isEmpty())
/*     */     {
/*  60 */       this.delegate = Collections.singleton(o);
/*  61 */       return true;
/*     */     }
/*     */ 
/*  65 */     this.delegate = createImplementation();
/*  66 */     return this.delegate.add(o);
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection<? extends T> c)
/*     */   {
/*  72 */     this.delegate = createImplementation();
/*  73 */     return this.delegate.addAll(c);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  78 */     this.delegate = Collections.emptySet();
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/*  83 */     return this.delegate.contains(o);
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection<?> c)
/*     */   {
/*  88 */     return this.delegate.containsAll(c);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/*  93 */     return this.delegate.isEmpty();
/*     */   }
/*     */ 
/*     */   public Iterator<T> iterator()
/*     */   {
/*  98 */     return this.delegate.iterator();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 103 */     this.delegate = createImplementation();
/* 104 */     return this.delegate.remove(o);
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection<?> c)
/*     */   {
/* 109 */     this.delegate = createImplementation();
/* 110 */     return this.delegate.removeAll(c);
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection<?> c)
/*     */   {
/* 115 */     this.delegate = createImplementation();
/* 116 */     return this.delegate.retainAll(c);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 121 */     return this.delegate.size();
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 126 */     return this.delegate.toArray();
/*     */   }
/*     */ 
/*     */   public <U> U[] toArray(U[] a)
/*     */   {
/* 131 */     return this.delegate.toArray(a);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.LazySet
 * JD-Core Version:    0.6.0
 */