/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class LazyMap<K, V>
/*     */   implements Map<K, V>, Serializable
/*     */ {
/*  43 */   private Map<K, V> delegate = Collections.emptyMap();
/*     */ 
/*     */   private Map<K, V> createImplementation()
/*     */   {
/*  52 */     if (!(this.delegate instanceof HashMap))
/*  53 */       return new HashMap(this.delegate);
/*  54 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  59 */     this.delegate = Collections.emptyMap();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/*  64 */     return this.delegate.containsKey(key);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object value)
/*     */   {
/*  69 */     return this.delegate.containsValue(value);
/*     */   }
/*     */ 
/*     */   public Set<Map.Entry<K, V>> entrySet()
/*     */   {
/*  74 */     return this.delegate.entrySet();
/*     */   }
/*     */ 
/*     */   public V get(Object key)
/*     */   {
/*  79 */     return this.delegate.get(key);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/*  84 */     return this.delegate.isEmpty();
/*     */   }
/*     */ 
/*     */   public Set<K> keySet()
/*     */   {
/*  89 */     return this.delegate.keySet();
/*     */   }
/*     */ 
/*     */   public V put(K key, V value)
/*     */   {
/*  94 */     if (this.delegate.isEmpty())
/*     */     {
/*  96 */       this.delegate = Collections.singletonMap(key, value);
/*  97 */       return null;
/*     */     }
/*     */ 
/* 101 */     this.delegate = createImplementation();
/* 102 */     return this.delegate.put(key, value);
/*     */   }
/*     */ 
/*     */   public void putAll(Map<? extends K, ? extends V> t)
/*     */   {
/* 108 */     this.delegate = createImplementation();
/* 109 */     this.delegate.putAll(t);
/*     */   }
/*     */ 
/*     */   public V remove(Object key)
/*     */   {
/* 114 */     this.delegate = createImplementation();
/* 115 */     return this.delegate.remove(key);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 120 */     return this.delegate.size();
/*     */   }
/*     */ 
/*     */   public Collection<V> values()
/*     */   {
/* 125 */     return this.delegate.values();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.LazyMap
 * JD-Core Version:    0.6.0
 */