/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.lang.ref.ReferenceQueue;
/*     */ import java.util.AbstractCollection;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.util.Objects;
/*     */ import org.jboss.util.SoftObject;
/*     */ 
/*     */ public class CachedCollection extends AbstractCollection
/*     */ {
/*  45 */   protected final ReferenceQueue queue = new ReferenceQueue();
/*     */   protected final Collection collection;
/*     */ 
/*     */   public CachedCollection(Collection collection)
/*     */   {
/*  56 */     this.collection = collection;
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/*  65 */     maintain();
/*  66 */     return new MyIterator(this.collection.iterator());
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  75 */     maintain();
/*  76 */     return this.collection.size();
/*     */   }
/*     */ 
/*     */   public boolean add(Object obj)
/*     */   {
/*  86 */     maintain();
/*     */ 
/*  88 */     SoftObject soft = SoftObject.create(obj, this.queue);
/*     */ 
/*  90 */     return this.collection.add(soft);
/*     */   }
/*     */ 
/*     */   private void maintain()
/*     */   {
/*  98 */     int count = 0;
/*     */     SoftObject obj;
/* 100 */     while ((obj = (SoftObject)this.queue.poll()) != null) {
/* 101 */       count++;
/* 102 */       this.collection.remove(obj);
/*     */     }
/*     */ 
/* 105 */     if (count != 0)
/*     */     {
/* 107 */       System.err.println("vm reclaimed " + count + " objects");
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class MyIterator
/*     */     implements Iterator
/*     */   {
/*     */     private final Iterator iter;
/*     */ 
/*     */     public MyIterator(Iterator iter)
/*     */     {
/* 125 */       this.iter = iter;
/*     */     }
/*     */ 
/*     */     public boolean hasNext() {
/* 129 */       CachedCollection.this.maintain();
/* 130 */       return this.iter.hasNext();
/*     */     }
/*     */ 
/*     */     private Object nextObject() {
/* 134 */       Object obj = this.iter.next();
/*     */ 
/* 136 */       return Objects.deref(obj);
/*     */     }
/*     */ 
/*     */     public Object next() {
/* 140 */       CachedCollection.this.maintain();
/* 141 */       return nextObject();
/*     */     }
/*     */ 
/*     */     public void remove() {
/* 145 */       CachedCollection.this.maintain();
/* 146 */       this.iter.remove();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.CachedCollection
 * JD-Core Version:    0.6.0
 */