/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.lang.ref.ReferenceQueue;
/*     */ import java.lang.ref.SoftReference;
/*     */ 
/*     */ public final class SoftObject extends SoftReference
/*     */ {
/*     */   protected final int hashCode;
/*     */ 
/*     */   public SoftObject(Object obj)
/*     */   {
/*  47 */     super(obj);
/*  48 */     this.hashCode = obj.hashCode();
/*     */   }
/*     */ 
/*     */   public SoftObject(Object obj, ReferenceQueue queue)
/*     */   {
/*  58 */     super(obj, queue);
/*  59 */     this.hashCode = obj.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  69 */     if (obj == this) return true;
/*     */ 
/*  71 */     if ((obj != null) && (obj.getClass() == getClass())) {
/*  72 */       SoftObject soft = (SoftObject)obj;
/*     */ 
/*  74 */       Object a = get();
/*  75 */       Object b = soft.get();
/*  76 */       if ((a == null) || (b == null)) return false;
/*  77 */       if (a == b) return true;
/*     */ 
/*  79 */       return a.equals(b);
/*     */     }
/*     */ 
/*  82 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  91 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public static SoftObject create(Object obj)
/*     */   {
/* 106 */     if (obj == null) return null;
/* 107 */     return new SoftObject(obj);
/*     */   }
/*     */ 
/*     */   public static SoftObject create(Object obj, ReferenceQueue queue)
/*     */   {
/* 120 */     if (obj == null) return null;
/* 121 */     return new SoftObject(obj, queue);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.SoftObject
 * JD-Core Version:    0.6.0
 */