/*     */ package org.jboss.util;
/*     */ 
/*     */ public class NullArgumentException extends IllegalArgumentException
/*     */ {
/*     */   protected final String name;
/*     */   protected final Object index;
/*     */ 
/*     */   public NullArgumentException(String name)
/*     */   {
/*  46 */     super(makeMessage(name));
/*     */ 
/*  48 */     this.name = name;
/*  49 */     this.index = null;
/*     */   }
/*     */ 
/*     */   public NullArgumentException(String name, long index)
/*     */   {
/*  59 */     super(makeMessage(name, new Long(index)));
/*     */ 
/*  61 */     this.name = name;
/*  62 */     this.index = new Long(index);
/*     */   }
/*     */ 
/*     */   public NullArgumentException(String name, Object index)
/*     */   {
/*  72 */     super(makeMessage(name, index));
/*     */ 
/*  74 */     this.name = name;
/*  75 */     this.index = index;
/*     */   }
/*     */ 
/*     */   public NullArgumentException()
/*     */   {
/*  82 */     this.name = null;
/*  83 */     this.index = null;
/*     */   }
/*     */ 
/*     */   public final String getArgumentName()
/*     */   {
/*  92 */     return this.name;
/*     */   }
/*     */ 
/*     */   public final Object getArgumentIndex()
/*     */   {
/* 101 */     return this.index;
/*     */   }
/*     */ 
/*     */   private static String makeMessage(String name)
/*     */   {
/* 108 */     return "'" + name + "' is null";
/*     */   }
/*     */ 
/*     */   private static String makeMessage(String name, Object index)
/*     */   {
/* 115 */     return "'" + name + "[" + index + "]' is null";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.NullArgumentException
 * JD-Core Version:    0.6.0
 */