/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ 
/*     */ public class LRUCachePolicy
/*     */   implements CachePolicy
/*     */ {
/*     */   protected HashMap m_map;
/*     */   protected LRUList m_list;
/*     */   protected int m_maxCapacity;
/*     */   protected int m_minCapacity;
/*     */ 
/*     */   public LRUCachePolicy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public LRUCachePolicy(int min, int max)
/*     */   {
/*  74 */     if ((min < 2) || (min > max)) throw new IllegalArgumentException("Illegal cache capacities");
/*  75 */     this.m_minCapacity = min;
/*  76 */     this.m_maxCapacity = max;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/*  90 */     this.m_map = new HashMap();
/*  91 */     this.m_list = createList();
/*  92 */     this.m_list.m_maxCapacity = this.m_maxCapacity;
/*  93 */     this.m_list.m_minCapacity = this.m_minCapacity;
/*  94 */     this.m_list.m_capacity = this.m_maxCapacity;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 112 */     if (this.m_list != null)
/*     */     {
/* 114 */       flush();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 126 */     if (this.m_map != null)
/* 127 */       this.m_map.clear();
/* 128 */     if (this.m_list != null)
/* 129 */       this.m_list.clear();
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 134 */     if (key == null)
/*     */     {
/* 136 */       throw new IllegalArgumentException("Requesting an object using a null key");
/*     */     }
/*     */ 
/* 139 */     LRUCacheEntry value = (LRUCacheEntry)this.m_map.get(key);
/* 140 */     if (value != null)
/*     */     {
/* 142 */       this.m_list.promote(value);
/* 143 */       return value.m_object;
/*     */     }
/*     */ 
/* 147 */     cacheMiss();
/* 148 */     return null;
/*     */   }
/*     */ 
/*     */   public Object peek(Object key)
/*     */   {
/* 153 */     if (key == null)
/*     */     {
/* 155 */       throw new IllegalArgumentException("Requesting an object using a null key");
/*     */     }
/*     */ 
/* 158 */     LRUCacheEntry value = (LRUCacheEntry)this.m_map.get(key);
/* 159 */     if (value == null)
/*     */     {
/* 161 */       return null;
/*     */     }
/*     */ 
/* 165 */     return value.m_object;
/*     */   }
/*     */ 
/*     */   public void insert(Object key, Object o)
/*     */   {
/* 170 */     if (o == null) throw new IllegalArgumentException("Cannot insert a null object in the cache");
/* 171 */     if (key == null) throw new IllegalArgumentException("Cannot insert an object in the cache with null key");
/* 172 */     if (this.m_map.containsKey(key))
/*     */     {
/* 174 */       throw new IllegalStateException("Attempt to put in the cache an object that is already there");
/*     */     }
/* 176 */     this.m_list.demote();
/* 177 */     LRUCacheEntry entry = createCacheEntry(key, o);
/* 178 */     this.m_map.put(key, entry);
/* 179 */     this.m_list.promote(entry);
/*     */   }
/*     */ 
/*     */   public void remove(Object key) {
/* 183 */     if (key == null) throw new IllegalArgumentException("Removing an object using a null key");
/*     */ 
/* 185 */     Object value = this.m_map.remove(key);
/* 186 */     if (value != null)
/*     */     {
/* 188 */       this.m_list.remove((LRUCacheEntry)value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 194 */     LRUCacheEntry entry = null;
/* 195 */     while ((entry = this.m_list.m_tail) != null)
/*     */     {
/* 197 */       ageOut(entry);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int size() {
/* 202 */     return this.m_list.m_count;
/*     */   }
/*     */ 
/*     */   protected LRUList createList()
/*     */   {
/* 213 */     return new LRUList();
/*     */   }
/*     */ 
/*     */   protected void ageOut(LRUCacheEntry entry)
/*     */   {
/* 221 */     remove(entry.m_key);
/*     */   }
/*     */ 
/*     */   protected void cacheMiss()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected LRUCacheEntry createCacheEntry(Object key, Object value)
/*     */   {
/* 234 */     return new LRUCacheEntry(key, value);
/*     */   }
/*     */ 
/*     */   public class LRUCacheEntry
/*     */   {
/*     */     public LRUCacheEntry m_next;
/*     */     public LRUCacheEntry m_prev;
/*     */     public Object m_key;
/*     */     public Object m_object;
/*     */     public long m_time;
/*     */ 
/*     */     protected LRUCacheEntry(Object key, Object object)
/*     */     {
/* 463 */       this.m_key = key;
/* 464 */       this.m_object = object;
/* 465 */       this.m_next = null;
/* 466 */       this.m_prev = null;
/* 467 */       this.m_time = 0L;
/*     */     }
/*     */ 
/*     */     public String toString() {
/* 471 */       return "key: " + this.m_key + ", object: " + (this.m_object == null ? "null" : Integer.toHexString(this.m_object.hashCode())) + ", entry: " + Integer.toHexString(super.hashCode());
/*     */     }
/*     */   }
/*     */ 
/*     */   public class LRUList
/*     */   {
/*     */     public int m_maxCapacity;
/*     */     public int m_minCapacity;
/*     */     public int m_capacity;
/*     */     public int m_count;
/*     */     public LRUCachePolicy.LRUCacheEntry m_head;
/*     */     public LRUCachePolicy.LRUCacheEntry m_tail;
/*     */     public int m_cacheMiss;
/*     */ 
/*     */     protected LRUList()
/*     */     {
/* 264 */       this.m_head = null;
/* 265 */       this.m_tail = null;
/* 266 */       this.m_count = 0;
/*     */     }
/*     */ 
/*     */     protected void promote(LRUCachePolicy.LRUCacheEntry entry)
/*     */     {
/* 278 */       if (entry == null) throw new IllegalArgumentException("Trying to promote a null object");
/* 279 */       if (this.m_capacity < 1) throw new IllegalStateException("Can't work with capacity < 1");
/*     */ 
/* 281 */       entryPromotion(entry);
/*     */ 
/* 283 */       entry.m_time = System.currentTimeMillis();
/* 284 */       if (entry.m_prev == null)
/*     */       {
/* 286 */         if (entry.m_next == null)
/*     */         {
/* 289 */           if (this.m_count == 0)
/*     */           {
/* 291 */             this.m_head = entry;
/* 292 */             this.m_tail = entry;
/* 293 */             this.m_count += 1;
/* 294 */             entryAdded(entry);
/*     */           }
/* 296 */           else if ((this.m_count != 1) || (this.m_head != entry)) {
/* 297 */             if (this.m_count < this.m_capacity)
/*     */             {
/* 299 */               entry.m_prev = null;
/* 300 */               entry.m_next = this.m_head;
/* 301 */               this.m_head.m_prev = entry;
/* 302 */               this.m_head = entry;
/* 303 */               this.m_count += 1;
/* 304 */               entryAdded(entry);
/*     */             }
/* 306 */             else if (this.m_count < this.m_maxCapacity)
/*     */             {
/* 308 */               entry.m_prev = null;
/* 309 */               entry.m_next = this.m_head;
/* 310 */               this.m_head.m_prev = entry;
/* 311 */               this.m_head = entry;
/* 312 */               this.m_count += 1;
/* 313 */               int oldCapacity = this.m_capacity;
/* 314 */               this.m_capacity += 1;
/* 315 */               entryAdded(entry);
/* 316 */               capacityChanged(oldCapacity);
/*     */             } else {
/* 318 */               throw new IllegalStateException("Attempt to put a new cache entry on a full cache");
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/* 324 */       else if (entry.m_next == null)
/*     */       {
/* 326 */         LRUCachePolicy.LRUCacheEntry beforeLast = entry.m_prev;
/* 327 */         beforeLast.m_next = null;
/* 328 */         entry.m_prev = null;
/* 329 */         entry.m_next = this.m_head;
/* 330 */         this.m_head.m_prev = entry;
/* 331 */         this.m_head = entry;
/* 332 */         this.m_tail = beforeLast;
/*     */       }
/*     */       else
/*     */       {
/* 336 */         LRUCachePolicy.LRUCacheEntry previous = entry.m_prev;
/* 337 */         previous.m_next = entry.m_next;
/* 338 */         entry.m_next.m_prev = previous;
/* 339 */         entry.m_prev = null;
/* 340 */         entry.m_next = this.m_head;
/* 341 */         this.m_head.m_prev = entry;
/* 342 */         this.m_head = entry;
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void demote()
/*     */     {
/* 353 */       if (this.m_capacity < 1) throw new IllegalStateException("Can't work with capacity < 1");
/* 354 */       if (this.m_count > this.m_maxCapacity) throw new IllegalStateException("Cache list entries number (" + this.m_count + ") > than the maximum allowed (" + this.m_maxCapacity + ")");
/* 355 */       if (this.m_count == this.m_maxCapacity)
/*     */       {
/* 357 */         LRUCachePolicy.LRUCacheEntry entry = this.m_tail;
/*     */ 
/* 360 */         LRUCachePolicy.this.ageOut(entry);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void remove(LRUCachePolicy.LRUCacheEntry entry)
/*     */     {
/* 369 */       if (entry == null) throw new IllegalArgumentException("Cannot remove a null entry from the cache");
/* 370 */       if (this.m_count < 1) throw new IllegalStateException("Trying to remove an entry from an empty cache");
/*     */ 
/* 372 */       entry.m_key = (entry.m_object = null);
/* 373 */       if (this.m_count == 1)
/*     */       {
/* 375 */         this.m_head = (this.m_tail = null);
/*     */       }
/* 379 */       else if (entry.m_prev == null)
/*     */       {
/* 381 */         this.m_head = entry.m_next;
/* 382 */         this.m_head.m_prev = null;
/* 383 */         entry.m_next = null;
/*     */       }
/* 385 */       else if (entry.m_next == null)
/*     */       {
/* 387 */         this.m_tail = entry.m_prev;
/* 388 */         this.m_tail.m_next = null;
/* 389 */         entry.m_prev = null;
/*     */       }
/*     */       else
/*     */       {
/* 393 */         entry.m_next.m_prev = entry.m_prev;
/* 394 */         entry.m_prev.m_next = entry.m_next;
/* 395 */         entry.m_prev = null;
/* 396 */         entry.m_next = null;
/*     */       }
/*     */ 
/* 399 */       this.m_count -= 1;
/* 400 */       entryRemoved(entry);
/*     */     }
/*     */ 
/*     */     protected void entryPromotion(LRUCachePolicy.LRUCacheEntry entry)
/*     */     {
/*     */     }
/*     */ 
/*     */     protected void entryAdded(LRUCachePolicy.LRUCacheEntry entry)
/*     */     {
/*     */     }
/*     */ 
/*     */     protected void entryRemoved(LRUCachePolicy.LRUCacheEntry entry)
/*     */     {
/*     */     }
/*     */ 
/*     */     protected void capacityChanged(int oldCapacity)
/*     */     {
/*     */     }
/*     */ 
/*     */     protected void clear()
/*     */     {
/* 422 */       LRUCachePolicy.LRUCacheEntry entry = this.m_head;
/* 423 */       this.m_head = null;
/* 424 */       this.m_tail = null;
/* 425 */       this.m_count = 0;
/* 426 */       for (; entry != null; entry = entry.m_next)
/* 427 */         entryRemoved(entry);
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 432 */       String s = Integer.toHexString(super.hashCode());
/* 433 */       s = s + " size: " + this.m_count;
/* 434 */       for (LRUCachePolicy.LRUCacheEntry entry = this.m_head; entry != null; entry = entry.m_next)
/*     */       {
/* 436 */         s = s + "\n" + entry;
/*     */       }
/* 438 */       return s;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.LRUCachePolicy
 * JD-Core Version:    0.6.0
 */