/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public final class HashCode
/*     */   implements Serializable, Cloneable, Comparable
/*     */ {
/*     */   private static final int NULL_HASHCODE = 0;
/*     */   private static final int TRUE_HASHCODE = 1231;
/*     */   private static final int FALSE_HASHCODE = 1237;
/*     */   private int value;
/*     */ 
/*     */   public HashCode(int value)
/*     */   {
/*  55 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public HashCode()
/*     */   {
/*  62 */     this(0);
/*     */   }
/*     */ 
/*     */   public HashCode add(boolean b)
/*     */   {
/*  72 */     this.value ^= generate(b);
/*  73 */     return this;
/*     */   }
/*     */ 
/*     */   public HashCode add(byte n)
/*     */   {
/*  83 */     this.value ^= n;
/*  84 */     return this;
/*     */   }
/*     */ 
/*     */   public HashCode add(char n)
/*     */   {
/*  94 */     this.value ^= n;
/*  95 */     return this;
/*     */   }
/*     */ 
/*     */   public HashCode add(short n)
/*     */   {
/* 105 */     this.value ^= n;
/* 106 */     return this;
/*     */   }
/*     */ 
/*     */   public HashCode add(int n)
/*     */   {
/* 116 */     this.value ^= n;
/* 117 */     return this;
/*     */   }
/*     */ 
/*     */   public HashCode add(long n)
/*     */   {
/* 127 */     this.value ^= generate(n);
/* 128 */     return this;
/*     */   }
/*     */ 
/*     */   public HashCode add(float f)
/*     */   {
/* 138 */     this.value ^= generate(f);
/* 139 */     return this;
/*     */   }
/*     */ 
/*     */   public HashCode add(double f)
/*     */   {
/* 149 */     this.value ^= generate(f);
/* 150 */     return this;
/*     */   }
/*     */ 
/*     */   public HashCode add(Object obj)
/*     */   {
/* 160 */     this.value ^= generate(obj);
/* 161 */     return this;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 170 */     return this.value;
/*     */   }
/*     */ 
/*     */   public int compareTo(int other)
/*     */   {
/* 182 */     return this.value == other ? 0 : this.value < other ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public int compareTo(Object obj)
/*     */     throws ClassCastException
/*     */   {
/* 196 */     HashCode hashCode = (HashCode)obj;
/* 197 */     return compareTo(hashCode.value);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 207 */     if (obj == this) return true;
/*     */ 
/* 209 */     if ((obj != null) && (obj.getClass() == getClass())) {
/* 210 */       return this.value == ((HashCode)obj).value;
/*     */     }
/*     */ 
/* 213 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 222 */     return String.valueOf(this.value);
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 232 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 235 */     throw new InternalError();
/*     */   }
/*     */ 
/*     */   public static int generate(boolean value)
/*     */   {
/* 250 */     return value ? 1231 : 1237;
/*     */   }
/*     */ 
/*     */   public static int generate(long value)
/*     */   {
/* 260 */     return (int)(value ^ value >> 32);
/*     */   }
/*     */ 
/*     */   public static int generate(double value)
/*     */   {
/* 270 */     return generate(Double.doubleToLongBits(value));
/*     */   }
/*     */ 
/*     */   public static int generate(float value)
/*     */   {
/* 280 */     return Float.floatToIntBits(value);
/*     */   }
/*     */ 
/*     */   public static int generate(byte[] bytes)
/*     */   {
/* 290 */     int hashcode = 0;
/*     */ 
/* 292 */     for (int i = 0; i < bytes.length; i++) {
/* 293 */       hashcode <<= 1;
/* 294 */       hashcode ^= bytes[i];
/*     */     }
/*     */ 
/* 297 */     return hashcode;
/*     */   }
/*     */ 
/*     */   public static int generate(Object[] array, boolean deep)
/*     */   {
/* 311 */     int hashcode = 0;
/*     */ 
/* 313 */     for (int i = 0; i < array.length; i++) {
/* 314 */       if ((deep) && ((array[i] instanceof Object[]))) {
/* 315 */         hashcode ^= generate((Object[])(Object[])array[i], true);
/*     */       }
/*     */       else {
/* 318 */         hashcode ^= array[i].hashCode();
/*     */       }
/*     */     }
/*     */ 
/* 322 */     return hashcode;
/*     */   }
/*     */ 
/*     */   public static int generate(Object[] array)
/*     */   {
/* 332 */     return generate(array, false);
/*     */   }
/*     */ 
/*     */   public static int generate(Object obj)
/*     */   {
/* 342 */     if (obj != null) {
/* 343 */       return obj.hashCode();
/*     */     }
/*     */ 
/* 346 */     return 0;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.HashCode
 * JD-Core Version:    0.6.0
 */