/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class Counter
/*     */   implements Serializable, Cloneable
/*     */ {
/*     */   private int count;
/*     */ 
/*     */   public Counter(int count)
/*     */   {
/*  44 */     this.count = count;
/*     */   }
/*     */ 
/*     */   public Counter()
/*     */   {
/*     */   }
/*     */ 
/*     */   public int increment()
/*     */   {
/*  58 */     return ++this.count;
/*     */   }
/*     */ 
/*     */   public int decrement()
/*     */   {
/*  67 */     return --this.count;
/*     */   }
/*     */ 
/*     */   public int getCount()
/*     */   {
/*  76 */     return this.count;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/*  83 */     this.count = 0;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  93 */     if (obj == this) return true;
/*     */ 
/*  95 */     if ((obj != null) && (obj.getClass() == getClass())) {
/*  96 */       return ((Counter)obj).count == this.count;
/*     */     }
/*     */ 
/*  99 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 108 */     return String.valueOf(this.count);
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 118 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 121 */     throw new InternalError();
/*     */   }
/*     */ 
/*     */   public static Counter makeSynchronized(Counter counter)
/*     */   {
/* 179 */     return new Wrapper(counter) {
/*     */       public synchronized int increment() {
/* 181 */         return this.counter.increment();
/*     */       }
/*     */ 
/*     */       public synchronized int decrement() {
/* 185 */         return this.counter.decrement();
/*     */       }
/*     */ 
/*     */       public synchronized int getCount() {
/* 189 */         return this.counter.getCount();
/*     */       }
/*     */ 
/*     */       public synchronized void reset() {
/* 193 */         this.counter.reset();
/*     */       }
/*     */ 
/*     */       public synchronized int hashCode() {
/* 197 */         return this.counter.hashCode();
/*     */       }
/*     */ 
/*     */       public synchronized boolean equals(Object obj) {
/* 201 */         return this.counter.equals(obj);
/*     */       }
/*     */ 
/*     */       public synchronized String toString() {
/* 205 */         return this.counter.toString();
/*     */       }
/*     */ 
/*     */       public synchronized Object clone() {
/* 209 */         return this.counter.clone();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public static Counter makeDirectional(Counter counter, boolean increasing)
/*     */   {
/*     */     Counter temp;
/*     */     Counter temp;
/* 226 */     if (increasing)
/* 227 */       temp = new Wrapper(counter) {
/*     */         public int decrement() {
/* 229 */           throw new UnsupportedOperationException();
/*     */         }
/*     */ 
/*     */         public void reset() {
/* 233 */           throw new UnsupportedOperationException();
/*     */         }
/*     */       };
/*     */     else {
/* 238 */       temp = new Wrapper(counter) {
/*     */         public int increment() {
/* 240 */           throw new UnsupportedOperationException();
/*     */         }
/*     */       };
/*     */     }
/* 245 */     return temp;
/*     */   }
/*     */ 
/*     */   private static class Wrapper extends Counter
/*     */   {
/*     */     protected final Counter counter;
/*     */ 
/*     */     public Wrapper(Counter counter)
/*     */     {
/* 140 */       this.counter = counter;
/*     */     }
/*     */ 
/*     */     public int increment() {
/* 144 */       return this.counter.increment();
/*     */     }
/*     */ 
/*     */     public int decrement() {
/* 148 */       return this.counter.decrement();
/*     */     }
/*     */ 
/*     */     public int getCount() {
/* 152 */       return this.counter.getCount();
/*     */     }
/*     */ 
/*     */     public void reset() {
/* 156 */       this.counter.reset();
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj) {
/* 160 */       return this.counter.equals(obj);
/*     */     }
/*     */ 
/*     */     public String toString() {
/* 164 */       return this.counter.toString();
/*     */     }
/*     */ 
/*     */     public Object clone() {
/* 168 */       return this.counter.clone();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Counter
 * JD-Core Version:    0.6.0
 */