/*     */ package org.jboss.tm.usertx.client;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.EventListener;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.TransactionManager;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.jboss.tm.TransactionManagerLocator;
/*     */ 
/*     */ public class ServerVMClientUserTransaction
/*     */   implements UserTransaction
/*     */ {
/*  57 */   private static final ServerVMClientUserTransaction singleton = new ServerVMClientUserTransaction();
/*     */   private final TransactionManager tm;
/*  66 */   private final Collection<UserTransactionStartedListener> listeners = new CopyOnWriteArrayList();
/*     */ 
/*     */   public static ServerVMClientUserTransaction getSingleton()
/*     */   {
/*  75 */     return singleton;
/*     */   }
/*     */ 
/*     */   private ServerVMClientUserTransaction()
/*     */   {
/*  86 */     this(TransactionManagerLocator.locateTransactionManager());
/*     */   }
/*     */ 
/*     */   public ServerVMClientUserTransaction(TransactionManager tm)
/*     */   {
/*  92 */     this.tm = tm;
/*     */   }
/*     */ 
/*     */   public void registerTxStartedListener(UserTransactionStartedListener txStartedListener)
/*     */   {
/* 101 */     if (txStartedListener == null)
/* 102 */       throw new IllegalArgumentException("Null listener");
/* 103 */     this.listeners.add(txStartedListener);
/*     */   }
/*     */ 
/*     */   public void unregisterTxStartedListener(UserTransactionStartedListener txStartedListener)
/*     */   {
/* 108 */     if (txStartedListener == null)
/* 109 */       throw new IllegalArgumentException("Null listener");
/* 110 */     this.listeners.remove(txStartedListener);
/*     */   }
/*     */ 
/*     */   public void begin()
/*     */     throws NotSupportedException, SystemException
/*     */   {
/* 119 */     this.tm.begin();
/* 120 */     for (UserTransactionStartedListener listener : this.listeners)
/* 121 */       listener.userTransactionStarted();
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException
/*     */   {
/* 133 */     this.tm.commit();
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws SecurityException, IllegalStateException, SystemException
/*     */   {
/* 141 */     this.tm.rollback();
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly()
/*     */     throws IllegalStateException, SystemException
/*     */   {
/* 148 */     this.tm.setRollbackOnly();
/*     */   }
/*     */ 
/*     */   public int getStatus()
/*     */     throws SystemException
/*     */   {
/* 154 */     return this.tm.getStatus();
/*     */   }
/*     */ 
/*     */   public void setTransactionTimeout(int seconds)
/*     */     throws SystemException
/*     */   {
/* 160 */     this.tm.setTransactionTimeout(seconds);
/*     */   }
/*     */ 
/*     */   public static abstract interface UserTransactionStartedListener extends EventListener
/*     */   {
/*     */     public abstract void userTransactionStarted()
/*     */       throws SystemException;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.usertx.client.ServerVMClientUserTransaction
 * JD-Core Version:    0.6.0
 */