/*     */ package org.jboss.system.server.profileservice.repository;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.net.URI;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.zip.ZipInputStream;
/*     */ import org.jboss.deployers.spi.attachments.Attachments;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
/*     */ import org.jboss.profileservice.spi.AttachmentsSerializer;
/*     */ import org.jboss.profileservice.spi.DeploymentRepository;
/*     */ import org.jboss.profileservice.spi.ModificationInfo;
/*     */ import org.jboss.profileservice.spi.ModificationInfo.ModifyStatus;
/*     */ import org.jboss.profileservice.spi.NoSuchDeploymentException;
/*     */ import org.jboss.profileservice.spi.NoSuchProfileException;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.util.file.Files;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class SerializableDeploymentRepository
/*     */   implements DeploymentRepository
/*     */ {
/*  73 */   private static final Logger log = Logger.getLogger(SerializableDeploymentRepository.class);
/*     */   private File root;
/*     */   private File bootstrapDir;
/*     */   private File libDir;
/*     */   private File deployersDir;
/*     */   private File[] applicationDirs;
/*     */   private File adminEditsRoot;
/*     */   private ProfileKey key;
/*  90 */   private LinkedHashMap<String, VFSDeployment> bootstrapCtxs = new LinkedHashMap();
/*     */ 
/*  92 */   private LinkedHashMap<String, VFSDeployment> deployerCtxs = new LinkedHashMap();
/*     */ 
/*  94 */   private LinkedHashMap<String, VFSDeployment> applicationCtxs = new LinkedHashMap();
/*     */   private AttachmentsSerializer serializer;
/*     */ 
/*     */   public SerializableDeploymentRepository(File root, URI[] appURIs, ProfileKey key)
/*     */   {
/* 100 */     this.root = root;
/* 101 */     this.key = key;
/* 102 */     setApplicationURIs(appURIs);
/*     */   }
/*     */ 
/*     */   public AttachmentsSerializer getSerializer()
/*     */   {
/* 107 */     return this.serializer;
/*     */   }
/*     */ 
/*     */   public void setSerializer(AttachmentsSerializer serializer) {
/* 111 */     this.serializer = serializer;
/*     */   }
/*     */ 
/*     */   public URI[] getApplicationURIs()
/*     */   {
/* 116 */     URI[] appURIs = new URI[this.applicationDirs.length];
/* 117 */     for (int n = 0; n < this.applicationDirs.length; n++)
/*     */     {
/* 119 */       File applicationDir = this.applicationDirs[n];
/* 120 */       appURIs[n] = applicationDir.toURI();
/*     */     }
/* 122 */     return appURIs;
/*     */   }
/*     */ 
/*     */   public void setApplicationURIs(URI[] uris) {
/* 126 */     this.applicationDirs = new File[uris.length];
/* 127 */     for (int n = 0; n < uris.length; n++)
/*     */     {
/* 129 */       URI uri = uris[n];
/* 130 */       this.applicationDirs[n] = new File(uri);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean exists()
/*     */   {
/* 136 */     File profileRoot = new File(this.root, this.key.getName());
/* 137 */     return profileRoot.exists();
/*     */   }
/*     */ 
/*     */   public URI getDeploymentURI(ManagedDeployment.DeploymentPhase phase)
/*     */   {
/* 142 */     URI uri = null;
/* 143 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 146 */       uri = getBootstrapURI();
/* 147 */       break;
/*     */     case 2:
/* 149 */       uri = getDeployersURI();
/* 150 */       break;
/*     */     case 3:
/* 152 */       uri = getApplicationURI();
/*     */     }
/*     */ 
/* 155 */     return uri;
/*     */   }
/*     */ 
/*     */   public void setDeploymentURI(URI uri, ManagedDeployment.DeploymentPhase phase) {
/* 159 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 162 */       setBootstrapURI(uri);
/* 163 */       break;
/*     */     case 2:
/* 165 */       setDeployersURI(uri);
/* 166 */       break;
/*     */     case 3:
/* 168 */       setApplicationURIs(new URI[] { uri });
/*     */     }
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNames()
/*     */   {
/* 174 */     HashSet names = new HashSet();
/* 175 */     names.addAll(this.bootstrapCtxs.keySet());
/* 176 */     names.addAll(this.deployerCtxs.keySet());
/* 177 */     names.addAll(this.applicationCtxs.keySet());
/* 178 */     return names;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase phase) {
/* 182 */     HashSet names = new HashSet();
/* 183 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 186 */       names.addAll(this.bootstrapCtxs.keySet());
/* 187 */       break;
/*     */     case 2:
/* 189 */       names.addAll(this.deployerCtxs.keySet());
/* 190 */       break;
/*     */     case 3:
/* 192 */       names.addAll(this.applicationCtxs.keySet());
/*     */     }
/*     */ 
/* 195 */     return names;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNamesForType(String type)
/*     */   {
/* 200 */     HashSet names = new HashSet();
/* 201 */     for (VFSDeployment ctx : this.bootstrapCtxs.values())
/*     */     {
/* 203 */       Set types = ctx.getTypes();
/* 204 */       if ((types != null) && (types.contains(type)))
/* 205 */         names.add(ctx.getName());
/*     */     }
/* 207 */     for (VFSDeployment ctx : this.deployerCtxs.values())
/*     */     {
/* 209 */       Set types = ctx.getTypes();
/* 210 */       if ((types != null) && (types.contains(type)))
/* 211 */         names.add(ctx.getName());
/*     */     }
/* 213 */     for (VFSDeployment ctx : this.applicationCtxs.values())
/*     */     {
/* 215 */       Set types = ctx.getTypes();
/* 216 */       if ((types != null) && (types.contains(type)))
/* 217 */         names.add(ctx.getName());
/*     */     }
/* 219 */     return names;
/*     */   }
/*     */ 
/*     */   public void addDeploymentContent(String name, ZipInputStream contentIS, ManagedDeployment.DeploymentPhase phase)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void addDeployment(String vfsPath, VFSDeployment d, ManagedDeployment.DeploymentPhase phase) throws Exception
/*     */   {
/* 229 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 232 */       addBootstrap(vfsPath, d);
/* 233 */       break;
/*     */     case 2:
/* 235 */       addDeployer(vfsPath, d);
/* 236 */       break;
/*     */     case 3:
/* 238 */       addApplication(vfsPath, d);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateDeployment(String vfsPath, VFSDeployment d, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public VFSDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception, NoSuchDeploymentException
/*     */   {
/* 250 */     VFSDeployment ctx = null;
/* 251 */     if (phase == null)
/*     */     {
/*     */       try
/*     */       {
/* 256 */         ctx = getBootstrap(name);
/*     */       }
/*     */       catch (NoSuchDeploymentException ignore)
/*     */       {
/*     */       }
/*     */       try
/*     */       {
/* 263 */         if (ctx == null)
/* 264 */           ctx = getDeployer(name);
/*     */       }
/*     */       catch (NoSuchDeploymentException ignore)
/*     */       {
/*     */       }
/*     */       try
/*     */       {
/* 271 */         if (ctx == null)
/* 272 */           ctx = getApplication(name);
/*     */       }
/*     */       catch (NoSuchDeploymentException ignore)
/*     */       {
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 280 */       switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */       {
/*     */       case 1:
/* 283 */         ctx = getBootstrap(name);
/* 284 */         break;
/*     */       case 2:
/* 286 */         ctx = getDeployer(name);
/* 287 */         break;
/*     */       case 3:
/* 289 */         ctx = getApplication(name);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 294 */     if (ctx == null)
/* 295 */       throw new NoSuchDeploymentException("name=" + name + ", phase=" + phase);
/* 296 */     return ctx;
/*     */   }
/*     */ 
/*     */   public Collection<VFSDeployment> getDeployments()
/*     */   {
/* 301 */     HashSet deployments = new HashSet();
/* 302 */     deployments.addAll(this.bootstrapCtxs.values());
/* 303 */     deployments.addAll(this.deployerCtxs.values());
/* 304 */     deployments.addAll(this.applicationCtxs.values());
/* 305 */     return Collections.unmodifiableCollection(deployments);
/*     */   }
/*     */ 
/*     */   public synchronized Collection<ModificationInfo> getModifiedDeployments()
/*     */     throws Exception
/*     */   {
/* 314 */     ArrayList modified = new ArrayList();
/* 315 */     Collection apps = getApplications();
/* 316 */     boolean trace = log.isTraceEnabled();
/* 317 */     if (trace)
/* 318 */       log.trace("Checking applications for modifications");
/* 319 */     if (apps != null)
/*     */     {
/* 321 */       Iterator iter = apps.iterator();
/* 322 */       while (iter.hasNext())
/*     */       {
/* 324 */         VFSDeployment ctx = (VFSDeployment)iter.next();
/* 325 */         VirtualFile root = ctx.getRoot();
/* 326 */         Long rootLastModified = Long.valueOf(root.getLastModified());
/* 327 */         String name = root.getPathName();
/*     */ 
/* 329 */         if (!root.exists())
/*     */         {
/* 331 */           ModificationInfo info = new ModificationInfo(ctx, rootLastModified.longValue(), ModificationInfo.ModifyStatus.REMOVED);
/* 332 */           modified.add(info);
/* 333 */           iter.remove();
/* 334 */           if (trace) {
/* 335 */             log.trace(name + " was removed");
/*     */           }
/*     */         }
/* 338 */         else if (root.hasBeenModified())
/*     */         {
/* 340 */           if (trace) {
/* 341 */             log.trace(name + " was modified: " + rootLastModified);
/*     */           }
/* 343 */           VFSDeployment ctx2 = loadDeploymentData(root);
/* 344 */           ModificationInfo info = new ModificationInfo(ctx2, rootLastModified.longValue(), ModificationInfo.ModifyStatus.MODIFIED);
/* 345 */           modified.add(info);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 350 */       for (File applicationDir : this.applicationDirs)
/*     */       {
/* 352 */         VFS deployVFS = VFS.getVFS(applicationDir.toURI());
/* 353 */         VirtualFile deployDir = deployVFS.getRoot();
/* 354 */         List children = deployDir.getChildren();
/* 355 */         for (VirtualFile vf : children)
/*     */         {
/* 357 */           URI uri = vf.toURI();
/* 358 */           if (!this.applicationCtxs.containsKey(uri.toString()))
/*     */           {
/* 360 */             VFSDeployment ctx = loadDeploymentData(vf);
/* 361 */             ModificationInfo info = new ModificationInfo(ctx, vf.getLastModified(), ModificationInfo.ModifyStatus.ADDED);
/* 362 */             modified.add(info);
/* 363 */             this.applicationCtxs.put(vf.getName(), ctx);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 368 */     return modified;
/*     */   }
/*     */ 
/*     */   public Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 374 */     Collection ctxs = null;
/* 375 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 378 */       ctxs = getBootstraps();
/* 379 */       break;
/*     */     case 2:
/* 381 */       ctxs = getDeployers();
/* 382 */       break;
/*     */     case 3:
/* 384 */       ctxs = getApplications();
/*     */     }
/*     */ 
/* 387 */     return ctxs;
/*     */   }
/*     */ 
/*     */   public VFSDeployment removeDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 393 */     VFSDeployment ctx = null;
/* 394 */     switch (1.$SwitchMap$org$jboss$managed$api$ManagedDeployment$DeploymentPhase[phase.ordinal()])
/*     */     {
/*     */     case 1:
/* 397 */       ctx = removeBootstrap(name);
/* 398 */       break;
/*     */     case 2:
/* 400 */       ctx = removeDeployer(name);
/* 401 */       break;
/*     */     case 3:
/* 403 */       ctx = removeApplication(name);
/*     */     }
/*     */ 
/* 406 */     return ctx;
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 410 */     StringBuilder tmp = new StringBuilder(super.toString());
/* 411 */     tmp.append("(root=");
/* 412 */     tmp.append(this.root);
/* 413 */     tmp.append(", key=");
/* 414 */     tmp.append(this.key);
/* 415 */     tmp.append(")");
/* 416 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/* 426 */     File profileRoot = new File(this.root, this.key.getName());
/* 427 */     if (profileRoot.exists() == true)
/* 428 */       throw new IOException("Profile root already exists: " + profileRoot);
/* 429 */     if (!profileRoot.mkdirs()) {
/* 430 */       throw new IOException("Failed to create profile root: " + profileRoot);
/*     */     }
/* 432 */     this.bootstrapDir = new File(profileRoot, "bootstrap");
/* 433 */     if (!this.bootstrapDir.mkdirs()) {
/* 434 */       throw new IOException("Failed to create profile bootstrap dir: " + this.bootstrapDir);
/*     */     }
/*     */ 
/* 437 */     this.deployersDir = new File(profileRoot, "deployers");
/* 438 */     if (!this.deployersDir.mkdirs()) {
/* 439 */       throw new IOException("Failed to create profile deployers dir: " + this.deployersDir);
/*     */     }
/*     */ 
/* 442 */     for (File applicationDir : this.applicationDirs)
/*     */     {
/* 444 */       if (!applicationDir.mkdirs()) {
/* 445 */         throw new IOException("Failed to create profile deploy dir: " + applicationDir);
/*     */       }
/*     */     }
/* 448 */     this.libDir = new File(profileRoot, "lib");
/* 449 */     if (!this.libDir.mkdirs()) {
/* 450 */       throw new IOException("Failed to create profile lib dir: " + this.libDir);
/*     */     }
/* 452 */     this.adminEditsRoot = new File(profileRoot, "profile/edits");
/* 453 */     if (!this.adminEditsRoot.mkdirs())
/* 454 */       throw new IOException("Failed to create profile adminEdits dir: " + this.adminEditsRoot);
/*     */   }
/*     */ 
/*     */   public void load()
/*     */     throws Exception, NoSuchProfileException
/*     */   {
/* 465 */     if (this.serializer == null) {
/* 466 */       throw new IllegalStateException("serializer has not been set");
/*     */     }
/* 468 */     File profileRoot = new File(this.root, this.key.getName());
/* 469 */     if (!profileRoot.exists()) {
/* 470 */       throw new NoSuchProfileException("Profile root does not exists: " + profileRoot);
/*     */     }
/* 472 */     this.bootstrapDir = new File(profileRoot, "bootstrap");
/* 473 */     if (!this.bootstrapDir.exists())
/*     */     {
/* 477 */       this.bootstrapDir = null;
/*     */     }
/*     */ 
/* 481 */     this.deployersDir = new File(profileRoot, "deployers");
/* 482 */     if (!this.deployersDir.exists()) {
/* 483 */       throw new FileNotFoundException("Profile contains no deployers dir: " + this.deployersDir);
/*     */     }
/*     */ 
/* 486 */     for (File applicationDir : this.applicationDirs)
/*     */     {
/* 488 */       if (!applicationDir.exists()) {
/* 489 */         throw new FileNotFoundException("Profile contains no deploy dir: " + applicationDir);
/*     */       }
/*     */     }
/* 492 */     this.adminEditsRoot = new File(profileRoot, "profile/edits");
/*     */ 
/* 494 */     if (this.bootstrapDir != null)
/*     */     {
/* 496 */       VFS bootstrapVFS = VFS.getVFS(this.bootstrapDir.toURI());
/* 497 */       loadBootstraps(bootstrapVFS.getRoot());
/*     */     }
/*     */     else
/*     */     {
/* 502 */       loadBootstraps(null);
/*     */     }
/* 504 */     VFS deployersVFS = VFS.getVFS(this.deployersDir.toURI());
/* 505 */     loadDeployers(deployersVFS.getRoot());
/* 506 */     for (File applicationDir : this.applicationDirs)
/*     */     {
/* 508 */       VFS deployVFS = VFS.getVFS(applicationDir.toURI());
/* 509 */       loadApplications(deployVFS.getRoot());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove()
/*     */     throws IOException, NoSuchProfileException
/*     */   {
/* 520 */     File profileRoot = new File(this.root, this.key.getName());
/* 521 */     Files.delete(profileRoot);
/*     */   }
/*     */ 
/*     */   protected void addBootstrap(String vfsPath, VFSDeployment ctx)
/*     */     throws Exception
/*     */   {
/* 527 */     this.bootstrapCtxs.put(vfsPath, ctx);
/*     */   }
/*     */ 
/*     */   public void addManagedObject(String vfsPath, Attachments edits)
/*     */     throws IOException
/*     */   {
/* 534 */     Map map = edits.getAttachments();
/* 535 */     File attachments = new File(this.adminEditsRoot, vfsPath + ".edits");
/* 536 */     FileOutputStream fos = new FileOutputStream(attachments);
/* 537 */     ObjectOutputStream oos = new ObjectOutputStream(fos);
/* 538 */     oos.writeObject(map);
/* 539 */     oos.close();
/* 540 */     fos.close();
/*     */   }
/*     */ 
/*     */   protected void addDeployer(String vfsPath, VFSDeployment ctx)
/*     */     throws Exception
/*     */   {
/* 546 */     this.deployerCtxs.put(vfsPath, ctx);
/*     */   }
/*     */ 
/*     */   protected void addApplication(String vfsPath, VFSDeployment ctx)
/*     */     throws Exception
/*     */   {
/* 552 */     this.applicationCtxs.put(vfsPath, ctx);
/*     */   }
/*     */ 
/*     */   protected VFSDeployment getBootstrap(String vfsPath)
/*     */     throws Exception
/*     */   {
/* 558 */     VFSDeployment ctx = (VFSDeployment)this.bootstrapCtxs.get(vfsPath);
/* 559 */     if (ctx == null)
/* 560 */       throw new NoSuchDeploymentException(vfsPath);
/* 561 */     return ctx;
/*     */   }
/*     */ 
/*     */   protected Collection<VFSDeployment> getBootstraps()
/*     */     throws Exception
/*     */   {
/* 567 */     Collection ctxs = this.bootstrapCtxs.values();
/* 568 */     return ctxs;
/*     */   }
/*     */ 
/*     */   protected URI getBootstrapURI()
/*     */   {
/* 573 */     return this.bootstrapDir.toURI();
/*     */   }
/*     */ 
/*     */   protected URI getDeployersURI() {
/* 577 */     return this.deployersDir.toURI();
/*     */   }
/*     */ 
/*     */   protected URI getApplicationURI() {
/* 581 */     File applicationDir = this.applicationDirs[0];
/* 582 */     return applicationDir.toURI();
/*     */   }
/*     */ 
/*     */   protected VFSDeployment getDeployer(String vfsPath) throws Exception
/*     */   {
/* 587 */     VFSDeployment ctx = (VFSDeployment)this.deployerCtxs.get(vfsPath);
/* 588 */     if (ctx == null)
/* 589 */       throw new NoSuchDeploymentException(vfsPath);
/* 590 */     return ctx;
/*     */   }
/*     */ 
/*     */   protected Collection<VFSDeployment> getDeployers()
/*     */     throws Exception
/*     */   {
/* 596 */     Collection ctxs = this.deployerCtxs.values();
/* 597 */     return ctxs;
/*     */   }
/*     */ 
/*     */   protected VFSDeployment getApplication(String vfsPath)
/*     */     throws Exception
/*     */   {
/* 603 */     VFSDeployment ctx = (VFSDeployment)this.applicationCtxs.get(vfsPath);
/* 604 */     if (ctx == null)
/* 605 */       throw new NoSuchDeploymentException(vfsPath);
/* 606 */     return ctx;
/*     */   }
/*     */ 
/*     */   protected Collection<VFSDeployment> getApplications()
/*     */     throws Exception
/*     */   {
/* 612 */     Collection ctxs = this.applicationCtxs.values();
/* 613 */     return ctxs;
/*     */   }
/*     */ 
/*     */   protected VFSDeployment removeBootstrap(String vfsPath) throws IOException
/*     */   {
/* 618 */     VFSDeployment vfsDeployment = (VFSDeployment)this.bootstrapCtxs.get(vfsPath);
/* 619 */     if (vfsDeployment == null)
/* 620 */       throw new IllegalStateException("Deployment not found: " + vfsPath);
/* 621 */     File bootstrapFile = new File(this.bootstrapDir, vfsDeployment.getSimpleName());
/* 622 */     if (!bootstrapFile.delete())
/* 623 */       throw new IOException("Failed to delete: " + bootstrapFile);
/* 624 */     return (VFSDeployment)this.bootstrapCtxs.remove(vfsPath);
/*     */   }
/*     */ 
/*     */   protected VFSDeployment removeDeployer(String vfsPath)
/*     */     throws IOException
/*     */   {
/* 630 */     VFSDeployment vfsDeployment = (VFSDeployment)this.deployerCtxs.get(vfsPath);
/* 631 */     if (vfsDeployment == null)
/* 632 */       throw new IllegalStateException("Deployment not found: " + vfsPath);
/* 633 */     File deployerFile = new File(this.deployersDir, vfsDeployment.getSimpleName());
/* 634 */     if (!Files.delete(deployerFile))
/* 635 */       throw new IOException("Failed to delete: " + deployerFile);
/* 636 */     return (VFSDeployment)this.deployerCtxs.remove(vfsPath);
/*     */   }
/*     */ 
/*     */   protected VFSDeployment removeApplication(String vfsPath) throws IOException {
/* 640 */     VFSDeployment vfsDeployment = (VFSDeployment)this.applicationCtxs.get(vfsPath);
/* 641 */     if (vfsDeployment == null) {
/* 642 */       throw new IllegalStateException("Deployment not found: " + vfsPath);
/*     */     }
/* 644 */     File applicationDir = this.applicationDirs[0];
/* 645 */     File deploymentFile = new File(applicationDir, vfsDeployment.getSimpleName());
/* 646 */     if (!Files.delete(deploymentFile))
/* 647 */       throw new IOException("Failed to delete: " + deploymentFile);
/* 648 */     return (VFSDeployment)this.applicationCtxs.remove(vfsPath);
/*     */   }
/*     */ 
/*     */   protected void setBootstrapURI(URI uri) {
/* 652 */     this.bootstrapDir = new File(uri);
/*     */   }
/*     */ 
/*     */   protected void setDeployersURI(URI uri) {
/* 656 */     this.deployersDir = new File(uri);
/*     */   }
/*     */ 
/*     */   private void loadBootstraps(VirtualFile bootstrapDir)
/*     */     throws IOException
/*     */   {
/* 668 */     if (bootstrapDir != null)
/*     */     {
/* 670 */       List children = bootstrapDir.getChildren();
/* 671 */       for (VirtualFile vf : children)
/*     */       {
/* 673 */         VFSDeployment vfCtx = loadDeploymentData(vf);
/* 674 */         this.bootstrapCtxs.put(vf.getName(), vfCtx);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 680 */       File profileRoot = new File(this.root, this.key.getName());
/* 681 */       File confDir = new File(profileRoot, "conf");
/* 682 */       VirtualFile confVF = VFS.getRoot(confDir.toURI());
/* 683 */       VirtualFile jbossServiceVF = confVF.findChild("jboss-service.xml");
/* 684 */       VFSDeployment vfCtx = loadDeploymentData(jbossServiceVF);
/* 685 */       this.bootstrapCtxs.put(vfCtx.getName(), vfCtx);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void loadDeployers(VirtualFile deployersDir)
/*     */     throws IOException
/*     */   {
/* 698 */     List children = deployersDir.getChildren();
/* 699 */     for (VirtualFile vf : children)
/*     */     {
/* 701 */       VFSDeployment vfCtx = loadDeploymentData(vf);
/* 702 */       this.deployerCtxs.put(vfCtx.getName(), vfCtx);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void loadApplications(VirtualFile applicationDir)
/*     */     throws IOException
/*     */   {
/* 715 */     List children = applicationDir.getChildren();
/* 716 */     for (VirtualFile vf : children)
/*     */     {
/* 718 */       VFSDeployment vfCtx = loadDeploymentData(vf);
/* 719 */       this.applicationCtxs.put(vfCtx.getName(), vfCtx);
/*     */     }
/*     */   }
/*     */ 
/*     */   private VFSDeployment loadDeploymentData(VirtualFile file)
/*     */   {
/* 732 */     VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(file);
/* 733 */     log.debug("Created deployment: " + deployment);
/* 734 */     return deployment;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.repository.SerializableDeploymentRepository
 * JD-Core Version:    0.6.0
 */