/*     */ package org.jboss.system.server.profileservice.repository;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import org.jboss.deployers.client.spi.main.MainDeployer;
/*     */ import org.jboss.profileservice.spi.DeploymentRepository;
/*     */ import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
/*     */ import org.jboss.profileservice.spi.NoSuchProfileException;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.profileservice.spi.ProfileRepository;
/*     */ 
/*     */ public class FileProfileRepository
/*     */   implements ProfileRepository
/*     */ {
/*     */   private File root;
/*     */   DeploymentRepositoryFactory repositoryFactory;
/*     */   private MainDeployer mainDeployer;
/*     */ 
/*     */   public FileProfileRepository()
/*     */   {
/*  59 */     this(null);
/*     */   }
/*     */ 
/*     */   public FileProfileRepository(File root) {
/*  63 */     this.root = root;
/*     */   }
/*     */ 
/*     */   public DeploymentRepositoryFactory getRepositoryFactory()
/*     */   {
/*  68 */     return this.repositoryFactory;
/*     */   }
/*     */ 
/*     */   public void setRepositoryFactory(DeploymentRepositoryFactory repositoryFactory) {
/*  72 */     this.repositoryFactory = repositoryFactory;
/*     */   }
/*     */ 
/*     */   public MainDeployer getMainDeployer() {
/*  76 */     return this.mainDeployer;
/*     */   }
/*     */ 
/*     */   public void setMainDeployer(MainDeployer mainDeployer) {
/*  80 */     this.mainDeployer = mainDeployer;
/*     */   }
/*     */ 
/*     */   public File getStoreRoot()
/*     */   {
/*  90 */     return this.root;
/*     */   }
/*     */ 
/*     */   public void setStoreRoot(File root)
/*     */   {
/*  99 */     this.root = root;
/*     */   }
/*     */ 
/*     */   public Collection<ProfileKey> getProfileKeys()
/*     */   {
/* 109 */     Collection keys = new HashSet();
/* 110 */     for (File profile : this.root.listFiles())
/*     */     {
/* 112 */       keys.add(new ProfileKey(profile.getName()));
/*     */     }
/* 114 */     return keys;
/*     */   }
/*     */ 
/*     */   public DeploymentRepository createProfileDeploymentRepository(ProfileKey key)
/*     */     throws Exception
/*     */   {
/* 123 */     DeploymentRepository repository = this.repositoryFactory.getDeploymentRepository(key);
/* 124 */     repository.create();
/* 125 */     return repository;
/*     */   }
/*     */ 
/*     */   public DeploymentRepository getProfileDeploymentRepository(ProfileKey key)
/*     */     throws Exception, NoSuchProfileException
/*     */   {
/* 134 */     DeploymentRepository repository = this.repositoryFactory.getDeploymentRepository(key);
/* 135 */     repository.load();
/* 136 */     return repository;
/*     */   }
/*     */ 
/*     */   public void removeProfileDeploymentRepository(ProfileKey key)
/*     */     throws Exception, NoSuchProfileException
/*     */   {
/* 142 */     DeploymentRepository repository = this.repositoryFactory.getDeploymentRepository(key);
/* 143 */     repository.remove();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.repository.FileProfileRepository
 * JD-Core Version:    0.6.0
 */