/*     */ package org.jboss.system.server.profileservice.basic;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import org.jboss.deployers.spi.management.ManagementView;
/*     */ import org.jboss.profileservice.spi.NoSuchProfileException;
/*     */ import org.jboss.profileservice.spi.Profile;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.profileservice.spi.ProfileService;
/*     */ import org.jboss.system.server.profile.basic.ProfileImpl;
/*     */ 
/*     */ public class ProfileServiceImpl
/*     */   implements ProfileService
/*     */ {
/*     */   private String name;
/*     */   private String profileRoot;
/*     */   private Profile defaultImpl;
/*     */   private ManagementView mgtView;
/*     */ 
/*     */   public ProfileServiceImpl(String name)
/*     */     throws IOException
/*     */   {
/*  53 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  59 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name) {
/*  63 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getProfileRoot() {
/*  67 */     return this.profileRoot;
/*     */   }
/*     */ 
/*     */   public void setProfileRoot(String profileRoot) {
/*  71 */     this.profileRoot = profileRoot;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  76 */     ProfileKey key = new ProfileKey(this.name);
/*  77 */     this.defaultImpl = new ProfileImpl(this.profileRoot, key);
/*     */   }
/*     */ 
/*     */   public String[] getDomains()
/*     */   {
/*  83 */     String[] domains = { "default" };
/*  84 */     return domains;
/*     */   }
/*     */ 
/*     */   public Collection<ProfileKey> getProfileKeys()
/*     */   {
/*  89 */     Collection keys = new HashSet();
/*  90 */     keys.add(new ProfileKey(null));
/*  91 */     return keys;
/*     */   }
/*     */ 
/*     */   public Profile getProfile(ProfileKey key)
/*     */     throws NoSuchProfileException
/*     */   {
/* 100 */     return this.defaultImpl;
/*     */   }
/*     */ 
/*     */   public Profile getActiveProfile() throws NoSuchProfileException
/*     */   {
/* 105 */     return this.defaultImpl;
/*     */   }
/*     */ 
/*     */   public String[] getProfileDeploymentNames(ProfileKey key)
/*     */     throws NoSuchProfileException
/*     */   {
/* 111 */     String[] names = { "default" };
/* 112 */     return names;
/*     */   }
/*     */ 
/*     */   public ManagementView getViewManager()
/*     */   {
/* 117 */     return this.mgtView;
/*     */   }
/*     */ 
/*     */   public void setViewManager(ManagementView mgtView) {
/* 121 */     this.mgtView = mgtView;
/*     */   }
/*     */ 
/*     */   public Profile newProfile(ProfileKey key)
/*     */   {
/* 127 */     return new ProfileImpl(this.profileRoot, key);
/*     */   }
/*     */ 
/*     */   public void removeProfile(ProfileKey key)
/*     */     throws NoSuchProfileException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.basic.ProfileServiceImpl
 * JD-Core Version:    0.6.0
 */