/*     */ package org.jboss.system.server.profileservice;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.profileservice.spi.Profile;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.profileservice.spi.ProfileService;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ 
/*     */ public abstract class VFSScanner extends JBossObject
/*     */ {
/*     */   private ProfileService profileService;
/*     */   private ProfileKey profileKey;
/*     */   private URI serverHomeURI;
/*  68 */   private List<URI> uriList = new CopyOnWriteArrayList();
/*     */ 
/*  71 */   private List<VirtualFile> vdfList = new CopyOnWriteArrayList();
/*     */   private VirtualFileFilter filter;
/*  77 */   private boolean doRecursiveSearch = true;
/*     */ 
/*  80 */   private Map<VirtualFile, String> deployedSet = new ConcurrentHashMap();
/*     */ 
/*  83 */   private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
/*     */ 
/*     */   public ProfileKey getProfileKey()
/*     */   {
/*  92 */     return this.profileKey;
/*     */   }
/*     */ 
/*     */   public void setProfileKey(ProfileKey profileKey)
/*     */   {
/* 102 */     this.profileKey = profileKey;
/*     */   }
/*     */ 
/*     */   public ProfileService getProfileService()
/*     */   {
/* 112 */     return this.profileService;
/*     */   }
/*     */ 
/*     */   public void setProfileService(ProfileService profileService)
/*     */   {
/* 122 */     this.profileService = profileService;
/*     */   }
/*     */ 
/*     */   public void setURIs(String listspec)
/*     */     throws URISyntaxException, IOException
/*     */   {
/* 134 */     if (listspec == null)
/*     */     {
/* 136 */       throw new NullPointerException("listspec argument cannot be null");
/*     */     }
/* 138 */     List list = new LinkedList();
/*     */ 
/* 140 */     StringTokenizer stok = new StringTokenizer(listspec, ",");
/* 141 */     while (stok.hasMoreTokens())
/*     */     {
/* 143 */       String urispec = stok.nextToken().trim();
/*     */ 
/* 145 */       this.log.debug("Adding URI from spec: " + urispec);
/*     */ 
/* 147 */       URI uri = makeURI(urispec);
/*     */ 
/* 149 */       this.log.debug("URI: " + uri);
/*     */ 
/* 151 */       list.add(uri);
/*     */     }
/* 153 */     setURIList(list);
/*     */   }
/*     */ 
/*     */   public void setURIList(List<URI> list)
/*     */     throws IOException
/*     */   {
/* 164 */     if (list == null)
/*     */     {
/* 166 */       throw new NullPointerException("list argument cannot be null");
/*     */     }
/*     */ 
/* 170 */     this.uriList.clear();
/*     */ 
/* 172 */     for (int n = 0; n < list.size(); n++)
/*     */     {
/* 174 */       URI uri = (URI)list.get(n);
/* 175 */       if (uri == null)
/*     */       {
/* 177 */         throw new IllegalArgumentException("list element[" + n + "] is null");
/*     */       }
/* 179 */       addURI(uri);
/*     */     }
/* 181 */     this.log.debug("URI list: " + this.uriList);
/*     */   }
/*     */ 
/*     */   public List<URI> getURIList()
/*     */   {
/* 191 */     return new ArrayList(this.uriList);
/*     */   }
/*     */ 
/*     */   public void setRecursiveSearch(boolean recurse)
/*     */   {
/* 201 */     this.doRecursiveSearch = recurse;
/*     */   }
/*     */ 
/*     */   public boolean getRecursiveSearch()
/*     */   {
/* 211 */     return this.doRecursiveSearch;
/*     */   }
/*     */ 
/*     */   public void setFilter(String classname)
/*     */     throws ClassNotFoundException, IllegalAccessException, InstantiationException
/*     */   {
/* 226 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 227 */     Class filterClass = loader.loadClass(classname);
/* 228 */     this.filter = ((VirtualFileFilter)filterClass.newInstance());
/*     */   }
/*     */ 
/*     */   public String getFilter()
/*     */   {
/* 238 */     if (this.filter == null)
/*     */     {
/* 240 */       return null;
/*     */     }
/* 242 */     return this.filter.getClass().getName();
/*     */   }
/*     */ 
/*     */   public void setFilterInstance(VirtualFileFilter filter)
/*     */   {
/* 252 */     this.filter = filter;
/*     */   }
/*     */ 
/*     */   public VirtualFileFilter getFilterInstance()
/*     */   {
/* 262 */     return this.filter;
/*     */   }
/*     */ 
/*     */   public void addURI(URI uri)
/*     */     throws IOException
/*     */   {
/* 273 */     if (uri == null)
/*     */     {
/* 275 */       throw new NullPointerException("uri argument cannot be null");
/*     */     }
/* 277 */     if (this.uriList.add(uri) == true)
/*     */     {
/* 279 */       this.log.debug("Added URI: " + uri);
/* 280 */       VirtualFile vf = getVFforURI(uri);
/* 281 */       this.vdfList.add(vf);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeURI(URI uri)
/*     */     throws IOException
/*     */   {
/* 294 */     if (uri == null)
/*     */     {
/* 296 */       throw new NullPointerException("uri argument cannot be null");
/*     */     }
/* 298 */     VirtualFile vf = getVFforURI(uri);
/* 299 */     this.vdfList.remove(vf);
/* 300 */     boolean success = this.uriList.remove(uri);
/*     */ 
/* 302 */     if (success)
/*     */     {
/* 304 */       this.log.debug("Removed URI: " + uri);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean hasURI(URI uri)
/*     */   {
/* 316 */     if (uri == null)
/*     */     {
/* 318 */       throw new NullPointerException("uri argument cannot be null");
/*     */     }
/* 320 */     return this.uriList.contains(uri);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 332 */     this.vdfList.clear();
/* 333 */     for (Iterator i = this.uriList.iterator(); i.hasNext(); )
/*     */     {
/* 335 */       URI uri = (URI)i.next();
/* 336 */       VirtualFile vf = getVFforURI(uri);
/* 337 */       this.vdfList.add(vf);
/*     */     }
/* 339 */     if (this.profileKey == null)
/*     */     {
/* 341 */       this.profileKey = new ProfileKey("default");
/*     */     }
/* 343 */     scan();
/*     */   }
/*     */ 
/*     */   public synchronized void scan()
/*     */     throws Exception
/*     */   {
/* 353 */     if (this.vdfList == null)
/*     */     {
/* 355 */       throw new IllegalStateException("not initialized");
/*     */     }
/*     */ 
/* 358 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 361 */     if (trace)
/*     */     {
/* 363 */       this.log.trace("Scanning for new deployments");
/*     */     }
/*     */ 
/* 367 */     List toDeployList = new LinkedList();
/*     */     Iterator i;
/* 368 */     synchronized (this.vdfList)
/*     */     {
/* 370 */       for (i = this.vdfList.iterator(); i.hasNext(); )
/*     */       {
/* 372 */         VirtualFile component = (VirtualFile)i.next();
/* 373 */         if (component.isLeaf())
/*     */         {
/* 376 */           toDeployList.add(component);
/*     */         }
/*     */         else
/*     */         {
/* 381 */           addDeployments(toDeployList, component);
/*     */         }
/*     */       }
/*     */     }
/*     */     Iterator i;
/* 386 */     if (trace)
/*     */     {
/* 388 */       this.log.trace("toDeployList");
/* 389 */       for (i = toDeployList.iterator(); i.hasNext(); )
/*     */       {
/* 391 */         this.log.trace(i.next());
/*     */       }
/*     */     }
/* 394 */     LinkedList toRemoveList = new LinkedList();
/*     */ 
/* 396 */     synchronized (this.deployedSet)
/*     */     {
/* 399 */       for (VirtualFile deployedComponent : this.deployedSet.keySet())
/*     */       {
/* 401 */         if (!toDeployList.contains(deployedComponent))
/*     */         {
/* 403 */           toRemoveList.add(deployedComponent);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 412 */     for (Iterator i = toRemoveList.iterator(); i.hasNext(); )
/*     */     {
/* 414 */       VirtualFile deployedComponent = (VirtualFile)i.next();
/* 415 */       undeploy(deployedComponent);
/*     */     }
/*     */ 
/* 422 */     for (Iterator i = toDeployList.iterator(); i.hasNext(); )
/*     */     {
/* 424 */       VirtualFile component = (VirtualFile)i.next();
/*     */ 
/* 427 */       if (!this.deployedSet.containsKey(component))
/*     */       {
/* 429 */         deploy(component);
/*     */       }
/*     */ 
/* 433 */       i.remove();
/*     */     }
/*     */   }
/*     */ 
/*     */   private URI makeURI(String urispec)
/*     */     throws URISyntaxException
/*     */   {
/* 449 */     urispec = StringPropertyReplacer.replaceProperties(urispec);
/* 450 */     return this.serverHomeURI.resolve(urispec);
/*     */   }
/*     */ 
/*     */   private void addDeployments(List<VirtualFile> list, VirtualFile root)
/*     */     throws IOException
/*     */   {
/* 466 */     List components = root.getChildren();
/*     */ 
/* 468 */     for (VirtualFile component : components)
/*     */     {
/* 471 */       if ((this.filter != null) && (!this.filter.accepts(component)))
/*     */         continue;
/* 473 */       if (component.isLeaf())
/*     */       {
/* 475 */         list.add(component);
/*     */       }
/* 478 */       else if ((component.getName().indexOf('.') == -1) && (this.doRecursiveSearch))
/*     */       {
/* 481 */         addDeployments(list, component);
/*     */       }
/*     */       else
/*     */       {
/* 485 */         list.add(component);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void deploy(VirtualFile component)
/*     */   {
/* 498 */     if (this.profileService == null)
/*     */     {
/* 500 */       return;
/*     */     }
/* 502 */     if (this.log.isTraceEnabled())
/*     */     {
/* 504 */       this.log.trace("Deploying: " + component);
/*     */     }
/*     */ 
/* 507 */     VFSDeployment deployment = null;
/*     */     try
/*     */     {
/* 510 */       Profile profile = this.profileService.getProfile(this.profileKey);
/* 511 */       deployment = add(profile, component);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 515 */       this.log.debug("Failed to deploy: " + component, e);
/*     */     }
/*     */ 
/* 518 */     if (!this.deployedSet.containsKey(component))
/*     */     {
/* 520 */       this.deployedSet.put(component, deployment.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void undeploy(VirtualFile component)
/*     */   {
/*     */     try
/*     */     {
/* 533 */       if (this.log.isTraceEnabled())
/*     */       {
/* 535 */         this.log.trace("Undeploying: " + component);
/*     */       }
/* 537 */       String name = (String)this.deployedSet.remove(component);
/* 538 */       Profile profile = this.profileService.getProfile(this.profileKey);
/* 539 */       remove(profile, name);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 543 */       this.log.error("Failed to undeploy: " + component, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract VFSDeployment add(Profile paramProfile, VirtualFile paramVirtualFile)
/*     */     throws Exception;
/*     */ 
/*     */   protected abstract void remove(Profile paramProfile, String paramString)
/*     */     throws Exception;
/*     */ 
/*     */   protected VFSDeployment createDeployment(VirtualFile file)
/*     */   {
/* 574 */     if (file == null)
/* 575 */       throw new IllegalArgumentException("Null file");
/* 576 */     return this.deploymentFactory.createVFSDeployment(file);
/*     */   }
/*     */ 
/*     */   private VirtualFile getVFforURI(URI uri)
/*     */     throws IOException
/*     */   {
/* 582 */     VFS vfs = VFS.getVFS(uri);
/* 583 */     return vfs.getRoot();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.VFSScanner
 * JD-Core Version:    0.6.0
 */