/*     */ package org.jboss.system.server.profile.repository;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
/*     */ import org.jboss.profileservice.spi.DeploymentRepository;
/*     */ import org.jboss.profileservice.spi.ModificationInfo;
/*     */ import org.jboss.profileservice.spi.NoSuchDeploymentException;
/*     */ import org.jboss.profileservice.spi.Profile;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class ProfileImpl extends JBossObject
/*     */   implements Profile
/*     */ {
/*     */   private ProfileKey key;
/*     */   private String version;
/*     */   private DeploymentRepository repository;
/*     */   private volatile boolean hotdeployEnabled;
/*     */ 
/*     */   public ProfileImpl(DeploymentRepository repository, ProfileKey key)
/*     */   {
/*  65 */     this.key = key;
/*  66 */     this.repository = repository;
/*  67 */     this.log.info("Using repository:" + repository);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  72 */     return this.key.getName();
/*     */   }
/*     */ 
/*     */   public ProfileKey getKey()
/*     */   {
/*  77 */     return this.key;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/*  82 */     return this.version;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNames()
/*     */   {
/*  90 */     return this.repository.getDeploymentNames();
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase phase) {
/*  94 */     return this.repository.getDeploymentNames(phase);
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNamesForType(String type)
/*     */   {
/*  99 */     return this.repository.getDeploymentNamesForType(type);
/*     */   }
/*     */ 
/*     */   public VirtualFile getRootFile(ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 105 */     URI uri = this.repository.getDeploymentURI(phase);
/* 106 */     VirtualFile root = VFS.getRoot(uri);
/* 107 */     return root;
/*     */   }
/*     */ 
/*     */   public Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 113 */     return this.repository.getDeployments(phase);
/*     */   }
/*     */ 
/*     */   public Collection<VFSDeployment> getDeployments() throws Exception
/*     */   {
/* 118 */     return this.repository.getDeployments();
/*     */   }
/*     */ 
/*     */   public Collection<ModificationInfo> getModifiedDeployments()
/*     */     throws Exception
/*     */   {
/* 127 */     Collection modified = Collections.emptyList();
/* 128 */     if (this.hotdeployEnabled == true)
/* 129 */       modified = this.repository.getModifiedDeployments();
/* 130 */     return modified;
/*     */   }
/*     */ 
/*     */   public synchronized void enableModifiedDeploymentChecks(boolean flag)
/*     */   {
/* 137 */     this.hotdeployEnabled = flag;
/*     */   }
/*     */ 
/*     */   public void addDeployment(VFSDeployment d, ManagedDeployment.DeploymentPhase phase)
/*     */     throws Exception
/*     */   {
/* 143 */     String name = d.getName();
/* 144 */     this.repository.addDeployment(name, d, phase);
/*     */   }
/*     */ 
/*     */   public void updateDeployment(VFSDeployment d, ManagedDeployment.DeploymentPhase phase) throws Exception
/*     */   {
/* 149 */     this.repository.updateDeployment(d.getName(), d, phase);
/*     */   }
/*     */ 
/*     */   public VFSDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws Exception, NoSuchDeploymentException
/*     */   {
/* 154 */     return this.repository.getDeployment(name, phase);
/*     */   }
/*     */ 
/*     */   public VFSDeployment removeDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws Exception
/*     */   {
/* 159 */     return this.repository.removeDeployment(name, phase);
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getConfig()
/*     */   {
/* 165 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean hasDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */   {
/*     */     try
/*     */     {
/* 173 */       getDeployment(name, phase);
/* 174 */       return true;
/*     */     }
/*     */     catch (NoSuchDeploymentException e)
/*     */     {
/* 178 */       return false;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 182 */       this.log.warn("getDeployment return exception", e);
/* 183 */     }return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profile.repository.ProfileImpl
 * JD-Core Version:    0.6.0
 */