package org.jboss.system.server;

import java.io.File;
import java.net.URL;

public abstract interface ServerConfig
{
  public static final String DEFAULT_PARITION_NAME = "DefaultPartition";
  public static final String PARTITION_NAME_PROPERTY = "jboss.partition.name";
  public static final String PARTITION_UDP_PROPERTY = "jboss.partition.udpGroup";
  public static final String PARTITION_UDP_PORT_PROPERTY = "jgroups.udp.mcast_port";
  public static final String NATIVE_LOAD_PROPERTY = "jboss.native.load";
  public static final String NATIVE_DIR_PROPERTY = "jboss.native.dir";
  public static final String BOOT_LIBRARY_LIST = "jboss.boot.library.list";
  public static final String SERVER_TYPE = "jboss.server.type";
  public static final String BOOTSTRAP_URL = "jboss.bootstrap.url";
  public static final String ROOT_DEPLOYMENT_FILENAME = "jboss.server.root.deployment.filename";
  public static final String HOME_DIR = "jboss.home.dir";
  public static final String HOME_URL = "jboss.home.url";
  public static final String LIBRARY_URL = "jboss.lib.url";
  public static final String PATCH_URL = "jboss.patch.url";
  public static final String SERVER_NAME = "jboss.server.name";
  public static final String SERVER_BASE_DIR = "jboss.server.base.dir";
  public static final String SERVER_HOME_DIR = "jboss.server.home.dir";
  public static final String SERVER_LOG_DIR = "jboss.server.log.dir";
  public static final String SERVER_TEMP_DIR = "jboss.server.temp.dir";
  public static final String SERVER_DATA_DIR = "jboss.server.data.dir";
  public static final String SERVER_BASE_URL = "jboss.server.base.url";
  public static final String SERVER_HOME_URL = "jboss.server.home.url";
  public static final String SERVER_CONFIG_URL = "jboss.server.config.url";
  public static final String SERVER_LIBRARY_URL = "jboss.server.lib.url";
  public static final String SERVER_BIND_ADDRESS = "jboss.bind.address";
  public static final String EXIT_ON_SHUTDOWN = "jboss.server.exitonshutdown";
  public static final String BLOCKING_SHUTDOWN = "jboss.server.blockingshutdown";
  public static final String INSTALL_LIFE_THREAD = "jboss.server.lifethread";
  public static final String REQUIRE_JBOSS_URL_STREAM_HANDLER_FACTORY = "jboss.server.requirejbossurlstreamhandlerfactory";
  public static final String PLATFORM_MBEANSERVER = "jboss.platform.mbeanserver";
  public static final String LIBRARY_URL_SUFFIX = "lib/";
  public static final String SERVER_CONFIG_URL_SUFFIX = "conf/";
  public static final String SERVER_BASE_DIR_SUFFIX = "server";
  public static final String SERVER_BASE_URL_SUFFIX = "server/";
  public static final String SERVER_DATA_DIR_SUFFIX = "data";
  public static final String SERVER_LOG_DIR_SUFFIX = "log";
  public static final String SERVER_TEMP_DIR_SUFFIX = "tmp";
  public static final String DEFAULT_SERVER_NAME = "default";
  public static final boolean DEFAULT_EXIT_ON_SHUTDOWN = true;
  public static final boolean DEFAULT_BLOCKING_SHUTDOWN = false;
  public static final boolean DEFAULT_INSTALL_LIFE_THREAD = true;
  public static final boolean DEFAULT_REQUIRE_JBOSS_URL_STREAM_HANDLER_FACTORY = true;
  public static final boolean DEFAULT_PLATFORM_MBEANSERVER = false;
  public static final String DEFAULT_ROOT_DEPLOYMENT_FILENAME = "jboss-service.xml";

  public abstract URL getBootstrapURL();

  public abstract File getHomeDir();

  public abstract URL getHomeURL();

  public abstract URL getLibraryURL();

  public abstract URL getPatchURL();

  public abstract String getServerName();

  public abstract File getServerBaseDir();

  public abstract File getServerHomeDir();

  public abstract File getServerLogDir();

  public abstract File getServerTempDir();

  public abstract File getServerDataDir();

  public abstract URL getServerBaseURL();

  public abstract URL getServerHomeURL();

  public abstract URL getServerLibraryURL();

  public abstract URL getServerConfigURL();

  public abstract boolean getPlatformMBeanServer();

  public abstract void setExitOnShutdown(boolean paramBoolean);

  public abstract boolean getExitOnShutdown();

  public abstract boolean getBlockingShutdown();

  public abstract void setBlockingShutdown(boolean paramBoolean);

  public abstract boolean isInstallLifeThread();

  public abstract boolean getRequireJBossURLStreamHandlerFactory();

  public abstract void setRequireJBossURLStreamHandlerFactory(boolean paramBoolean);

  public abstract void setRootDeploymentFilename(String paramString);

  public abstract String getRootDeploymentFilename();

  public abstract File getServerNativeDir();

  public abstract File getServerTempDeployDir();

  public abstract String getSpecificationVersion();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.ServerConfig
 * JD-Core Version:    0.6.0
 */