package org.jboss.system.server;

import java.util.Date;
import java.util.Properties;

public abstract interface Server
{
  public static final String START_NOTIFICATION_TYPE = "org.jboss.system.server.started";
  public static final String STOP_NOTIFICATION_TYPE = "org.jboss.system.server.stopped";

  public abstract Date getStartDate();

  public abstract String getVersion();

  public abstract String getVersionName();

  public abstract String getVersionNumber();

  public abstract String getBuildNumber();

  public abstract String getBuildJVM();

  public abstract String getBuildOS();

  public abstract String getBuildID();

  public abstract String getBuildDate();

  public abstract boolean isInShutdown();

  public abstract void init(Properties paramProperties)
    throws IllegalStateException, Exception;

  public abstract ServerConfig getConfig()
    throws IllegalStateException;

  public abstract void start()
    throws IllegalStateException, Exception;

  public abstract boolean isStarted();

  public abstract void shutdown()
    throws IllegalStateException;

  public abstract void exit(int paramInt);

  public abstract void exit();

  public abstract void halt(int paramInt);

  public abstract void halt();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.Server
 * JD-Core Version:    0.6.0
 */