/*    */ package org.jboss.system.microcontainer;
/*    */ 
/*    */ import java.util.List;
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.system.ServiceBinding;
/*    */ import org.jboss.system.ServiceConfigurator;
/*    */ import org.jboss.system.ServiceController;
/*    */ import org.jboss.system.metadata.ServiceMetaData;
/*    */ 
/*    */ public class ConfigureAction extends ServiceControllerContextAction
/*    */ {
/*    */   public void installAction(ServiceControllerContext context)
/*    */     throws Throwable
/*    */   {
/* 46 */     ServiceController controller = context.getServiceController();
/* 47 */     MBeanServer server = controller.getMBeanServer();
/* 48 */     ObjectName objectName = context.getObjectName();
/*    */ 
/* 51 */     ServiceMetaData metaData = context.getServiceMetaData();
/* 52 */     if (metaData != null)
/*    */     {
/* 54 */       List attrs = metaData.getAttributes();
/* 55 */       if (attrs.size() > 0)
/*    */       {
/* 57 */         ObjectName classLoaderName = metaData.getClassLoaderName();
/* 58 */         ServiceConfigurator.configure(null, controller, objectName, classLoaderName, attrs);
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 63 */     ServiceBinding serviceBinding = context.getServiceController().getServiceBinding();
/* 64 */     if (serviceBinding != null) {
/* 65 */       ServiceConfigurator.applyServiceConfig(server, objectName, serviceBinding);
/*    */     }
/* 67 */     context.getServiceContext().state = 1;
/*    */   }
/*    */ 
/*    */   public void uninstallAction(ServiceControllerContext context)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.microcontainer.ConfigureAction
 * JD-Core Version:    0.6.0
 */