/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ 
/*     */ public class ServiceAttributeMetaData extends AbstractMetaDataVisitorNode
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String name;
/*     */   private boolean trim;
/*     */   private boolean replace;
/*     */   private ServiceValueMetaData value;
/*     */ 
/*     */   public String getName()
/*     */   {
/*  61 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  71 */     if (name == null)
/*  72 */       throw new IllegalArgumentException("Null name");
/*  73 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public boolean isReplace()
/*     */   {
/*  83 */     return this.replace;
/*     */   }
/*     */ 
/*     */   public void setReplace(boolean replace)
/*     */   {
/*  93 */     this.replace = replace;
/*     */   }
/*     */ 
/*     */   public boolean isTrim()
/*     */   {
/* 103 */     return this.trim;
/*     */   }
/*     */ 
/*     */   public void setTrim(boolean trim)
/*     */   {
/* 113 */     this.trim = trim;
/*     */   }
/*     */ 
/*     */   public ServiceValueMetaData getValue()
/*     */   {
/* 123 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void setValue(ServiceValueMetaData value)
/*     */   {
/* 133 */     if (value == null)
/* 134 */       throw new IllegalArgumentException("Null value");
/* 135 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public Object getValue(ServiceValueContext valueContext)
/*     */     throws Exception
/*     */   {
/* 147 */     valueContext.setTrim(isTrim());
/* 148 */     valueContext.setReplace(isReplace());
/*     */     try
/*     */     {
/* 151 */       return this.value.getValue(valueContext);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 155 */       DeploymentException.rethrowAsDeploymentException("Error configuring attribute " + this.name, t);
/* 156 */     }throw new UnreachableStatementException();
/*     */   }
/*     */ 
/*     */   public void visit(ServiceMetaDataVisitor visitor)
/*     */   {
/* 162 */     visitor.setContextState(ControllerState.CONFIGURED);
/* 163 */     visitor.visit(this);
/*     */   }
/*     */ 
/*     */   protected void addChildren(Set<ServiceMetaDataVisitorNode> children)
/*     */   {
/* 169 */     if (this.value != null)
/* 170 */       children.add(this.value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceAttributeMetaData
 * JD-Core Version:    0.6.0
 */