/*     */ package org.jboss.system.deployers.managed;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.List;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.managed.spi.factory.InstanceClassFactory;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.MetaValueFactory;
/*     */ import org.jboss.system.metadata.ServiceAnnotationMetaData;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceDependencyValueMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.metadata.ServiceTextValueMetaData;
/*     */ import org.jboss.system.metadata.ServiceValueMetaData;
/*     */ 
/*     */ public class ServiceMetaDataICF
/*     */   implements InstanceClassFactory<ServiceMetaData>
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(ServiceMetaDataICF.class);
/*     */ 
/*  56 */   private static final String MOCLASS_ANNOTATION = '@' + ManagementObjectClass.class.getName();
/*     */   private MBeanServer mbeanServer;
/*  61 */   private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
/*     */ 
/*     */   public MBeanServer getMbeanServer()
/*     */   {
/*  65 */     return this.mbeanServer;
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer mbeanServer)
/*     */   {
/*  70 */     this.mbeanServer = mbeanServer;
/*     */   }
/*     */ 
/*     */   public Class<? extends Serializable> getManagedObjectClass(ServiceMetaData md)
/*     */     throws ClassNotFoundException
/*     */   {
/*     */     try
/*     */     {
/*  78 */       ClassLoader loader = this.mbeanServer.getClassLoader(md.getClassLoaderName());
/*  79 */       Class moClass = loader.loadClass(md.getCode());
/*     */ 
/*  83 */       List samlist = md.getAnnotations();
/*  84 */       for (ServiceAnnotationMetaData sam : samlist)
/*     */       {
/*  88 */         String anString = sam.getAnnotation();
/*  89 */         if (anString.startsWith(MOCLASS_ANNOTATION))
/*     */         {
/*  91 */           Class originalClass = moClass;
/*  92 */           ManagementObjectClass moc = (ManagementObjectClass)sam.getAnnotationInstance(loader);
/*  93 */           moClass = moc.code();
/*  94 */           log.debug("Using alternate class '" + moClass + "' for class " + originalClass);
/*  95 */           break;
/*     */         }
/*     */       }
/*  98 */       return moClass;
/*     */     }
/*     */     catch (InstanceNotFoundException e) {
/*     */     }
/* 102 */     throw new ClassNotFoundException("Failed to obtain mbean class loader", e);
/*     */   }
/*     */ 
/*     */   public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md)
/*     */   {
/* 109 */     String name = property.getMappedName();
/* 110 */     if (name == null) {
/* 111 */       property.getName();
/*     */     }
/*     */ 
/* 114 */     Object value = null;
/* 115 */     for (ServiceAttributeMetaData amd : md.getAttributes())
/*     */     {
/* 118 */       if (amd.getName().equalsIgnoreCase(name))
/*     */       {
/* 120 */         value = amd.getValue();
/* 121 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 125 */     if ((value instanceof ServiceTextValueMetaData))
/*     */     {
/* 127 */       ServiceTextValueMetaData text = (ServiceTextValueMetaData)value;
/* 128 */       value = text.getText();
/*     */     }
/* 130 */     else if ((value instanceof ServiceDependencyValueMetaData))
/*     */     {
/* 132 */       ServiceDependencyValueMetaData depends = (ServiceDependencyValueMetaData)value;
/* 133 */       value = depends.getDependency();
/*     */     }
/*     */ 
/* 137 */     PropertyInfo propertyInfo = beanInfo.getProperty(name);
/*     */     MetaValue mvalue;
/*     */     try {
/* 141 */       mvalue = this.metaValueFactory.create(value, propertyInfo.getType());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 145 */       log.debug("Failed to get property value for bean: " + beanInfo.getName() + ", property: " + propertyInfo.getName(), e);
/*     */ 
/* 147 */       mvalue = this.metaValueFactory.create(null, propertyInfo.getType());
/*     */     }
/* 149 */     return mvalue;
/*     */   }
/*     */ 
/*     */   public void setValue(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md, MetaValue value)
/*     */   {
/* 155 */     String name = property.getMappedName();
/* 156 */     if (name == null) {
/* 157 */       property.getName();
/*     */     }
/*     */ 
/* 160 */     ServiceValueMetaData attributeValue = null;
/* 161 */     for (ServiceAttributeMetaData amd : md.getAttributes())
/*     */     {
/* 164 */       if (amd.getName().equalsIgnoreCase(name))
/*     */       {
/* 166 */         attributeValue = amd.getValue();
/* 167 */         break;
/*     */       }
/*     */     }
/* 170 */     if (attributeValue != null)
/*     */     {
/* 172 */       PropertyInfo propertyInfo = beanInfo.getProperty(name);
/* 173 */       Object plainValue = this.metaValueFactory.unwrap(value, propertyInfo.getType());
/*     */ 
/* 176 */       if ((attributeValue instanceof ServiceTextValueMetaData))
/*     */       {
/* 178 */         ServiceTextValueMetaData text = (ServiceTextValueMetaData)attributeValue;
/* 179 */         text.setText(String.valueOf(plainValue));
/*     */       }
/* 181 */       else if ((value instanceof ServiceDependencyValueMetaData))
/*     */       {
/* 183 */         ServiceDependencyValueMetaData depends = (ServiceDependencyValueMetaData)attributeValue;
/* 184 */         depends.setDependency(String.valueOf(plainValue));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 189 */       throw new IllegalArgumentException("No matching attribute found: " + name + "/" + md);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getComponentName(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md, MetaValue value) {
/* 194 */     if ((beanInfo == null) || (property == null) || (value == null))
/*     */     {
/* 196 */       ObjectName objectName = md.getObjectName();
/* 197 */       if (objectName != null)
/* 198 */         return objectName.getCanonicalName();
/*     */     }
/* 200 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.deployers.managed.ServiceMetaDataICF
 * JD-Core Version:    0.6.0
 */