/*     */ package org.jboss.system.deployers;
/*     */ 
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
/*     */ import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.metadata.ServiceDeployment;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaDataParser;
/*     */ import org.jboss.util.xml.DOMWriter;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ServiceDeploymentDeployer extends AbstractComponentDeployer<ServiceDeployment, ServiceMetaData>
/*     */ {
/*     */   public ServiceDeploymentDeployer()
/*     */   {
/*  54 */     setDeploymentVisitor(new ServiceDeploymentVisitor());
/*  55 */     setComponentVisitor(new ServiceMetaDataVisitor());
/*     */   }
/*     */ 
/*     */   protected static void addServiceComponent(DeploymentUnit unit, ServiceMetaData service)
/*     */   {
/*  60 */     ObjectName objectName = service.getObjectName();
/*  61 */     String name = objectName.getCanonicalName();
/*  62 */     DeploymentUnit component = unit.addComponent(name);
/*  63 */     component.addAttachment(ServiceMetaData.class.getName(), service);
/*     */   }
/*     */ 
/*     */   protected static void removeServiceComponent(DeploymentUnit unit, ServiceMetaData service)
/*     */   {
/*  68 */     ObjectName objectName = service.getObjectName();
/*  69 */     String name = objectName.getCanonicalName();
/*  70 */     unit.removeComponent(name);
/*     */   }
/*     */ 
/*     */   public static class ServiceMetaDataVisitor
/*     */     implements DeploymentVisitor<ServiceMetaData>
/*     */   {
/*     */     public Class<ServiceMetaData> getVisitorType()
/*     */     {
/* 136 */       return ServiceMetaData.class;
/*     */     }
/*     */ 
/*     */     public void deploy(DeploymentUnit unit, ServiceMetaData deployment) throws DeploymentException
/*     */     {
/* 141 */       ServiceDeploymentDeployer.addServiceComponent(unit, deployment);
/*     */     }
/*     */ 
/*     */     public void undeploy(DeploymentUnit unit, ServiceMetaData deployment)
/*     */     {
/* 146 */       ServiceDeploymentDeployer.removeServiceComponent(unit, deployment);
/*     */     }
/*     */   }
/*     */ 
/*     */   public class ServiceDeploymentVisitor
/*     */     implements DeploymentVisitor<ServiceDeployment>
/*     */   {
/*     */     public ServiceDeploymentVisitor()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Class<ServiceDeployment> getVisitorType()
/*     */     {
/*  80 */       return ServiceDeployment.class;
/*     */     }
/*     */ 
/*     */     public void deploy(DeploymentUnit unit, ServiceDeployment deployment) throws DeploymentException
/*     */     {
/*     */       try
/*     */       {
/*  87 */         List services = deployment.getServices();
/*  88 */         if (services == null)
/*     */         {
/*  90 */           Element config = deployment.getConfig();
/*  91 */           if (config == null)
/*     */           {
/*  93 */             ServiceDeploymentDeployer.this.log.debug("Service deployment has no services: " + deployment.getName());
/*  94 */             return;
/*     */           }
/*  96 */           ServiceDeploymentDeployer.this.log.debug(DOMWriter.printNode(config, true));
/*  97 */           ServiceMetaDataParser parser = new ServiceMetaDataParser(config);
/*  98 */           services = parser.parse();
/*  99 */           deployment.setServices(services);
/*     */         }
/*     */ 
/* 102 */         if ((services == null) || (services.isEmpty())) {
/* 103 */           return;
/*     */         }
/* 105 */         for (ServiceMetaData service : services)
/* 106 */           ServiceDeploymentDeployer.addServiceComponent(unit, service);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 110 */         throw DeploymentException.rethrowAsDeploymentException("Error deploying: " + deployment.getName(), t);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void undeploy(DeploymentUnit unit, ServiceDeployment deployment)
/*     */     {
/* 116 */       List services = deployment.getServices();
/* 117 */       if (services == null) {
/* 118 */         return;
/*     */       }
/* 120 */       for (ServiceMetaData service : services)
/*     */       {
/* 122 */         ObjectName objectName = service.getObjectName();
/* 123 */         String name = objectName.getCanonicalName();
/* 124 */         unit.removeComponent(name);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.deployers.ServiceDeploymentDeployer
 * JD-Core Version:    0.6.0
 */