/*     */ package org.jboss.system.deployers;
/*     */ 
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.classloading.spi.RealClassLoader;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.system.ServiceContext;
/*     */ import org.jboss.system.ServiceController;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ 
/*     */ public class ServiceDeployer extends AbstractSimpleRealDeployer<ServiceMetaData>
/*     */ {
/*     */   private final ServiceController controller;
/*  50 */   public static final ObjectName DEFAULT_CLASSLOADER_OBJECT_NAME = ObjectNameFactory.create("jboss:service=defaultClassLoader");
/*     */ 
/*  52 */   private ObjectName defaultClassLoader = DEFAULT_CLASSLOADER_OBJECT_NAME;
/*     */ 
/*     */   public ServiceDeployer(ServiceController controller)
/*     */   {
/*  62 */     super(ServiceMetaData.class);
/*  63 */     if (controller == null)
/*  64 */       throw new IllegalArgumentException("Null controller");
/*  65 */     this.controller = controller;
/*  66 */     setComponentsOnly(true);
/*     */   }
/*     */ 
/*     */   public ObjectName getDefaultClassLoader()
/*     */   {
/*  72 */     return this.defaultClassLoader;
/*     */   }
/*     */ 
/*     */   public void setDefaultClassLoader(ObjectName defaultClassLoader)
/*     */   {
/*  77 */     this.defaultClassLoader = defaultClassLoader;
/*     */   }
/*     */ 
/*     */   public void deploy(DeploymentUnit unit, ServiceMetaData deployment) throws DeploymentException
/*     */   {
/*  82 */     ObjectName name = deployment.getObjectName();
/*     */     try
/*     */     {
/*  85 */       ObjectName loaderName = deployment.getClassLoaderName();
/*  86 */       if (loaderName == null)
/*     */       {
/*  88 */         ClassLoader cl = unit.getClassLoader();
/*  89 */         if ((cl != null) && ((cl instanceof RepositoryClassLoader))) {
/*  90 */           loaderName = ((RepositoryClassLoader)cl).getObjectName();
/*     */         }
/*  92 */         else if ((cl != null) && ((cl instanceof RealClassLoader)))
/*  93 */           loaderName = ((RealClassLoader)cl).getObjectName();
/*     */         else {
/*  95 */           loaderName = this.defaultClassLoader;
/*     */         }
/*     */       }
/*  98 */       this.controller.install(deployment, loaderName);
/*  99 */       ServiceContext context = this.controller.getServiceContext(name);
/* 100 */       if (context == null)
/* 101 */         throw new IllegalStateException("No context for " + name);
/*     */       try
/*     */       {
/* 104 */         create(context);
/*     */         try
/*     */         {
/* 107 */           start(context);
/* 108 */           Throwable t = context.getProblem();
/* 109 */           if (t != null)
/* 110 */             throw t;
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 114 */           destroy(name);
/* 115 */           throw t;
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 120 */         remove(name);
/* 121 */         throw t;
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 126 */       throw DeploymentException.rethrowAsDeploymentException("Error deploying: " + name, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void undeploy(DeploymentUnit unit, ServiceMetaData deployment)
/*     */   {
/* 132 */     ObjectName name = deployment.getObjectName();
/* 133 */     ServiceContext context = this.controller.getServiceContext(name);
/* 134 */     if (context != null)
/*     */     {
/* 136 */       stop(name);
/* 137 */       destroy(name);
/* 138 */       remove(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void create(ServiceContext context) throws Throwable
/*     */   {
/* 144 */     this.controller.create(context.objectName);
/*     */   }
/*     */ 
/*     */   protected void start(ServiceContext context) throws Throwable
/*     */   {
/* 149 */     this.controller.start(context.objectName);
/*     */   }
/*     */ 
/*     */   protected void stop(ObjectName name)
/*     */   {
/*     */     try
/*     */     {
/* 156 */       this.controller.stop(name);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 160 */       this.log.warn("Error during stop for " + name, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroy(ObjectName name)
/*     */   {
/*     */     try
/*     */     {
/* 168 */       this.controller.destroy(name);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 172 */       this.log.warn("Error during destroy for " + name, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void remove(ObjectName name)
/*     */   {
/*     */     try
/*     */     {
/* 180 */       this.controller.remove(name);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 184 */       this.log.warn("Error during destroy for " + name, t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.deployers.ServiceDeployer
 * JD-Core Version:    0.6.0
 */