/*     */ package org.jboss.system;
/*     */ 
/*     */ import javax.management.AttributeChangeNotification;
/*     */ import javax.management.JMException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.deployment.SARDeployerMBean;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
/*     */ import org.jboss.util.Classes;
/*     */ 
/*     */ public class ServiceMBeanSupport extends JBossNotificationBroadcasterSupport
/*     */   implements ServiceMBean, MBeanRegistration
/*     */ {
/*  57 */   public static final String[] SERVICE_CONTROLLER_SIG = { ObjectName.class.getName() };
/*     */   protected Logger log;
/*     */   protected MBeanServer server;
/*     */   protected ObjectName serviceName;
/*  73 */   private int state = 7;
/*     */ 
/*  76 */   private boolean isJBossInternalLifecycleExposed = false;
/*     */ 
/*     */   public ServiceMBeanSupport()
/*     */   {
/*  86 */     this.log = Logger.getLogger(getClass().getName());
/*  87 */     this.log.trace("Constructing");
/*     */   }
/*     */ 
/*     */   public ServiceMBeanSupport(Class type)
/*     */   {
/*  99 */     this(type.getName());
/*     */   }
/*     */ 
/*     */   public ServiceMBeanSupport(String category)
/*     */   {
/* 111 */     this(Logger.getLogger(category));
/*     */   }
/*     */ 
/*     */   public ServiceMBeanSupport(Logger log)
/*     */   {
/* 121 */     this.log = log;
/* 122 */     log.trace("Constructing");
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 132 */     return Classes.stripPackageName(this.log.getName());
/*     */   }
/*     */ 
/*     */   public ObjectName getServiceName()
/*     */   {
/* 137 */     return this.serviceName;
/*     */   }
/*     */ 
/*     */   public DeploymentInfo getDeploymentInfo()
/*     */     throws JMException
/*     */   {
/* 151 */     Object[] args = { this.serviceName };
/* 152 */     String[] sig = { this.serviceName.getClass().getName() };
/* 153 */     DeploymentInfo sdi = (DeploymentInfo)this.server.invoke(SARDeployerMBean.OBJECT_NAME, "getService", args, sig);
/*     */ 
/* 155 */     return sdi;
/*     */   }
/*     */ 
/*     */   public MBeanServer getServer()
/*     */   {
/* 160 */     return this.server;
/*     */   }
/*     */ 
/*     */   public int getState()
/*     */   {
/* 165 */     return this.state;
/*     */   }
/*     */ 
/*     */   public String getStateString()
/*     */   {
/* 170 */     return states[this.state];
/*     */   }
/*     */ 
/*     */   public Logger getLog()
/*     */   {
/* 175 */     return this.log;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/* 185 */     if ((this.serviceName != null) && (this.isJBossInternalLifecycleExposed))
/* 186 */       this.server.invoke(ServiceController.OBJECT_NAME, "create", new Object[] { this.serviceName }, SERVICE_CONTROLLER_SIG);
/*     */     else
/* 188 */       jbossInternalCreate();
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 193 */     if ((this.serviceName != null) && (this.isJBossInternalLifecycleExposed))
/* 194 */       this.server.invoke(ServiceController.OBJECT_NAME, "start", new Object[] { this.serviceName }, SERVICE_CONTROLLER_SIG);
/*     */     else
/* 196 */       jbossInternalStart();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */     try
/*     */     {
/* 203 */       if ((this.serviceName != null) && (this.isJBossInternalLifecycleExposed))
/* 204 */         this.server.invoke(ServiceController.OBJECT_NAME, "stop", new Object[] { this.serviceName }, SERVICE_CONTROLLER_SIG);
/*     */       else
/* 206 */         jbossInternalStop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 210 */       this.log.warn("Error in stop " + jbossInternalDescription(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */     try
/*     */     {
/* 218 */       if ((this.serviceName != null) && (this.isJBossInternalLifecycleExposed))
/* 219 */         this.server.invoke(ServiceController.OBJECT_NAME, "destroy", new Object[] { this.serviceName }, SERVICE_CONTROLLER_SIG);
/*     */       else
/* 221 */         jbossInternalDestroy();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 225 */       this.log.warn("Error in destroy " + jbossInternalDescription(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String jbossInternalDescription()
/*     */   {
/* 231 */     if (this.serviceName != null) {
/* 232 */       return this.serviceName.toString();
/*     */     }
/* 234 */     return getName();
/*     */   }
/*     */ 
/*     */   public void jbossInternalLifecycle(String method) throws Exception
/*     */   {
/* 239 */     if (method == null) {
/* 240 */       throw new IllegalArgumentException("Null method name");
/*     */     }
/* 242 */     if (method.equals("create"))
/* 243 */       jbossInternalCreate();
/* 244 */     else if (method.equals("start"))
/* 245 */       jbossInternalStart();
/* 246 */     else if (method.equals("stop"))
/* 247 */       jbossInternalStop();
/* 248 */     else if (method.equals("destroy"))
/* 249 */       jbossInternalDestroy();
/*     */     else
/* 251 */       throw new IllegalArgumentException("Unknown lifecyle method " + method);
/*     */   }
/*     */ 
/*     */   protected void jbossInternalCreate() throws Exception
/*     */   {
/* 256 */     if ((this.state == 6) || (this.state == 2) || (this.state == 3) || (this.state == 1) || (this.state == 0))
/*     */     {
/* 259 */       this.log.debug("Ignoring create call; current state is " + getStateString());
/* 260 */       return;
/*     */     }
/*     */ 
/* 263 */     this.log.debug("Creating " + jbossInternalDescription());
/*     */     try
/*     */     {
/* 267 */       createService();
/* 268 */       this.state = 6;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 272 */       this.log.debug("Initialization failed " + jbossInternalDescription(), e);
/* 273 */       throw e;
/*     */     }
/*     */ 
/* 276 */     this.log.debug("Created " + jbossInternalDescription());
/*     */   }
/*     */ 
/*     */   protected void jbossInternalStart() throws Exception
/*     */   {
/* 281 */     if ((this.state == 2) || (this.state == 3) || (this.state == 1))
/*     */     {
/* 283 */       this.log.debug("Ignoring start call; current state is " + getStateString());
/* 284 */       return;
/*     */     }
/*     */ 
/* 287 */     if ((this.state != 6) && (this.state != 0) && (this.state != 4))
/*     */     {
/* 289 */       this.log.debug("Start requested before create, calling create now");
/* 290 */       create();
/*     */     }
/*     */ 
/* 293 */     this.state = 2;
/* 294 */     sendStateChangeNotification(0, 2, getName() + " starting", null);
/* 295 */     this.log.debug("Starting " + jbossInternalDescription());
/*     */     try
/*     */     {
/* 299 */       startService();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 303 */       this.state = 4;
/* 304 */       sendStateChangeNotification(2, 4, getName() + " failed", e);
/* 305 */       this.log.debug("Starting failed " + jbossInternalDescription(), e);
/* 306 */       throw e;
/*     */     }
/*     */ 
/* 309 */     this.state = 3;
/* 310 */     sendStateChangeNotification(2, 3, getName() + " started", null);
/* 311 */     this.log.debug("Started " + jbossInternalDescription());
/*     */   }
/*     */ 
/*     */   protected void jbossInternalStop()
/*     */   {
/* 316 */     if (this.state != 3)
/*     */     {
/* 318 */       this.log.debug("Ignoring stop call; current state is " + getStateString());
/* 319 */       return;
/*     */     }
/*     */ 
/* 322 */     this.state = 1;
/* 323 */     sendStateChangeNotification(3, 1, getName() + " stopping", null);
/* 324 */     this.log.debug("Stopping " + jbossInternalDescription());
/*     */     try
/*     */     {
/* 328 */       stopService();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 332 */       this.state = 4;
/* 333 */       sendStateChangeNotification(1, 4, getName() + " failed", e);
/* 334 */       this.log.warn("Stopping failed " + jbossInternalDescription(), e);
/* 335 */       return;
/*     */     }
/*     */ 
/* 338 */     this.state = 0;
/* 339 */     sendStateChangeNotification(1, 0, getName() + " stopped", null);
/* 340 */     this.log.debug("Stopped " + jbossInternalDescription());
/*     */   }
/*     */ 
/*     */   protected void jbossInternalDestroy()
/*     */   {
/* 345 */     if (this.state == 5)
/*     */     {
/* 347 */       this.log.debug("Ignoring destroy call; current state is " + getStateString());
/* 348 */       return;
/*     */     }
/*     */ 
/* 351 */     if (this.state == 3)
/*     */     {
/* 353 */       this.log.debug("Destroy requested before stop, calling stop now");
/* 354 */       stop();
/*     */     }
/*     */ 
/* 357 */     this.log.debug("Destroying " + jbossInternalDescription());
/*     */     try
/*     */     {
/* 361 */       destroyService();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 365 */       this.log.warn("Destroying failed " + jbossInternalDescription(), t);
/*     */     }
/* 367 */     this.state = 5;
/* 368 */     this.log.debug("Destroyed " + jbossInternalDescription());
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 392 */     this.server = server;
/*     */ 
/* 394 */     this.serviceName = getObjectName(server, name);
/*     */ 
/* 396 */     return this.serviceName;
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/* 401 */     if (!registrationDone.booleanValue())
/*     */     {
/* 403 */       this.log.info("Registration is not done -> stop");
/* 404 */       stop();
/*     */     }
/*     */     else
/*     */     {
/* 408 */       this.state = 8;
/*     */       try
/*     */       {
/* 412 */         MBeanInfo info = this.server.getMBeanInfo(this.serviceName);
/* 413 */         MBeanOperationInfo[] ops = info.getOperations();
/* 414 */         for (int i = 0; i < ops.length; i++)
/*     */         {
/* 416 */           if ((ops[i] == null) || (!"jbossInternalLifecycle".equals(ops[i].getName())))
/*     */             continue;
/* 418 */           this.isJBossInternalLifecycleExposed = true;
/* 419 */           break;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 425 */         this.log.warn("Unexcepted error accessing MBeanInfo for " + this.serviceName, t);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void preDeregister() throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/* 436 */     this.server = null;
/* 437 */     this.serviceName = null;
/* 438 */     this.state = 7;
/*     */   }
/*     */ 
/*     */   protected long getNextNotificationSequenceNumber()
/*     */   {
/* 449 */     return nextNotificationSequenceNumber();
/*     */   }
/*     */ 
/*     */   protected ObjectName getObjectName(MBeanServer server, ObjectName name)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 464 */     return name;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   private void sendStateChangeNotification(int oldState, int newState, String msg, Throwable t)
/*     */   {
/* 514 */     long now = System.currentTimeMillis();
/*     */ 
/* 516 */     AttributeChangeNotification stateChangeNotification = new AttributeChangeNotification(this, getNextNotificationSequenceNumber(), now, msg, "State", "java.lang.Integer", new Integer(oldState), new Integer(newState));
/*     */ 
/* 522 */     stateChangeNotification.setUserData(t);
/*     */ 
/* 524 */     sendNotification(stateChangeNotification);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.ServiceMBeanSupport
 * JD-Core Version:    0.6.0
 */