/*     */ package org.jboss.system;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.util.state.State;
/*     */ import org.jboss.util.state.StateMachine;
/*     */ import org.jboss.util.state.Transition;
/*     */ 
/*     */ public final class ServiceMBeanState
/*     */ {
/*  43 */   public static final State STATE_UNREGISTERED = new State("Unregistered");
/*  44 */   public static final State STATE_REGISTERED = new State("Registered");
/*  45 */   public static final State STATE_CREATED = new State("Created");
/*  46 */   public static final State STATE_STARTING = new State("Starting");
/*  47 */   public static final State STATE_STARTED = new State("Started");
/*  48 */   public static final State STATE_STOPPING = new State("Stopping");
/*  49 */   public static final State STATE_STOPPED = new State("Stopped");
/*  50 */   public static final State STATE_DESTROYED = new State("Destroyed");
/*  51 */   public static final State STATE_FAILED = new State("Failed");
/*     */ 
/*  54 */   public static final Transition TRANS_REGISTER = new Transition("register", STATE_REGISTERED);
/*  55 */   public static final Transition TRANS_CREATE = new Transition("create", STATE_CREATED);
/*  56 */   public static final Transition TRANS_START_BEGIN = new Transition("startBegin", STATE_STARTING);
/*  57 */   public static final Transition TRANS_START_END = new Transition("startEnd", STATE_STARTED);
/*  58 */   public static final Transition TRANS_STOP_BEGIN = new Transition("stopBegin", STATE_STOPPING);
/*  59 */   public static final Transition TRANS_STOP_END = new Transition("stopEnd", STATE_STOPPED);
/*  60 */   public static final Transition TRANS_DESTROY = new Transition("destroy", STATE_DESTROYED);
/*  61 */   public static final Transition TRANS_UNREGISTER = new Transition("unregister", STATE_UNREGISTERED);
/*  62 */   public static final Transition TRANS_FAIL = new Transition("fail", STATE_FAILED);
/*     */ 
/*  65 */   public static final Set STATES = new HashSet(Arrays.asList(new State[] { STATE_UNREGISTERED, STATE_REGISTERED, STATE_CREATED, STATE_STARTING, STATE_STARTED, STATE_STOPPING, STATE_STOPPED, STATE_DESTROYED, STATE_FAILED }));
/*     */ 
/*     */   public static StateMachine createStateMachine(String description)
/*     */   {
/* 130 */     return new StateMachine(STATES, STATE_UNREGISTERED, description);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  82 */     STATE_UNREGISTERED.addTransition(TRANS_REGISTER).addTransition(TRANS_FAIL);
/*     */ 
/*  86 */     STATE_REGISTERED.addTransition(TRANS_CREATE).addTransition(TRANS_UNREGISTER).addTransition(TRANS_FAIL);
/*     */ 
/*  91 */     STATE_CREATED.addTransition(TRANS_START_BEGIN).addTransition(TRANS_DESTROY).addTransition(TRANS_FAIL);
/*     */ 
/*  96 */     STATE_STARTING.addTransition(TRANS_START_END).addTransition(TRANS_FAIL);
/*     */ 
/* 100 */     STATE_STARTED.addTransition(TRANS_STOP_BEGIN).addTransition(TRANS_FAIL);
/*     */ 
/* 104 */     STATE_STOPPING.addTransition(TRANS_STOP_END).addTransition(TRANS_FAIL);
/*     */ 
/* 108 */     STATE_STOPPED.addTransition(TRANS_START_BEGIN).addTransition(TRANS_DESTROY).addTransition(TRANS_FAIL);
/*     */ 
/* 113 */     STATE_DESTROYED.addTransition(TRANS_CREATE).addTransition(TRANS_UNREGISTER).addTransition(TRANS_FAIL);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.ServiceMBeanState
 * JD-Core Version:    0.6.0
 */