/*     */ package org.jboss.system;
/*     */ 
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanConstructorInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.ReflectionException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ServiceDynamicMBeanSupport extends ServiceMBeanSupport
/*     */   implements DynamicMBean
/*     */ {
/*     */   public ServiceDynamicMBeanSupport()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceDynamicMBeanSupport(Class type)
/*     */   {
/*  76 */     super(type);
/*     */   }
/*     */ 
/*     */   public ServiceDynamicMBeanSupport(String category)
/*     */   {
/*  81 */     super(category);
/*     */   }
/*     */ 
/*     */   public ServiceDynamicMBeanSupport(Logger log)
/*     */   {
/*  86 */     super(log);
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/*  98 */     if ("State".equals(attribute))
/*     */     {
/* 100 */       return new Integer(getState());
/*     */     }
/* 102 */     if ("StateString".equals(attribute))
/*     */     {
/* 104 */       return getStateString();
/*     */     }
/* 106 */     if ("Name".equals(attribute))
/*     */     {
/* 108 */       return getName();
/*     */     }
/*     */ 
/* 113 */     return getInternalAttribute(attribute);
/*     */   }
/*     */ 
/*     */   public Object invoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/*     */     try
/*     */     {
/* 122 */       if ("jbossInternalLifecycle".equals(actionName))
/*     */       {
/* 124 */         jbossInternalLifecycle((String)params[0]);
/* 125 */         return null;
/*     */       }
/* 127 */       if ((params == null) || (params.length == 0))
/*     */       {
/* 129 */         if ("create".equals(actionName))
/*     */         {
/* 131 */           create(); return null;
/*     */         }
/* 133 */         if ("start".equals(actionName))
/*     */         {
/* 135 */           start(); return null;
/*     */         }
/* 137 */         if ("stop".equals(actionName))
/*     */         {
/* 139 */           stop(); return null;
/*     */         }
/* 141 */         if ("destroy".equals(actionName))
/*     */         {
/* 143 */           destroy(); return null;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 149 */       throw new MBeanException(e, "Exception in service lifecyle operation: " + actionName);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 156 */       return internalInvoke(actionName, params, signature);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 160 */     throw new MBeanException(e, "Exception invoking: " + actionName);
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 172 */     setInternalAttribute(attribute);
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributes)
/*     */   {
/* 177 */     AttributeList list = new AttributeList();
/* 178 */     if (attributes == null)
/* 179 */       return list;
/* 180 */     for (int i = 0; i < attributes.size(); i++)
/*     */     {
/* 182 */       Attribute attribute = (Attribute)attributes.get(i);
/*     */       try
/*     */       {
/* 185 */         setAttribute(attribute);
/* 186 */         list.add(attribute);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 190 */         this.log.debug("Error setting attribute " + attribute.getName(), t);
/*     */       }
/*     */     }
/* 193 */     return list;
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] attributes)
/*     */   {
/* 198 */     AttributeList list = new AttributeList();
/* 199 */     if (attributes == null)
/* 200 */       return list;
/* 201 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 205 */         Object value = getAttribute(attributes[i]);
/* 206 */         list.add(new Attribute(attributes[i], value));
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 210 */         this.log.debug("Error getting attribute " + attributes[i], t);
/*     */       }
/*     */     }
/* 213 */     return list;
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo()
/*     */   {
/* 218 */     MBeanParameterInfo[] noParams = new MBeanParameterInfo[0];
/*     */ 
/* 220 */     MBeanConstructorInfo[] ctorInfo = getInternalConstructorInfo();
/*     */ 
/* 222 */     MBeanAttributeInfo[] attrs = getInternalAttributeInfo();
/* 223 */     MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[3 + attrs.length];
/* 224 */     attrInfo[0] = new MBeanAttributeInfo("Name", "java.lang.String", "Return the service name", true, false, false);
/*     */ 
/* 230 */     attrInfo[1] = new MBeanAttributeInfo("State", "int", "Return the service state", true, false, false);
/*     */ 
/* 236 */     attrInfo[2] = new MBeanAttributeInfo("StateString", "java.lang.String", "Return the service's state as a String", true, false, false);
/*     */ 
/* 242 */     System.arraycopy(attrs, 0, attrInfo, 3, attrs.length);
/*     */ 
/* 244 */     MBeanParameterInfo[] jbossInternalLifecycleParms = new MBeanParameterInfo[1];
/* 245 */     jbossInternalLifecycleParms[0] = new MBeanParameterInfo("method", String.class.getName(), "The lifecycle method");
/*     */ 
/* 247 */     MBeanOperationInfo[] ops = getInternalOperationInfo();
/* 248 */     MBeanOperationInfo[] opInfo = new MBeanOperationInfo[5 + ops.length];
/* 249 */     opInfo[0] = new MBeanOperationInfo("create", "create service lifecycle operation", noParams, "void", 1);
/*     */ 
/* 255 */     opInfo[1] = new MBeanOperationInfo("start", "start service lifecycle operation", noParams, "void", 1);
/*     */ 
/* 261 */     opInfo[2] = new MBeanOperationInfo("stop", "stop service lifecycle operation", noParams, "void", 1);
/*     */ 
/* 267 */     opInfo[3] = new MBeanOperationInfo("destroy", "destroy service lifecycle operation", noParams, "void", 1);
/*     */ 
/* 273 */     opInfo[4] = new MBeanOperationInfo("jbossInternalLifecycle", "Internal lifecycle (for internal use)", jbossInternalLifecycleParms, "void", 1);
/*     */ 
/* 279 */     System.arraycopy(ops, 0, opInfo, 5, ops.length);
/*     */ 
/* 281 */     MBeanNotificationInfo[] notifyInfo = getInternalNotificationInfo();
/* 282 */     return new MBeanInfo(getClass().getName(), getInternalDescription(), attrInfo, ctorInfo, opInfo, notifyInfo);
/*     */   }
/*     */ 
/*     */   protected String getInternalDescription()
/*     */   {
/* 298 */     return "DynamicMBean Service";
/*     */   }
/*     */ 
/*     */   protected MBeanConstructorInfo[] getInternalConstructorInfo()
/*     */   {
/* 303 */     return new MBeanConstructorInfo[0];
/*     */   }
/*     */ 
/*     */   protected MBeanAttributeInfo[] getInternalAttributeInfo()
/*     */   {
/* 308 */     return new MBeanAttributeInfo[0];
/*     */   }
/*     */ 
/*     */   protected MBeanOperationInfo[] getInternalOperationInfo()
/*     */   {
/* 313 */     return new MBeanOperationInfo[0];
/*     */   }
/*     */ 
/*     */   protected MBeanNotificationInfo[] getInternalNotificationInfo()
/*     */   {
/* 318 */     return new MBeanNotificationInfo[0];
/*     */   }
/*     */ 
/*     */   protected Object getInternalAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 324 */     throw new AttributeNotFoundException("Attribute not found " + attribute);
/*     */   }
/*     */ 
/*     */   protected void setInternalAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 330 */     throw new AttributeNotFoundException("Attribute not found " + attribute);
/*     */   }
/*     */ 
/*     */   protected Object internalInvoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 336 */     StringBuffer buffer = new StringBuffer();
/* 337 */     buffer.append(actionName);
/* 338 */     buffer.append('(');
/* 339 */     for (int i = 0; i < signature.length; i++)
/*     */     {
/* 341 */       buffer.append(signature[i]);
/* 342 */       if (i < signature.length - 1)
/* 343 */         buffer.append(", ");
/*     */     }
/* 345 */     buffer.append(')');
/* 346 */     throw new MBeanException(new Exception("Operation not found " + buffer.toString()), "Operation not found " + actionName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.ServiceDynamicMBeanSupport
 * JD-Core Version:    0.6.0
 */