/*     */ package org.jboss.system;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class ServiceContext
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 7461263042948325633L;
/*  47 */   private static final String[] stateNames = { "INSTALLED", "CONFIGURED", "CREATED", "RUNNING", "FAILED", "STOPPED", "DESTROYED", "NOTYETINSTALLED" };
/*     */   public static final int INSTALLED = 0;
/*     */   public static final int CONFIGURED = 1;
/*     */   public static final int CREATED = 2;
/*     */   public static final int RUNNING = 3;
/*     */   public static final int FAILED = 4;
/*     */   public static final int STOPPED = 5;
/*     */   public static final int DESTROYED = 6;
/*     */   public static final int NOTYETINSTALLED = 7;
/*     */   public ObjectName objectName;
/*  72 */   public int state = 7;
/*     */ 
/*  75 */   public List<ServiceContext> iDependOn = new LinkedList();
/*     */ 
/*  78 */   public List<ServiceContext> dependsOnMe = new LinkedList();
/*     */   public transient Service proxy;
/*     */   public Throwable problem;
/*     */ 
/*     */   public String getStateString()
/*     */   {
/*  88 */     return getStateString(this.state);
/*     */   }
/*     */ 
/*     */   public static String getStateString(int stateInt)
/*     */   {
/*  93 */     return stateNames[stateInt];
/*     */   }
/*     */ 
/*     */   public Throwable getProblem()
/*     */   {
/*  98 */     return this.problem;
/*     */   }
/*     */ 
/*     */   public void setProblem(Throwable problem)
/*     */   {
/* 103 */     this.problem = problem;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 108 */     StringBuffer sbuf = new StringBuffer(512);
/*     */ 
/* 110 */     sbuf.append("ObjectName: ").append(this.objectName);
/* 111 */     sbuf.append("\n  State: ").append(stateNames[this.state]);
/*     */ 
/* 113 */     if ((this.state == 4) && (this.problem != null))
/*     */     {
/* 115 */       sbuf.append("\n  Reason: ").append(this.problem.toString());
/*     */     }
/* 117 */     printList(sbuf, "\n  I Depend On:", this.iDependOn);
/* 118 */     printList(sbuf, "\n  Depends On Me:", this.dependsOnMe);
/*     */ 
/* 121 */     sbuf.append("\n");
/*     */ 
/* 123 */     return sbuf.toString();
/*     */   }
/*     */ 
/*     */   private void printList(StringBuffer sbuf, String msg, List ctxs)
/*     */   {
/*     */     Iterator i;
/* 128 */     if (ctxs.size() > 0)
/*     */     {
/* 131 */       sbuf.append(msg);
/* 132 */       for (i = ctxs.iterator(); i.hasNext(); )
/*     */       {
/* 134 */         ServiceContext sc = (ServiceContext)i.next();
/* 135 */         sbuf.append("\n    ");
/* 136 */         sbuf.append(sc.objectName);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.ServiceContext
 * JD-Core Version:    0.6.0
 */