/*     */ package org.jboss.serial.util;
/*     */ 
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import org.apache.log4j.Logger;
/*     */ 
/*     */ public class StringUtil
/*     */ {
/*  38 */   static boolean optimizeStrings = true;
/*     */ 
/*  40 */   private static final Logger log = Logger.getLogger(StringUtil.class);
/*  41 */   private static final boolean isDebug = log.isDebugEnabled();
/*     */ 
/* 145 */   private static ThreadLocal currenBuffer = new ThreadLocal();
/*     */ 
/*     */   private static void flushByteBuffer(DataOutput out, byte[] byteBuffer, StringUtilBuffer.Position pos)
/*     */     throws IOException
/*     */   {
/*  46 */     out.write(byteBuffer, 0, pos.pos);
/*  47 */     pos.pos = 0;
/*     */   }
/*     */ 
/*     */   public static void saveString(DataOutput out, String str, StringUtilBuffer buffer) throws IOException
/*     */   {
/*  52 */     if (!optimizeStrings)
/*     */     {
/*  54 */       saveString(out, str);
/*  55 */       return;
/*     */     }
/*     */ 
/*  58 */     if (buffer == null)
/*     */     {
/*  60 */       buffer = getThreadLocalBuffer();
/*     */     }
/*     */ 
/*  63 */     long len = calculateUTFSize(str, buffer);
/*  64 */     if (len > 65535L)
/*     */     {
/*  66 */       out.writeBoolean(true);
/*  67 */       out.writeLong(len);
/*     */     }
/*     */     else
/*     */     {
/*  71 */       out.writeBoolean(false);
/*  72 */       out.writeShort((short)(int)len);
/*     */     }
/*     */ 
/*  75 */     if (len == str.length())
/*     */     {
/*  77 */       if (len > buffer.byteBuffer.length)
/*     */       {
/*  79 */         buffer.resizeByteBuffer((int)len);
/*     */       }
/*     */ 
/*  82 */       for (int byteLocation = 0; byteLocation < len; byteLocation++)
/*     */       {
/*  84 */         buffer.byteBuffer[byteLocation] = (byte)buffer.charBuffer[byteLocation];
/*     */       }
/*  86 */       out.write(buffer.byteBuffer, 0, (int)len);
/*     */     }
/*     */     else
/*     */     {
/*  90 */       if (isDebug)
/*     */       {
/*  92 */         log.debug("Saving string with utfSize=" + len + " stringSize=" + str.length());
/*     */       }
/*     */ 
/*  95 */       StringUtilBuffer.Position pos = buffer.position.reset();
/*     */ 
/*  97 */       int stringLength = str.length();
/*  98 */       for (int bufferPosition = 0; bufferPosition < stringLength; )
/*     */       {
/* 100 */         int countArray = Math.min(stringLength - bufferPosition, buffer.charBuffer.length);
/* 101 */         str.getChars(bufferPosition, bufferPosition + countArray, buffer.charBuffer, 0);
/*     */ 
/* 103 */         for (int i = 0; i < countArray; i++)
/*     */         {
/* 105 */           char charAtPos = buffer.charBuffer[i];
/* 106 */           if ((charAtPos >= '\001') && (charAtPos < ''))
/*     */           {
/* 108 */             if (pos.pos >= buffer.byteBuffer.length)
/*     */             {
/* 110 */               flushByteBuffer(out, buffer.byteBuffer, pos);
/*     */             }
/* 112 */             buffer.byteBuffer[(pos.pos++)] = (byte)charAtPos;
/*     */           }
/* 114 */           else if (charAtPos >= 'ࠀ')
/*     */           {
/* 116 */             if (pos.pos + 3 >= buffer.byteBuffer.length)
/*     */             {
/* 118 */               flushByteBuffer(out, buffer.byteBuffer, pos);
/*     */             }
/*     */ 
/* 121 */             buffer.byteBuffer[(pos.pos++)] = (byte)(0xE0 | charAtPos >> '\f' & 0xF);
/* 122 */             buffer.byteBuffer[(pos.pos++)] = (byte)(0x80 | charAtPos >> '\006' & 0x3F);
/* 123 */             buffer.byteBuffer[(pos.pos++)] = (byte)(0x80 | charAtPos >> '\000' & 0x3F);
/*     */           }
/*     */           else
/*     */           {
/* 127 */             if (pos.pos + 2 >= buffer.byteBuffer.length)
/*     */             {
/* 129 */               flushByteBuffer(out, buffer.byteBuffer, pos);
/*     */             }
/*     */ 
/* 132 */             buffer.byteBuffer[(pos.pos++)] = (byte)(0xC0 | charAtPos >> '\006' & 0x1F);
/* 133 */             buffer.byteBuffer[(pos.pos++)] = (byte)(0x80 | charAtPos >> '\000' & 0x3F);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 138 */         bufferPosition += countArray;
/*     */       }
/* 140 */       flushByteBuffer(out, buffer.byteBuffer, pos);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static StringUtilBuffer getThreadLocalBuffer()
/*     */   {
/* 149 */     StringUtilBuffer retValue = (StringUtilBuffer)currenBuffer.get();
/* 150 */     if (retValue == null)
/*     */     {
/* 152 */       retValue = new StringUtilBuffer();
/* 153 */       currenBuffer.set(retValue);
/*     */     }
/*     */ 
/* 156 */     return retValue;
/*     */   }
/*     */ 
/*     */   public static void saveString(DataOutput out, String str) throws IOException
/*     */   {
/* 161 */     if (optimizeStrings)
/*     */     {
/* 163 */       StringUtilBuffer buffer = getThreadLocalBuffer();
/* 164 */       saveString(out, str, buffer);
/*     */     }
/*     */     else
/*     */     {
/* 168 */       out.writeUTF(str);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void pullDataToBuffer(DataInput input, StringUtilBuffer.Position pos, byte[] byteBuffer, long currentPosition, long size)
/*     */     throws IOException
/*     */   {
/* 187 */     pos.pos = 0;
/*     */ 
/* 189 */     pos.size = (int)Math.min(size - currentPosition, byteBuffer.length);
/*     */ 
/* 191 */     input.readFully(byteBuffer, 0, (int)pos.size);
/*     */   }
/*     */ 
/*     */   public static String readString(DataInput input, StringUtilBuffer buffer) throws IOException
/*     */   {
/* 196 */     if (!optimizeStrings)
/*     */     {
/* 198 */       return input.readUTF();
/*     */     }
/*     */ 
/* 201 */     if (buffer == null)
/*     */     {
/* 203 */       buffer = getThreadLocalBuffer();
/*     */     }
/*     */ 
/* 206 */     long size = 0L;
/*     */ 
/* 208 */     boolean isLong = input.readBoolean();
/*     */ 
/* 210 */     if (isLong)
/*     */     {
/* 212 */       size = input.readLong();
/*     */     }
/*     */     else
/*     */     {
/* 216 */       size = input.readUnsignedShort();
/*     */     }
/*     */ 
/* 219 */     if (isDebug)
/*     */     {
/* 221 */       log.debug("Reading string with utfSize=" + size + " isLong=" + isLong);
/*     */     }
/*     */ 
/* 224 */     long count = 0L;
/*     */ 
/* 226 */     int charCount = 0;
/* 227 */     StringUtilBuffer.Position pos = buffer.position.reset();
/* 228 */     StringBuffer strbuffer = null;
/*     */ 
/* 230 */     while (count < size)
/*     */     {
/* 232 */       if (pos.pos >= pos.size)
/*     */       {
/* 234 */         if (isDebug)
/*     */         {
/* 236 */           log.debug("readString::pulling data to Buffer at pos " + pos.pos + " size= " + pos.size);
/*     */         }
/* 238 */         pullDataToBuffer(input, pos, buffer.byteBuffer, count, size);
/*     */       }
/* 240 */       int byte1 = buffer.byteBuffer[(pos.pos++)];
/* 241 */       count += 1L;
/*     */ 
/* 243 */       if ((byte1 > 0) && (byte1 <= 127))
/*     */       {
/* 245 */         buffer.charBuffer[(charCount++)] = (char)byte1;
/*     */       }
/*     */       else
/*     */       {
/* 249 */         int c = byte1 & 0xFF;
/*     */         int byte2;
/* 250 */         switch (c >> 4) {
/*     */         case 12:
/*     */         case 13:
/* 253 */           if (pos.pos >= pos.size)
/*     */           {
/* 255 */             if (isDebug)
/*     */             {
/* 257 */               log.debug("readString::pulling data to Buffer at pos test1 " + pos.pos + " size= " + pos.size);
/*     */             }
/* 259 */             pullDataToBuffer(input, pos, buffer.byteBuffer, count, size);
/*     */           }
/* 261 */           byte2 = buffer.byteBuffer[(pos.pos++)];
/* 262 */           buffer.charBuffer[(charCount++)] = (char)((c & 0x1F) << 6 | byte2 & 0x3F);
/*     */ 
/* 264 */           count += 1L;
/* 265 */           break;
/*     */         case 14:
/* 267 */           if (pos.pos >= pos.size)
/*     */           {
/* 269 */             if (isDebug)
/*     */             {
/* 271 */               log.debug("readString::pulling data to Buffer at pos test2 " + pos.pos + " size= " + pos.size);
/*     */             }
/* 273 */             pullDataToBuffer(input, pos, buffer.byteBuffer, count, size);
/*     */           }
/* 275 */           byte2 = buffer.byteBuffer[(pos.pos++)];
/* 276 */           count += 1L;
/* 277 */           if (pos.pos >= pos.size)
/*     */           {
/* 279 */             pullDataToBuffer(input, pos, buffer.byteBuffer, count, size);
/*     */           }
/* 281 */           int byte3 = buffer.byteBuffer[(pos.pos++)];
/* 282 */           buffer.charBuffer[(charCount++)] = (char)((c & 0xF) << 12 | (byte2 & 0x3F) << 6 | (byte3 & 0x3F) << 0);
/*     */ 
/* 285 */           count += 1L;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 291 */       if (charCount != buffer.charBuffer.length)
/*     */         continue;
/* 293 */       if (strbuffer == null)
/*     */       {
/* 295 */         strbuffer = new StringBuffer((int)size);
/*     */       }
/* 297 */       strbuffer.append(buffer.charBuffer);
/* 298 */       charCount = 0;
/*     */     }
/*     */ 
/* 302 */     if (strbuffer != null)
/*     */     {
/* 304 */       strbuffer.append(buffer.charBuffer, 0, charCount);
/* 305 */       return strbuffer.toString();
/*     */     }
/*     */ 
/* 309 */     return new String(buffer.charBuffer, 0, charCount);
/*     */   }
/*     */ 
/*     */   public static long calculateUTFSize(String str, StringUtilBuffer stringBuffer)
/*     */   {
/* 318 */     long calculatedLen = 0L;
/* 319 */     int stringLength = str.length();
/* 320 */     if (stringLength > stringBuffer.charBuffer.length)
/*     */     {
/* 322 */       stringBuffer.resizeCharBuffer(stringLength);
/*     */     }
/* 324 */     str.getChars(0, stringLength, stringBuffer.charBuffer, 0);
/*     */ 
/* 326 */     for (int i = 0; i < stringLength; i++)
/*     */     {
/* 328 */       char c = stringBuffer.charBuffer[i];
/*     */ 
/* 330 */       if ((c >= '\001') && (c < ''))
/*     */       {
/* 332 */         calculatedLen += 1L;
/*     */       }
/* 334 */       else if (c >= 'ࠀ')
/*     */       {
/* 336 */         calculatedLen += 3L;
/*     */       }
/*     */       else
/*     */       {
/* 340 */         calculatedLen += 2L;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 345 */     return calculatedLen;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.util.StringUtil
 * JD-Core Version:    0.6.0
 */