/*    */ package org.jboss.serial.util;
/*    */ 
/*    */ import java.io.ByteArrayOutputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import java.security.DigestOutputStream;
/*    */ import java.security.MessageDigest;
/*    */ import org.apache.log4j.Logger;
/*    */ 
/*    */ public class HashStringUtil
/*    */ {
/* 39 */   private static final Logger log = Logger.getLogger(HashStringUtil.class);
/* 40 */   private static final boolean isDebug = log.isDebugEnabled();
/*    */ 
/*    */   public static long hashName(String name) {
/*    */     RuntimeException rte;
/*    */     try {
/* 46 */       long hash = 0L;
/* 47 */       ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/* 48 */       MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/* 49 */       DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/* 50 */       dataoutputstream.writeUTF(name);
/* 51 */       dataoutputstream.flush();
/* 52 */       byte[] abyte0 = messagedigest.digest();
/* 53 */       for (int j = 0; j < Math.min(8, abyte0.length); j++) {
/* 54 */         hash += ((abyte0[j] & 0xFF) << j * 8);
/*    */       }
/* 56 */       if (isDebug)
/*    */       {
/* 58 */         log.debug("hash on field " + name + " = " + hash);
/*    */       }
/* 60 */       return hash;
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 64 */       rte = new RuntimeException(e);
/* 65 */     }throw rte;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.util.HashStringUtil
 * JD-Core Version:    0.6.0
 */