/*     */ package org.jboss.serial.references;
/*     */ 
/*     */ import java.lang.ref.Reference;
/*     */ import java.lang.ref.SoftReference;
/*     */ import java.lang.ref.WeakReference;
/*     */ import org.apache.log4j.Logger;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*     */ 
/*     */ public abstract class PersistentReference
/*     */ {
/*     */   public static final int REFERENCE_WEAK = 1;
/*     */   public static final int REFERENCE_SOFT = 2;
/*  44 */   private static final Logger log = Logger.getLogger(ClassMetaData.class);
/*  45 */   private static final boolean isDebug = log.isDebugEnabled();
/*     */   private WeakReference classReference;
/*     */   private Reference referencedObject;
/*  49 */   private int referenceType = 0;
/*     */ 
/*     */   public PersistentReference(Class clazz, Object referencedObject, int referenceType)
/*     */   {
/*  59 */     this.referenceType = referenceType;
/*  60 */     if (clazz != null)
/*     */     {
/*  62 */       this.classReference = new WeakReference(clazz);
/*     */     }
/*  64 */     buildReference(referencedObject);
/*     */   }
/*     */ 
/*     */   protected Object internalGet()
/*     */   {
/*  70 */     if (this.referencedObject == null) {
/*  71 */       return null;
/*     */     }
/*  73 */     return this.referencedObject.get();
/*     */   }
/*     */ 
/*     */   public Object get()
/*     */   {
/*  80 */     if (this.referencedObject == null) {
/*  81 */       return null;
/*     */     }
/*  83 */     Object returnValue = this.referencedObject.get();
/*  84 */     if (returnValue == null)
/*     */     {
/*     */       try
/*     */       {
/*  88 */         if (isDebug) log.debug("Reference on " + getClass().getName() + " being rebuilt");
/*     */ 
/*  91 */         return rebuildReference();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  95 */         throw new RuntimeException(e.getMessage(), e);
/*     */       }
/*     */     }
/*     */ 
/*  99 */     return returnValue;
/*     */   }
/*     */ 
/*     */   public abstract Object rebuildReference() throws Exception;
/*     */ 
/*     */   protected void buildReference(Object obj)
/*     */   {
/* 107 */     if (obj == null)
/*     */     {
/* 109 */       this.referencedObject = null;
/*     */     }
/* 113 */     else if (this.referenceType == 1)
/*     */     {
/* 115 */       this.referencedObject = new WeakReference(obj);
/*     */     }
/*     */     else
/*     */     {
/* 119 */       this.referencedObject = new SoftReference(obj);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class getMappedClass()
/*     */   {
/* 126 */     if (this.classReference == null) return null;
/* 127 */     Class returnClass = (Class)this.classReference.get();
/* 128 */     if (returnClass == null)
/*     */     {
/* 130 */       throw new RuntimeException("Class was already unloaded");
/*     */     }
/* 132 */     return returnClass;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.references.PersistentReference
 * JD-Core Version:    0.6.0
 */