/*     */ package org.jboss.serial.persister;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import org.apache.log4j.Logger;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaDataSlot;
/*     */ import org.jboss.serial.classmetamodel.ClassMetadataField;
/*     */ import org.jboss.serial.classmetamodel.FieldsManager;
/*     */ import org.jboss.serial.classmetamodel.StreamingClass;
/*     */ import org.jboss.serial.exception.SerializationException;
/*     */ import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
/*     */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*     */ 
/*     */ public class RegularObjectPersister
/*     */   implements Persister
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(RegularObjectPersister.class);
/*  48 */   private static final boolean isDebug = log.isDebugEnabled();
/*     */   byte id;
/*     */ 
/*     */   public byte getId()
/*     */   {
/*  53 */     return this.id;
/*     */   }
/*     */ 
/*     */   public void setId(byte id) {
/*  57 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public void writeData(ClassMetaData metaData, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution) throws IOException
/*     */   {
/*  62 */     defaultWrite(out, obj, metaData, substitution);
/*     */   }
/*     */ 
/*     */   public static void defaultWrite(ObjectOutput output, Object obj, ClassMetaData metaClass, ObjectSubstitutionInterface substitution)
/*     */     throws IOException
/*     */   {
/*  69 */     ClassMetaDataSlot[] slots = metaClass.getSlots();
/*     */ 
/*  71 */     if (isDebug)
/*     */     {
/*  73 */       log.debug("defaultWrite::" + metaClass.getClassName() + " contains " + slots.length + " slots");
/*     */     }
/*     */ 
/*  78 */     for (int slotNr = 0; slotNr < slots.length; slotNr++)
/*     */     {
/*  80 */       if (isDebug)
/*     */       {
/*  82 */         log.debug("defaultWrite:: slot " + slotNr + " NR=" + slots[slotNr].getSlotClass().getName() + " from parentClass=" + metaClass.getClassName());
/*     */       }
/*  84 */       if (slots[slotNr].getPrivateMethodWrite() != null)
/*     */       {
/*  86 */         writeSlotWithMethod(slots[slotNr], output, obj, substitution);
/*     */       }
/*     */       else
/*     */       {
/*  90 */         writeSlotWithFields(slots[slotNr], output, obj, substitution);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void readSlotWithMethod(ClassMetaDataSlot slot, short[] fieldsKey, ObjectInput input, Object obj, ObjectSubstitutionInterface substitution)
/*     */     throws IOException
/*     */   {
/*  98 */     if (isDebug)
/*     */     {
/* 100 */       log.debug("readSlotWithMethod slot=" + slot.getSlotClass().getName());
/*     */     }
/*     */     try {
/* 103 */       slot.getPrivateMethodRead().invoke(obj, new Object[] { new ObjectInputStreamProxy(input, fieldsKey, obj, slot, substitution) });
/*     */     } catch (IOException e) {
/* 105 */       throw e;
/*     */     } catch (Exception e) {
/* 107 */       IOException io = new IOException(e.getMessage());
/* 108 */       io.initCause(e);
/* 109 */       throw io;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void writeSlotWithMethod(ClassMetaDataSlot slot, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution) throws IOException
/*     */   {
/* 115 */     if (isDebug)
/*     */     {
/* 117 */       log.debug("writeSlotWithMethod slot=" + slot.getSlotClass().getName());
/*     */     }
/*     */     try {
/* 120 */       slot.getPrivateMethodWrite().invoke(obj, new Object[] { new ObjectOutputStreamProxy(out, obj, slot, substitution) });
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 124 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/* 127 */       log.fatal("error", e);
/* 128 */       e.printStackTrace();
/* 129 */       IOException io = new IOException(e.getMessage());
/* 130 */       io.initCause(e);
/* 131 */       throw io;
/*     */     }
/*     */   }
/*     */ 
/*     */   static void writeSlotWithFields(ClassMetaDataSlot slot, ObjectOutput output, Object obj, ObjectSubstitutionInterface substitution) throws IOException
/*     */   {
/* 137 */     ClassMetadataField[] fields = slot.getFields();
/*     */ 
/* 140 */     if (isDebug)
/*     */     {
/* 142 */       log.debug("writeSlotWithFields slot=" + slot.getSlotClass().getName() + " and " + fields.length + " fields");
/*     */     }
/*     */ 
/* 145 */     for (int fieldNR = 0; fieldNR < fields.length; fieldNR++)
/*     */     {
/* 147 */       ClassMetadataField field = fields[fieldNR];
/* 148 */       if (isDebug)
/*     */       {
/* 150 */         log.debug("writeSlotWithFields FieldNr=" + fieldNR);
/*     */       }
/*     */ 
/* 153 */       if ((field.getField().getType().isPrimitive()) && (!field.getField().getType().isArray()))
/*     */       {
/* 155 */         if (isDebug)
/*     */         {
/* 157 */           log.debug("writeSlotWithFields slot=" + slot.getSlotClass().getName() + " primitiveField " + fields[fieldNR].getFieldName() + " with object=NULL");
/*     */         }
/* 159 */         writeOnPrimitive(output, obj, field);
/*     */       }
/*     */       else
/*     */       {
/* 164 */         Object value = null;
/* 165 */         value = FieldsManager.getFieldsManager().getObject(obj, field);
/*     */ 
/* 167 */         if (isDebug)
/*     */         {
/* 169 */           if (value == null)
/*     */           {
/* 171 */             log.debug("writeSlotWithFields slot=" + slot.getSlotClass().getName() + " objectField " + fields[fieldNR].getFieldName() + " with object=NULL");
/*     */           }
/*     */           else
/*     */           {
/* 175 */             log.debug("writeSlotWithFields slot=" + slot.getSlotClass().getName() + " objectField " + fields[fieldNR].getFieldName() + " with object=" + value.getClass().getName());
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 182 */         output.writeObject(value);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void writeOnPrimitive(ObjectOutput out, Object obj, ClassMetadataField metaField)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 193 */       Field field = metaField.getField();
/* 194 */       Class clazz = field.getType();
/* 195 */       if (clazz == Integer.TYPE)
/*     */       {
/* 197 */         out.writeInt(FieldsManager.getFieldsManager().getInt(obj, metaField));
/*     */       }
/* 199 */       else if (clazz == Byte.TYPE)
/*     */       {
/* 201 */         out.writeByte(FieldsManager.getFieldsManager().getByte(obj, metaField));
/*     */       }
/* 203 */       else if (clazz == Long.TYPE)
/*     */       {
/* 205 */         out.writeLong(FieldsManager.getFieldsManager().getLong(obj, metaField));
/*     */       }
/* 207 */       else if (clazz == Float.TYPE)
/*     */       {
/* 209 */         out.writeFloat(FieldsManager.getFieldsManager().getFloat(obj, metaField));
/*     */       }
/* 211 */       else if (clazz == Double.TYPE)
/*     */       {
/* 213 */         out.writeDouble(FieldsManager.getFieldsManager().getDouble(obj, metaField));
/*     */       }
/* 215 */       else if (clazz == Short.TYPE)
/*     */       {
/* 217 */         out.writeShort(FieldsManager.getFieldsManager().getShort(obj, metaField));
/*     */       }
/* 219 */       else if (clazz == Character.TYPE)
/*     */       {
/* 221 */         out.writeChar(field.getChar(obj));
/* 222 */       } else if (clazz == Boolean.TYPE)
/*     */       {
/* 224 */         out.writeBoolean(field.getBoolean(obj));
/*     */       }
/* 226 */       else throw new RuntimeException("Unexpected datatype " + clazz.getName());
/*     */ 
/*     */     }
/*     */     catch (IllegalAccessException access)
/*     */     {
/* 231 */       IOException io = new IOException(access.getMessage());
/* 232 */       io.initCause(access);
/* 233 */       throw io;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object readData(ClassLoader loader, StreamingClass streaming, ClassMetaData metaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException
/*     */   {
/* 239 */     Object obj = metaData.newInstance();
/* 240 */     cache.putObjectInCacheRead(referenceId, obj);
/* 241 */     return defaultRead(input, obj, streaming, metaData, substitution);
/*     */   }
/*     */ 
/*     */   public static Object defaultRead(ObjectInput input, Object obj, StreamingClass streaming, ClassMetaData metaData, ObjectSubstitutionInterface substitution)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 252 */       ClassMetaDataSlot[] slots = metaData.getSlots();
/* 253 */       if (isDebug)
/*     */       {
/* 255 */         log.debug("defaultRead::class " + metaData.getClassName() + " contains " + slots.length + " slots");
/*     */       }
/*     */ 
/* 258 */       for (int slotNR = 0; slotNR < slots.length; slotNR++)
/*     */       {
/* 260 */         ClassMetaDataSlot slot = metaData.getSlots()[slotNR];
/*     */ 
/* 262 */         if (isDebug)
/*     */         {
/* 264 */           log.debug("defaultRead::slot[" + slotNR + "]=" + slot.getSlotClass().getName());
/*     */         }
/*     */ 
/* 267 */         if (slot.getPrivateMethodRead() != null)
/*     */         {
/* 269 */           readSlotWithMethod(slot, streaming.getKeyFields()[slotNR], input, obj, substitution);
/*     */         }
/*     */         else
/*     */         {
/* 273 */           readSlotWithFields(streaming.getKeyFields()[slotNR], slot, input, obj);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 278 */       return obj;
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 282 */     throw new SerializationException("Error reading " + obj.getClass().getName(), e);
/*     */   }
/*     */ 
/*     */   static void readSlotWithFields(short[] fieldsKey, ClassMetaDataSlot slot, ObjectInput input, Object obj)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 291 */     if (isDebug)
/*     */     {
/* 293 */       log.debug("readSlotWithFields slot=" + slot.getSlotClass().getName());
/*     */     }
/*     */ 
/* 296 */     short numberOfFields = (short)fieldsKey.length;
/* 297 */     for (short i = 0; i < numberOfFields; i = (short)(i + 1))
/*     */     {
/* 300 */       ClassMetadataField field = slot.getFields()[fieldsKey[i]];
/* 301 */       if (isDebug)
/*     */       {
/* 303 */         log.debug("FieldName on Read=" + field.getFieldName());
/*     */       }
/*     */ 
/* 308 */       if (field.getField().getType() == Integer.TYPE)
/*     */       {
/* 310 */         FieldsManager.getFieldsManager().setInt(obj, field, input.readInt());
/*     */       }
/* 313 */       else if (field.getField().getType() == Byte.TYPE)
/*     */       {
/* 315 */         FieldsManager.getFieldsManager().setByte(obj, field, input.readByte());
/*     */       }
/* 318 */       else if (field.getField().getType() == Long.TYPE)
/*     */       {
/* 320 */         FieldsManager.getFieldsManager().setLong(obj, field, input.readLong());
/*     */       }
/* 323 */       else if (field.getField().getType() == Float.TYPE)
/*     */       {
/* 325 */         FieldsManager.getFieldsManager().setFloat(obj, field, input.readFloat());
/*     */       }
/* 328 */       else if (field.getField().getType() == Double.TYPE)
/*     */       {
/* 330 */         FieldsManager.getFieldsManager().setDouble(obj, field, input.readDouble());
/*     */       }
/* 333 */       else if (field.getField().getType() == Short.TYPE)
/*     */       {
/* 335 */         FieldsManager.getFieldsManager().setShort(obj, field, input.readShort());
/*     */       }
/* 338 */       else if (field.getField().getType() == Character.TYPE)
/*     */       {
/* 340 */         FieldsManager.getFieldsManager().setCharacter(obj, field, input.readChar());
/*     */       }
/* 343 */       else if (field.getField().getType() == Boolean.TYPE)
/*     */       {
/* 345 */         FieldsManager.getFieldsManager().setBoolean(obj, field, input.readBoolean());
/*     */       }
/*     */       else
/*     */       {
/* 349 */         if (isDebug)
/*     */         {
/* 351 */           log.debug("readSlotWithFields slot=" + slot.getSlotClass().getName() + " field=" + field.getFieldName() + "<<-reading Object");
/*     */         }
/* 353 */         Object objTmp = input.readObject();
/* 354 */         FieldsManager.getFieldsManager().setObject(obj, field, objTmp);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean canPersist(Object obj)
/*     */   {
/* 362 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.persister.RegularObjectPersister
 * JD-Core Version:    0.6.0
 */