/*     */ package org.jboss.serial.persister;
/*     */ 
/*     */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*     */ 
/*     */ public class PersistResolver
/*     */ {
/*  32 */   static Persister arrayPersister = new ArrayPersister();
/*  33 */   static ExternalizePersister externalizePersister = new ExternalizePersister();
/*  34 */   static RegularObjectPersister defaultPersister = new RegularObjectPersister();
/*  35 */   static ClassReferencePersister classReferencePersister = new ClassReferencePersister();
/*  36 */   static ProxyPersister proxyPersister = new ProxyPersister();
/*  37 */   static Persister enumPersister = null;
/*     */ 
/*     */   public static Persister resolvePersister(byte id)
/*     */   {
/*  78 */     switch (id) {
/*     */     case 1:
/*  80 */       return defaultPersister;
/*     */     case 2:
/*  81 */       return arrayPersister;
/*     */     case 3:
/*  82 */       return externalizePersister;
/*     */     case 4:
/*  83 */       throw new RuntimeException("This persister is not valid any more");
/*     */     case 5:
/*  84 */       return classReferencePersister;
/*     */     case 6:
/*  85 */       return proxyPersister;
/*     */     case 7:
/*  87 */       if (enumPersister == null)
/*     */       {
/*  89 */         throw new RuntimeException("This current VM doesn't support Enumerations");
/*     */       }
/*  91 */       return enumPersister;
/*  92 */     }return defaultPersister;
/*     */   }
/*     */ 
/*     */   public static Persister resolvePersister(Object objToBeSerialized, ClassMetaData metaData)
/*     */   {
/*  98 */     if ((metaData.isArray()) && (!(objToBeSerialized instanceof Class)))
/*     */     {
/* 100 */       return arrayPersister;
/*     */     }
/* 102 */     if (((objToBeSerialized instanceof Class)) || (metaData.getClazz() == Class.class))
/*     */     {
/* 104 */       return classReferencePersister;
/*     */     }
/* 106 */     if (metaData.isExternalizable())
/*     */     {
/* 108 */       return externalizePersister;
/*     */     }
/* 110 */     if (metaData.isProxy())
/*     */     {
/* 112 */       return proxyPersister;
/*     */     }
/*     */ 
/* 115 */     if (enumPersister != null)
/*     */     {
/* 117 */       if (enumPersister.canPersist(objToBeSerialized))
/*     */       {
/* 119 */         return enumPersister;
/*     */       }
/*     */ 
/* 123 */       return defaultPersister;
/*     */     }
/*     */ 
/* 128 */     return defaultPersister;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  43 */       Class enumClass = Class.forName("java.lang.Enum");
/*  44 */       if (enumClass != null)
/*     */       {
/*     */         try
/*     */         {
/*  48 */           enumPersister = (Persister)PersistResolver.class.getClassLoader().loadClass("org.jboss.serial.persister.EnumerationPersister").newInstance();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*  52 */           e.printStackTrace();
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*     */     }
/*     */ 
/*  65 */     defaultPersister.setId(1);
/*  66 */     arrayPersister.setId(2);
/*  67 */     externalizePersister.setId(3);
/*  68 */     classReferencePersister.setId(5);
/*  69 */     proxyPersister.setId(6);
/*  70 */     if (enumPersister != null)
/*     */     {
/*  72 */       enumPersister.setId(7);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.persister.PersistResolver
 * JD-Core Version:    0.6.0
 */