/*     */ package org.jboss.serial.persister;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*     */ import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
/*     */ import org.jboss.serial.classmetamodel.StreamingClass;
/*     */ import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
/*     */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*     */ 
/*     */ public class EnumerationPersister
/*     */   implements Persister
/*     */ {
/*     */   byte id;
/*     */   static Class enumClass;
/*     */ 
/*     */   public byte getId()
/*     */   {
/*  54 */     return this.id;
/*     */   }
/*     */ 
/*     */   public void setId(byte id) {
/*  58 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public void writeData(ClassMetaData metaData, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution)
/*     */     throws IOException
/*     */   {
/*  65 */     Enum aEnum = (Enum)obj;
/*  66 */     out.writeUTF(aEnum.getDeclaringClass().getName());
/*  67 */     out.writeUTF(aEnum.name());
/*     */   }
/*     */   public Object readData(ClassLoader loader, StreamingClass streaming, ClassMetaData nonUsedmetaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
/*  74 */     String instanceName = null;
/*  75 */     Class enumClass = null;
/*  76 */     String classEnum = input.readUTF();
/*     */     IOException ioException;
/*     */     try { ClassMetaData enummetaData = ClassMetamodelFactory.getClassMetaData(classEnum, cache.getClassResolver(), loader, true);
/*  80 */       enumClass = enummetaData.getClazz();
/*  81 */       instanceName = input.readUTF();
/*  82 */       Object enumInstance = Enum.valueOf(enumClass, instanceName);
/*  83 */       if (enumInstance != null)
/*     */       {
/*  85 */         cache.putObjectInCacheRead(referenceId, enumInstance);
/*  86 */         return enumInstance;
/*     */       }
/*     */ 
/*  90 */       throw new IOException("Enumeration " + instanceName + " not found at Enum Class " + enumClass);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  95 */       ioException = new IOException(e.getMessage());
/*  96 */       ioException.initCause(e);
/*  97 */     }throw ioException;
/*     */   }
/*     */ 
/*     */   public boolean canPersist(Object obj)
/*     */   {
/* 103 */     if (enumClass != null)
/*     */     {
/* 105 */       return enumClass.isAssignableFrom(obj.getClass());
/*     */     }
/*     */ 
/* 109 */     return false;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  46 */       enumClass = Class.forName("java.lang.Enum");
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.persister.EnumerationPersister
 * JD-Core Version:    0.6.0
 */